/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.http;

import jade.core.Profile;
import jade.core.ProfileImpl;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.mtp.InChannel;
import jade.mtp.MTP;
import jade.mtp.MTPException;
import jade.mtp.TransportAddress;
import jade.mtp.http.HTTPAddress;
import jade.mtp.http.HTTPIO;
import jade.mtp.http.HTTPServer;
import jade.mtp.http.HTTPSocketFactory;
import jade.mtp.http.KeepAlive;
import jade.util.BasicProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;

public class MessageTransportProtocol
implements MTP {
    private static final int IN_PORT = 7778;
    private static final String OUT_PORT = "-1";
    private static final String PROXY_PORT = "1080";
    private static final String MAX_KA = "10";
    private static final String POLICY = "conservative";
    private static final String PREFIX = "jade_mtp_http_";
    private static final String TIMEOUT = "60000";
    private int numKA;
    private int outPort;
    private String proxyHost;
    private int proxyPort;
    private int timeout;
    private boolean policy;
    private boolean keepAlive = false;
    private boolean useProxy = false;
    private boolean useOutPort = false;
    private boolean useHttps = false;
    private String[] protocols = new String[]{"http", "https"};
    private String FIPA_NAME = "fipa.mts.mtp.http.std";
    private Hashtable addr2srv = new Hashtable();
    private KeepAlive ka;
    private Object lock = new Object();

    public TransportAddress strToAddr(String string) throws MTPException {
        try {
            return new HTTPAddress(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new MTPException("Address mismatch: this is not a valid HTTP address.");
        }
    }

    public String addrToStr(TransportAddress transportAddress) throws MTPException {
        try {
            return ((HTTPAddress)transportAddress).toString();
        }
        catch (Exception exception) {
            throw new MTPException(exception.toString());
        }
    }

    public String getName() {
        return this.FIPA_NAME;
    }

    public String[] getSupportedProtocols() {
        return this.protocols;
    }

    public TransportAddress activate(InChannel.Dispatcher dispatcher) throws MTPException {
        try {
            return this.activate(dispatcher, new ProfileImpl(new BasicProperties()));
        }
        catch (Exception exception) {
            throw new MTPException(exception.getMessage());
        }
    }

    public void activate(InChannel.Dispatcher dispatcher, TransportAddress transportAddress) throws MTPException {
        try {
            this.activate(dispatcher, transportAddress, new ProfileImpl(new BasicProperties()));
        }
        catch (Exception exception) {
            throw new MTPException(exception.getMessage());
        }
    }

    public TransportAddress activate(InChannel.Dispatcher dispatcher, Profile profile) throws MTPException {
        return this.activateServer(dispatcher, null, profile);
    }

    public void activate(InChannel.Dispatcher dispatcher, TransportAddress transportAddress, Profile profile) throws MTPException {
        this.activateServer(dispatcher, transportAddress, profile);
    }

    private TransportAddress activateServer(InChannel.Dispatcher dispatcher, TransportAddress transportAddress, Profile profile) throws MTPException {
        Object object;
        int n = -1;
        boolean bl = false;
        String string = null;
        HTTPAddress hTTPAddress = null;
        try {
            if (transportAddress != null) {
                hTTPAddress = (HTTPAddress)transportAddress;
            } else {
                try {
                    object = profile.getParameter("jade_mtp_http_port", null);
                    if (object != null) {
                        n = Integer.parseInt((String)object);
                    } else {
                        n = 7778;
                        bl = true;
                    }
                    hTTPAddress = new HTTPAddress(InetAddress.getLocalHost().getHostName(), n, this.useHttps);
                }
                catch (UnknownHostException unknownHostException) {
                    throw new MTPException("Cannot activate MTP on default address: Unknown Host");
                }
                catch (MalformedURLException malformedURLException) {
                    throw new MTPException("Cannot activate MTP on default address: Malformed URL");
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MTPException("Cannot activate MTP on default address: Invalid port");
                }
            }
            n = hTTPAddress.getPortNo();
            if (n <= 0 || n > 65535) {
                throw new MTPException("Invalid port number " + transportAddress.getPort());
            }
            this.numKA = Integer.parseInt(profile.getParameter("jade_mtp_http_numKeepAlive", MAX_KA));
            if (this.numKA > 0) {
                this.keepAlive = true;
                this.ka = new KeepAlive(this.numKA);
            }
            this.policy = profile.getParameter("jade_mtp_http_policy", POLICY).equals("aggressive");
            this.outPort = Integer.parseInt(profile.getParameter("jade_mtp_http_outPort", OUT_PORT));
            if (this.outPort != -1) {
                this.useOutPort = true;
            }
            this.proxyHost = profile.getParameter("jade_mtp_http_proxyHost", null);
            if (this.proxyHost != null) {
                this.useProxy = true;
                this.proxyPort = Integer.parseInt(profile.getParameter("jade_mtp_http_proxyPort", PROXY_PORT));
            }
            string = profile.getParameter("jade_mtp_http_parser", null);
            this.timeout = Integer.parseInt(profile.getParameter("jade_mtp_http_timeout", TIMEOUT));
            try {
                HTTPSocketFactory.getInstance().configure(profile, hTTPAddress);
            }
            catch (Exception exception) {
                throw new MTPException("Error configuring Socket Factory", exception);
            }
        }
        catch (ClassCastException classCastException) {
            throw new MTPException("User supplied transport address not supported.");
        }
        catch (NumberFormatException numberFormatException) {
            throw new MTPException(numberFormatException.getMessage());
        }
        try {
            object = new HTTPServer(n, dispatcher, this.numKA, string, this.timeout, bl);
            int n2 = ((HTTPServer)object).getLocalPort();
            if (n2 != n) {
                hTTPAddress = new HTTPAddress(InetAddress.getLocalHost().getHostName(), n2, this.useHttps);
            }
            this.addr2srv.put(hTTPAddress.toString(), object);
            ((Thread)object).start();
            return hTTPAddress;
        }
        catch (Exception exception) {
            throw new MTPException("While activating MTP got exception " + exception);
        }
    }

    public void deactivate(TransportAddress transportAddress) throws MTPException {
        HTTPServer hTTPServer = (HTTPServer)this.addr2srv.get(transportAddress.toString());
        if (hTTPServer == null) {
            throw new MTPException("No server on address " + transportAddress);
        }
        this.addr2srv.remove(transportAddress.toString());
        hTTPServer.desactivate();
    }

    public void deactivate() throws MTPException {
        Enumeration enumeration = this.addr2srv.keys();
        while (enumeration.hasMoreElements()) {
            TransportAddress transportAddress = (TransportAddress)enumeration.nextElement();
            this.deactivate(transportAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(String string, Envelope envelope, byte[] byArray) throws MTPException {
        HTTPAddress hTTPAddress = null;
        KeepAlive.KAConnection kAConnection = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                byte[] byArray2;
                block14: {
                    HTTPAddress hTTPAddress2 = new HTTPAddress(string);
                    hTTPAddress = this.useProxy ? new HTTPAddress(this.proxyHost, this.proxyPort, false) : hTTPAddress2;
                    String string2 = this.keepAlive ? "Keep-Alive" : "close";
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = 0;
                    while (n < 31) {
                        stringBuffer.append(Integer.toString((int)Math.round(Math.random() * 15.0), 16));
                        ++n;
                    }
                    byte[] byArray3 = stringBuffer.toString().getBytes("ISO-8859-1");
                    byte[] byArray4 = HTTPIO.createHTTPBody(envelope, byArray3, byArray);
                    byte[] byArray5 = HTTPIO.createHTTPHeader(hTTPAddress2, byArray4.length, string2, byArray3, this.useProxy);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray5.length + byArray4.length);
                    byteArrayOutputStream.write(byArray5);
                    byteArrayOutputStream.write(byArray4);
                    byteArrayOutputStream.flush();
                    byteArrayOutputStream.close();
                    byArray2 = byteArrayOutputStream.toByteArray();
                    if (this.keepAlive) {
                        kAConnection = this.ka.getConnection(hTTPAddress);
                        try {
                            if (kAConnection != null && this.sendOut(kAConnection, byArray2, false) == 200) {
                                if (this.policy) {
                                    this.ka.swap(kAConnection);
                                }
                                return;
                            }
                        }
                        catch (IOException iOException) {
                            if (kAConnection == null) break block14;
                            kAConnection.close();
                            this.ka.remove(kAConnection);
                        }
                    }
                }
                Socket socket = null;
                HTTPSocketFactory hTTPSocketFactory = HTTPSocketFactory.getInstance();
                socket = this.useOutPort ? hTTPSocketFactory.createSocket(hTTPAddress.getHost(), hTTPAddress.getPortNo(), InetAddress.getLocalHost(), this.outPort) : hTTPSocketFactory.createSocket(hTTPAddress.getHost(), hTTPAddress.getPortNo());
                kAConnection = new KeepAlive.KAConnection(socket, hTTPAddress);
                if (this.sendOut(kAConnection, byArray2, true) != 200) {
                    throw new MTPException("Description: ResponseMessage is not OK");
                }
            }
        }
        catch (Exception exception) {
            if (kAConnection != null) {
                kAConnection.close();
            }
            if (this.keepAlive) {
                this.ka.remove(hTTPAddress);
            }
            throw new MTPException(exception.getMessage());
        }
    }

    private int sendOut(KeepAlive.KAConnection kAConnection, byte[] byArray, boolean bl) throws IOException {
        OutputStream outputStream = kAConnection.getOut();
        InputStream inputStream = kAConnection.getIn();
        HTTPIO.writeAll(outputStream, byArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = HTTPIO.getResponseCode(inputStream, stringBuffer);
        if (!"Keep-Alive".equals(stringBuffer.toString())) {
            kAConnection.close();
            if (!bl) {
                this.ka.remove(kAConnection);
            }
        } else if (bl) {
            this.ka.add(kAConnection);
        }
        return n;
    }
}

