/*
 * Decompiled with CFR 0.152.
 */
package jade.lang.acl;

import jade.core.AID;
import jade.core.CaseInsensitiveString;
import jade.lang.acl.ACLCodec;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ACLParser;
import jade.lang.acl.ISO8601;
import jade.lang.acl.TokenMgrError;
import jade.util.leap.Iterator;
import jade.util.leap.Properties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import starlight.util.Base64;

public class StringACLCodec
implements ACLCodec {
    public static final String NAME = "fipa.acl.rep.string.std";
    private static final String BASE64ENCODING_KEY = new String("JADE-Encoding");
    private static final String BASE64ENCODING_VALUE = new String("Base64");
    private static final String SENDER = new String(" :sender ");
    private static final String RECEIVER = new String(" :receiver ");
    private static final String CONTENT = new String(" :content ");
    private static final String REPLY_WITH = new String(" :reply-with ");
    private static final String IN_REPLY_TO = new String(" :in-reply-to ");
    private static final String REPLY_TO = new String(" :reply-to ");
    private static final String LANGUAGE = new String(" :language ");
    private static final String ENCODING = new String(" :encoding ");
    private static final String ONTOLOGY = new String(" :ontology ");
    private static final String REPLY_BY = new String(" :reply-by ");
    private static final String PROTOCOL = new String(" :protocol ");
    private static final String CONVERSATION_ID = new String(" :conversation-id ");
    ACLParser parser = null;
    Writer out = null;
    private static final String illegalFirstChar = "#0123456789-";

    public StringACLCodec() {
    }

    public StringACLCodec(Reader reader, Writer writer) {
        this.parser = new ACLParser(reader);
        this.out = writer;
    }

    private void checkBase64Encoding(ACLMessage aCLMessage) {
        block7: {
            String string = aCLMessage.getUserDefinedParameter(BASE64ENCODING_KEY);
            if (!CaseInsensitiveString.equalsIgnoreCase(BASE64ENCODING_VALUE, string)) break block7;
            try {
                String string2 = aCLMessage.getContent();
                if (string2 != null && string2.length() > 0) {
                    char[] cArray = new char[string2.length()];
                    string2.getChars(0, string2.length(), cArray, 0);
                    aCLMessage.setByteSequenceContent(Base64.decode(cArray));
                    aCLMessage.removeUserDefinedParameter(BASE64ENCODING_KEY);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                stringIndexOutOfBoundsException.printStackTrace();
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println("\t\t===== E R R O R !!! =======\n");
                System.err.println("Missing support for Base64 conversions");
                System.err.println("Please refer to the documentation for details.");
                System.err.println("=============================================\n\n");
                try {
                    Thread.currentThread();
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public ACLMessage decode() throws ACLCodec.CodecException {
        try {
            ACLMessage aCLMessage = this.parser.Message();
            this.checkBase64Encoding(aCLMessage);
            return aCLMessage;
        }
        catch (TokenMgrError tokenMgrError) {
            throw new ACLCodec.CodecException(this.getName() + " ACLMessage decoding token exception", tokenMgrError);
        }
        catch (Exception exception) {
            throw new ACLCodec.CodecException(this.getName() + " ACLMessage decoding exception", exception);
        }
    }

    public AID decodeAID() throws ACLCodec.CodecException {
        try {
            return this.parser.parseAID(null);
        }
        catch (TokenMgrError tokenMgrError) {
            throw new ACLCodec.CodecException(this.getName() + " AID decoding token exception", tokenMgrError);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ACLCodec.CodecException(this.getName() + " AID decoding exception", exception);
        }
    }

    public void write(ACLMessage aCLMessage) {
        try {
            this.out.write(StringACLCodec.toString(aCLMessage));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 20);
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\"') {
                stringBuffer.append("\\\"");
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String quotedString(String string) {
        return "\"" + StringACLCodec.escape(string) + "\"";
    }

    static String toString(ACLMessage aCLMessage) {
        String string;
        Object object;
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(ACLMessage.getPerformative(aCLMessage.getPerformative()) + "\n");
        AID aID = aCLMessage.getSender();
        if (aID != null) {
            stringBuffer.append(SENDER + " " + aID.toString() + "\n");
        }
        if ((iterator = aCLMessage.getAllReceiver()).hasNext()) {
            stringBuffer.append(RECEIVER + " (set ");
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString() + " ");
            }
            stringBuffer.append(")\n");
        }
        if ((iterator = aCLMessage.getAllReplyTo()).hasNext()) {
            stringBuffer.append(REPLY_TO + " (set \n");
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString() + " ");
            }
            stringBuffer.append(")\n");
        }
        if (aCLMessage.hasByteSequenceContent()) {
            stringBuffer.append(":X-" + BASE64ENCODING_KEY + " " + BASE64ENCODING_VALUE + "\n");
            try {
                object = new String(Base64.encode(aCLMessage.getByteSequenceContent()));
                stringBuffer.append(CONTENT + " \"" + (String)object + "\" \n");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println("\n\t===== E R R O R !!! =======\n");
                System.err.println("Missing support for Base64 conversions");
                System.err.println("Please refer to the documentation for details.");
                System.err.println("=============================================\n\n");
                System.err.println("");
                try {
                    Thread.currentThread();
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            object = aCLMessage.getContent();
            if (object != null && ((String)(object = ((String)object).trim())).length() > 0) {
                stringBuffer.append(CONTENT + " \"" + StringACLCodec.escape((String)object) + "\" \n");
            }
        }
        StringACLCodec.appendACLExpression(stringBuffer, REPLY_WITH, aCLMessage.getReplyWith());
        StringACLCodec.appendACLExpression(stringBuffer, IN_REPLY_TO, aCLMessage.getInReplyTo());
        StringACLCodec.appendACLExpression(stringBuffer, ENCODING, aCLMessage.getEncoding());
        StringACLCodec.appendACLExpression(stringBuffer, LANGUAGE, aCLMessage.getLanguage());
        StringACLCodec.appendACLExpression(stringBuffer, ONTOLOGY, aCLMessage.getOntology());
        object = aCLMessage.getReplyByDate();
        if (object != null) {
            stringBuffer.append(REPLY_BY + " " + ISO8601.toString((Date)object) + "\n");
        }
        if ((string = aCLMessage.getProtocol()) != null && (string = string.trim()).length() > 0) {
            stringBuffer.append(PROTOCOL + " " + string + "\n");
        }
        StringACLCodec.appendACLExpression(stringBuffer, CONVERSATION_ID, aCLMessage.getConversationId());
        Properties properties = aCLMessage.getAllUserDefinedParameters();
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2.indexOf(32) == -1) {
                    if (!string2.startsWith("X-") && !string2.startsWith("x-")) {
                        StringACLCodec.appendACLExpression(stringBuffer, ":X-" + string2, properties.getProperty(string2));
                        continue;
                    }
                    StringACLCodec.appendACLExpression(stringBuffer, ":" + string2, properties.getProperty(string2));
                    continue;
                }
                System.err.println("WARNING: The slotName of user-defined parameters cannot contain blanks inside. Therefore " + string2 + " is not being encoded");
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public byte[] encode(ACLMessage aCLMessage, String string) {
        try {
            return StringACLCodec.toString(aCLMessage).getBytes(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new byte[0];
        }
    }

    public ACLMessage decode(byte[] byArray, String string) throws ACLCodec.CodecException {
        try {
            ACLMessage aCLMessage = ACLParser.create().parse(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), string));
            this.checkBase64Encoding(aCLMessage);
            return aCLMessage;
        }
        catch (TokenMgrError tokenMgrError) {
            throw new ACLCodec.CodecException(this.getName() + " ACLMessage decoding token exception", tokenMgrError);
        }
        catch (Exception exception) {
            throw new ACLCodec.CodecException(this.getName() + " ACLMessage decoding exception", exception);
        }
    }

    public String getName() {
        return NAME;
    }

    public static void appendACLExpression(StringBuffer stringBuffer, String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            if (!StringACLCodec.isAWord(string2)) {
                try {
                    Double.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    string2 = StringACLCodec.quotedString(string2);
                }
            }
            stringBuffer.append(string + " " + string2 + " ");
        }
    }

    private static boolean isAWord(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (illegalFirstChar.indexOf(string.charAt(0)) >= 0) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\"' || c == '(' || c == ')' || c <= ' ') {
                return false;
            }
            ++n;
        }
        return true;
    }
}

