/*
 * Decompiled with CFR 0.152.
 */
package jade.lang.acl;

import jade.core.AID;
import jade.core.CaseInsensitiveString;
import jade.lang.acl.ACLMessage;
import jade.util.leap.Iterator;
import jade.util.leap.Serializable;
import java.util.Date;

public class MessageTemplate
implements Serializable {
    private static final int CONVERSATION_ID = 0;
    private static final int ENCODING = 1;
    private static final int IN_REPLY_TO = 2;
    private static final int LANGUAGE = 3;
    private static final int ONTOLOGY = 4;
    private static final int PROTOCOL = 5;
    private static final int REPLY_BY = 6;
    private static final int REPLY_WITH = 7;
    private static final int RECEIVER = 9;
    private static final int REPLY_TO = 10;
    private static final int PERFORMATIVE = 11;
    private static final int CONTENT = 12;
    private static final int SENDER = 13;
    private static final int REPLY_BY_DATE = 14;
    private MatchExpression toMatch;

    public MessageTemplate(MatchExpression matchExpression) {
        this.toMatch = matchExpression;
    }

    public static MessageTemplate MatchAll() {
        return new MessageTemplate(new MatchAllLiteral());
    }

    public static MessageTemplate MatchSender(AID aID) {
        return new MessageTemplate(new Literal(aID));
    }

    public static MessageTemplate MatchReceiver(AID[] aIDArray) {
        return new MessageTemplate(new Literal(aIDArray, 9));
    }

    public static MessageTemplate MatchContent(String string) {
        return new MessageTemplate(new Literal(string, 12));
    }

    public static MessageTemplate MatchReplyWith(String string) {
        return new MessageTemplate(new Literal(string, 7));
    }

    public static MessageTemplate MatchInReplyTo(String string) {
        return new MessageTemplate(new Literal(string, 2));
    }

    public static MessageTemplate MatchReplyTo(AID[] aIDArray) {
        return new MessageTemplate(new Literal(aIDArray, 10));
    }

    public static MessageTemplate MatchLanguage(String string) {
        return new MessageTemplate(new Literal(string, 3));
    }

    public static MessageTemplate MatchEncoding(String string) {
        return new MessageTemplate(new Literal(string, 1));
    }

    public static MessageTemplate MatchOntology(String string) {
        return new MessageTemplate(new Literal(string, 4));
    }

    public static MessageTemplate MatchReplyByDate(Date date) {
        return new MessageTemplate(new Literal(date));
    }

    public static MessageTemplate MatchProtocol(String string) {
        return new MessageTemplate(new Literal(string, 5));
    }

    public static MessageTemplate MatchConversationId(String string) {
        return new MessageTemplate(new Literal(string, 0));
    }

    public static MessageTemplate MatchPerformative(int n) {
        return new MessageTemplate(new Literal(n));
    }

    public static MessageTemplate MatchCustom(ACLMessage aCLMessage, boolean bl) {
        ACLMessage aCLMessage2 = (ACLMessage)aCLMessage.clone();
        return new MessageTemplate(new CustomMsgLiteral(aCLMessage2, bl));
    }

    public static MessageTemplate and(MessageTemplate messageTemplate, MessageTemplate messageTemplate2) {
        AndExpression andExpression = new AndExpression(messageTemplate.toMatch, messageTemplate2.toMatch);
        MessageTemplate messageTemplate3 = new MessageTemplate(andExpression);
        return messageTemplate3;
    }

    public static MessageTemplate or(MessageTemplate messageTemplate, MessageTemplate messageTemplate2) {
        OrExpression orExpression = new OrExpression(messageTemplate.toMatch, messageTemplate2.toMatch);
        MessageTemplate messageTemplate3 = new MessageTemplate(orExpression);
        return messageTemplate3;
    }

    public static MessageTemplate not(MessageTemplate messageTemplate) {
        NotExpression notExpression = new NotExpression(messageTemplate.toMatch);
        MessageTemplate messageTemplate2 = new MessageTemplate(notExpression);
        return messageTemplate2;
    }

    public boolean match(ACLMessage aCLMessage) {
        return this.toMatch.match(aCLMessage);
    }

    public String toString() {
        return this.toMatch.toString();
    }

    private static class CustomMsgLiteral
    implements MatchExpression {
        ACLMessage messageToMatch;
        boolean matchPerformative;

        CustomMsgLiteral(ACLMessage aCLMessage, boolean bl) {
            this.messageToMatch = aCLMessage;
            this.matchPerformative = bl;
        }

        public boolean match(ACLMessage aCLMessage) {
            Object object;
            if (this.matchPerformative && this.messageToMatch.getPerformative() != aCLMessage.getPerformative()) {
                return false;
            }
            if (this.messageToMatch.hasByteSequenceContent()) {
                if (!this.messageToMatch.getByteSequenceContent().equals(aCLMessage.getByteSequenceContent())) {
                    return false;
                }
                if (!this.match(this.messageToMatch.getContent(), aCLMessage.getContent())) {
                    return false;
                }
            }
            if (!this.match(this.messageToMatch.getConversationId(), aCLMessage.getConversationId())) {
                return false;
            }
            if (!this.match(this.messageToMatch.getEncoding(), aCLMessage.getEncoding())) {
                return false;
            }
            if (!this.match(this.messageToMatch.getInReplyTo(), aCLMessage.getInReplyTo())) {
                return false;
            }
            if (!this.match(this.messageToMatch.getLanguage(), aCLMessage.getLanguage())) {
                return false;
            }
            if (!this.match(this.messageToMatch.getOntology(), aCLMessage.getOntology())) {
                return false;
            }
            if (!this.match(this.messageToMatch.getProtocol(), aCLMessage.getProtocol())) {
                return false;
            }
            if (!this.match(this.messageToMatch.getReplyWith(), aCLMessage.getReplyWith())) {
                return false;
            }
            if (!this.match(this.messageToMatch.getReplyByDate(), aCLMessage.getReplyByDate())) {
                return false;
            }
            Iterator iterator = this.messageToMatch.getAllReceiver();
            while (iterator.hasNext()) {
                boolean bl = false;
                AID aID = (AID)iterator.next();
                object = aCLMessage.getAllReceiver();
                while (object.hasNext()) {
                    if (!aID.equals((AID)object.next())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            Iterator iterator2 = this.messageToMatch.getAllReceiver();
            while (iterator2.hasNext()) {
                boolean bl = false;
                object = (AID)iterator2.next();
                Iterator iterator3 = aCLMessage.getAllReceiver();
                while (iterator3.hasNext()) {
                    if (!((AID)object).equals((AID)iterator3.next())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return this.messageToMatch.getSender() == null || this.messageToMatch.getSender().equals(aCLMessage.getSender());
        }

        private boolean match(String string, String string2) {
            if (string == null) {
                return true;
            }
            return CaseInsensitiveString.equalsIgnoreCase(string, string2);
        }

        private boolean match(Date date, Date date2) {
            if (date == null) {
                return true;
            }
            return date.equals(date2);
        }

        public String toString() {
            String string = this.matchPerformative ? "match the performative " : "no match on performative ";
            return string + this.messageToMatch.toString();
        }
    }

    private static class MatchAllLiteral
    implements MatchExpression {
        MatchAllLiteral() {
        }

        public boolean match(ACLMessage aCLMessage) {
            return true;
        }

        public String toString() {
            return "Match ALL Template";
        }
    }

    private static class Literal
    implements MatchExpression {
        Object matchValue;
        int perfValue;
        int slotName;

        Literal(String string, int n) {
            this.matchValue = string;
            this.slotName = n;
        }

        Literal(AID aID) {
            this.matchValue = aID;
            this.slotName = 13;
        }

        Literal(AID[] aIDArray, int n) {
            this.matchValue = aIDArray;
            this.slotName = n;
        }

        Literal(int n) {
            this.perfValue = n;
            this.slotName = 11;
        }

        Literal(Date date) {
            this.matchValue = date;
            this.slotName = 14;
        }

        public boolean match(ACLMessage aCLMessage) {
            switch (this.slotName) {
                case 0: {
                    return CaseInsensitiveString.equalsIgnoreCase((String)this.matchValue, aCLMessage.getConversationId());
                }
                case 1: {
                    return CaseInsensitiveString.equalsIgnoreCase((String)this.matchValue, aCLMessage.getEncoding());
                }
                case 2: {
                    return CaseInsensitiveString.equalsIgnoreCase((String)this.matchValue, aCLMessage.getInReplyTo());
                }
                case 3: {
                    return CaseInsensitiveString.equalsIgnoreCase((String)this.matchValue, aCLMessage.getLanguage());
                }
                case 4: {
                    return CaseInsensitiveString.equalsIgnoreCase((String)this.matchValue, aCLMessage.getOntology());
                }
                case 5: {
                    return CaseInsensitiveString.equalsIgnoreCase((String)this.matchValue, aCLMessage.getProtocol());
                }
                case 14: {
                    return ((Date)this.matchValue).equals(aCLMessage.getReplyByDate());
                }
                case 7: {
                    return CaseInsensitiveString.equalsIgnoreCase((String)this.matchValue, aCLMessage.getReplyWith());
                }
                case 9: {
                    if (this.matchValue != null) {
                        AID[] aIDArray = (AID[])this.matchValue;
                        int n = 0;
                        while (n < aIDArray.length) {
                            AID aID = aIDArray[n];
                            Iterator iterator = aCLMessage.getAllReceiver();
                            boolean bl = false;
                            while (iterator.hasNext()) {
                                if (!aID.equals((AID)iterator.next())) continue;
                                bl = true;
                                break;
                            }
                            if (!bl) {
                                return false;
                            }
                            ++n;
                        }
                        return true;
                    }
                    return false;
                }
                case 10: {
                    if (this.matchValue != null) {
                        AID[] aIDArray = (AID[])this.matchValue;
                        int n = 0;
                        while (n < aIDArray.length) {
                            AID aID = aIDArray[n];
                            Iterator iterator = aCLMessage.getAllReplyTo();
                            boolean bl = false;
                            while (iterator.hasNext()) {
                                if (!aID.equals((AID)iterator.next())) continue;
                                bl = true;
                                break;
                            }
                            if (!bl) {
                                return false;
                            }
                            ++n;
                        }
                        return true;
                    }
                    return false;
                }
                case 11: {
                    return this.perfValue == aCLMessage.getPerformative();
                }
                case 12: {
                    return CaseInsensitiveString.equalsIgnoreCase((String)this.matchValue, aCLMessage.getContent());
                }
                case 13: {
                    if (this.matchValue != null) {
                        return ((AID)this.matchValue).equals(aCLMessage.getSender());
                    }
                    return false;
                }
            }
            return false;
        }

        public String toString() {
            switch (this.slotName) {
                case 0: {
                    return "(ConversationId: " + (String)this.matchValue + ")";
                }
                case 1: {
                    return "( Encoding: " + (String)this.matchValue + " )";
                }
                case 2: {
                    return "( InReplyTo: " + (String)this.matchValue + " )";
                }
                case 3: {
                    return "( Language: " + (String)this.matchValue + " )";
                }
                case 4: {
                    return "( Ontology: " + (String)this.matchValue + " )";
                }
                case 5: {
                    return "( Protocol: " + (String)this.matchValue + " )";
                }
                case 14: {
                    return "( ReplyByDate: " + (Date)this.matchValue + " )";
                }
                case 7: {
                    return "( ReplyWith: " + (String)this.matchValue + " )";
                }
                case 9: {
                    if (this.matchValue != null) {
                        AID[] aIDArray = (AID[])this.matchValue;
                        String string = "( Receivers: ";
                        int n = 0;
                        while (n < aIDArray.length) {
                            AID aID = aIDArray[n];
                            string = string + aID.toString();
                            ++n;
                        }
                        return string + ")";
                    }
                    return "(Receivers: null)";
                }
                case 10: {
                    if (this.matchValue != null) {
                        AID[] aIDArray = (AID[])this.matchValue;
                        String string = "( ReplyTo: ";
                        int n = 0;
                        while (n < aIDArray.length) {
                            AID aID = aIDArray[n];
                            string = string + aID.toString();
                            ++n;
                        }
                        return string + " )";
                    }
                    return "(ReplyTo: null)";
                }
                case 11: {
                    return "( Perfomative: " + ACLMessage.getPerformative(this.perfValue) + " )";
                }
                case 12: {
                    return "( Content: " + (String)this.matchValue + ")";
                }
                case 13: {
                    if (this.matchValue != null) {
                        return "( Sender AID: " + ((AID)this.matchValue).toString() + ")";
                    }
                    return "(Sender AID: null)";
                }
            }
            return "No slot. This casa should never occur !!!";
        }
    }

    private static class NotExpression
    implements MatchExpression {
        private MatchExpression op;

        public NotExpression(MatchExpression matchExpression) {
            this.op = matchExpression;
        }

        public boolean match(ACLMessage aCLMessage) {
            return !this.op.match(aCLMessage);
        }

        public String toString() {
            return "(NOT " + this.op.toString() + ")";
        }
    }

    private static class OrExpression
    implements MatchExpression {
        private MatchExpression op1;
        private MatchExpression op2;

        public OrExpression(MatchExpression matchExpression, MatchExpression matchExpression2) {
            this.op1 = matchExpression;
            this.op2 = matchExpression2;
        }

        public boolean match(ACLMessage aCLMessage) {
            return this.op1.match(aCLMessage) || this.op2.match(aCLMessage);
        }

        public String toString() {
            return "(" + this.op1.toString() + " OR " + this.op2.toString() + ")";
        }
    }

    private static class AndExpression
    implements MatchExpression {
        private MatchExpression op1;
        private MatchExpression op2;

        public AndExpression(MatchExpression matchExpression, MatchExpression matchExpression2) {
            this.op1 = matchExpression;
            this.op2 = matchExpression2;
        }

        public boolean match(ACLMessage aCLMessage) {
            return this.op1.match(aCLMessage) && this.op2.match(aCLMessage);
        }

        public String toString() {
            return "(" + this.op1.toString() + " AND " + this.op2.toString() + ")";
        }
    }

    public static interface MatchExpression
    extends Serializable {
        public boolean match(ACLMessage var1);
    }
}

