/*
 * Decompiled with CFR 0.152.
 */
package jade.lang.acl;

import jade.core.AID;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ACLParserConstants;
import jade.lang.acl.ACLParserTokenManager;
import jade.lang.acl.ISO8601;
import jade.lang.acl.ParseException;
import jade.lang.acl.SimpleCharStream;
import jade.lang.acl.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;

public class ACLParser
implements ACLParserConstants {
    ACLMessage msg = new ACLMessage(10);
    public ACLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[14];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static void main(String[] stringArray) throws ParseException {
        ACLParser aCLParser = new ACLParser(System.in);
        while (true) {
            try {
                while (true) {
                    ACLMessage aCLMessage = aCLParser.Message();
                    System.out.println(aCLMessage);
                }
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                System.exit(1);
                continue;
            }
            break;
        }
    }

    public static ACLParser create() {
        StringReader stringReader = new StringReader("");
        return new ACLParser(stringReader);
    }

    public ACLMessage parse(Reader reader) throws ParseException {
        this.ReInit(reader);
        return this.Message();
    }

    public AID parseAID(Reader reader) throws ParseException {
        if (reader != null) {
            this.ReInit(reader);
        }
        this.token_source.SwitchTo(4);
        AID aID = this.AgentIdentifier();
        this.token_source.SwitchTo(0);
        return aID;
    }

    private String trimQuotes(String string) throws ParseException {
        if ((string = string.trim()).startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return this.unescape(string);
    }

    private String unescape(String string) throws ParseException {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length() - 1) {
            if (string.charAt(n) == '\\' && string.charAt(n + 1) == '\"') {
                stringBuffer.append("\"");
                ++n;
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        if (n < string.length()) {
            stringBuffer.append(string.charAt(string.length() - 1));
        }
        return stringBuffer.toString();
    }

    public final ACLMessage Message() throws ParseException {
        this.msg.reset();
        this.jj_consume_token(5);
        this.MessageType();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.MessageParameter();
        }
        this.jj_consume_token(28);
        return this.msg;
    }

    public final void MessageType() throws ParseException {
        Token token = this.jj_consume_token(10);
        this.msg.setPerformative(ACLMessage.getInteger(token.image));
    }

    public final void MessageParameter() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                AID aID = this.AgentIdentifier();
                this.msg.setSender(aID);
                this.token_source.SwitchTo(2);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                this.msg.clearAllReceiver();
                this.jj_consume_token(55);
                this.jj_consume_token(47);
                block23: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 55: {
                            break;
                        }
                        default: {
                            this.jj_la1[1] = this.jj_gen;
                            break block23;
                        }
                    }
                    AID aID = this.AgentIdentifier();
                    this.msg.addReceiver(aID);
                }
                this.jj_consume_token(54);
                this.token_source.SwitchTo(2);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                String string = this.Content();
                this.msg.setContent(string);
                this.token_source.SwitchTo(2);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                String string = this.Expression();
                this.msg.setReplyWith(string);
                this.token_source.SwitchTo(2);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                String string = this.DateTimeToken();
                try {
                    this.msg.setReplyByDate(ISO8601.toDate(string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.token_source.SwitchTo(2);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                String string = this.Expression();
                this.msg.setInReplyTo(string);
                this.token_source.SwitchTo(2);
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                this.msg.clearAllReplyTo();
                this.jj_consume_token(55);
                this.jj_consume_token(47);
                block24: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 55: {
                            break;
                        }
                        default: {
                            this.jj_la1[2] = this.jj_gen;
                            break block24;
                        }
                    }
                    AID aID = this.AgentIdentifier();
                    this.msg.addReplyTo(aID);
                }
                this.jj_consume_token(54);
                this.token_source.SwitchTo(2);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                String string = this.Expression();
                this.msg.setEncoding(string);
                this.token_source.SwitchTo(2);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                String string = this.Expression();
                this.msg.setLanguage(string);
                this.token_source.SwitchTo(2);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                String string = this.Expression();
                this.msg.setOntology(string);
                this.token_source.SwitchTo(2);
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                String string = this.Word();
                this.msg.setProtocol(string);
                this.token_source.SwitchTo(2);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                String string = this.Expression();
                this.msg.setConversationId(string);
                this.token_source.SwitchTo(2);
                break;
            }
            case 27: {
                Token token = this.jj_consume_token(27);
                String string = this.Expression();
                this.msg.addUserDefinedParameter(token.image.substring(3), string);
                this.token_source.SwitchTo(2);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String Content() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: 
            case 40: {
                String string = this.Stringa();
                return string;
            }
            case 34: {
                String string = this.Word();
                return string;
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final AID AgentIdentifier() throws ParseException {
        AID aID = new AID();
        this.jj_consume_token(55);
        this.jj_consume_token(49);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 50: {
                    this.jj_consume_token(50);
                    String string = this.Word();
                    aID.setName(string);
                    this.token_source.SwitchTo(4);
                    break;
                }
                case 51: {
                    String string;
                    this.jj_consume_token(51);
                    this.jj_consume_token(55);
                    this.jj_consume_token(48);
                    this.token_source.SwitchTo(3);
                    block16: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 34: {
                                break;
                            }
                            default: {
                                this.jj_la1[5] = this.jj_gen;
                                break block16;
                            }
                        }
                        string = this.Word();
                        aID.addAddresses(string);
                    }
                    this.jj_consume_token(41);
                    this.token_source.SwitchTo(4);
                    break;
                }
                case 52: {
                    this.jj_consume_token(52);
                    this.jj_consume_token(55);
                    this.jj_consume_token(48);
                    block17: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 55: {
                                break;
                            }
                            default: {
                                this.jj_la1[6] = this.jj_gen;
                                break block17;
                            }
                        }
                        AID aID2 = this.AgentIdentifier();
                        aID.addResolvers(aID2);
                    }
                    this.jj_consume_token(54);
                    this.token_source.SwitchTo(4);
                    break;
                }
                case 53: {
                    Token token = this.jj_consume_token(53);
                    String string = this.Expression();
                    aID.addUserDefinedSlot(token.image.substring(3), string);
                    this.token_source.SwitchTo(4);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    continue block15;
                }
            }
            break;
        }
        this.jj_la1[8] = this.jj_gen;
        this.jj_consume_token(54);
        return aID;
    }

    public final String Expression() throws ParseException {
        String string = new String();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                String string2 = this.Word();
                return string2;
            }
            case 35: 
            case 40: {
                String string3 = this.Stringa();
                return string3;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                String string4 = this.Number();
                return string4;
            }
            case 33: {
                String string5 = this.DateTimeToken();
                return string5;
            }
            case 42: {
                this.jj_consume_token(42);
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 42: {
                            break;
                        }
                        default: {
                            this.jj_la1[9] = this.jj_gen;
                            break block10;
                        }
                    }
                    String string6 = this.Expression();
                    string = string + string6 + " ";
                }
                this.jj_consume_token(41);
                return "(" + string + ")";
            }
        }
        this.jj_la1[10] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String Word() throws ParseException {
        Token token = this.jj_consume_token(34);
        return this.trimQuotes(token.image);
    }

    public final String Stringa() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                String string = this.StringLiteral();
                return string;
            }
            case 40: {
                String string = this.ByteLengthEncodedString();
                return string;
            }
        }
        this.jj_la1[11] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String StringLiteral() throws ParseException {
        Token token = this.jj_consume_token(35);
        return this.trimQuotes(token.image);
    }

    public final String ByteLengthEncodedString() throws ParseException {
        Token token = this.jj_consume_token(40);
        return token.image;
    }

    public final String Number() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                String string = this.Digit();
                return string;
            }
            case 37: {
                String string = this.Integer();
                return string;
            }
            case 38: 
            case 39: {
                String string = this.Float();
                return string;
            }
        }
        this.jj_la1[12] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String DateTimeToken() throws ParseException {
        Token token = this.jj_consume_token(33);
        return token.image;
    }

    public final String Digit() throws ParseException {
        Token token = this.jj_consume_token(36);
        return token.image;
    }

    public final String Integer() throws ParseException {
        String string = new String();
        Token token = this.jj_consume_token(37);
        return token.image;
    }

    public final String Float() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: {
                Token token = this.jj_consume_token(38);
                return token.image;
            }
            case 39: {
                Token token = this.jj_consume_token(39);
                return token.image;
            }
        }
        this.jj_la1[13] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0xFFF8000, 0, 0, 0xFFF8000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0x800000, 0x800000, 0, 268, 4, 0x800000, 0x3C0000, 0x3C0000, 1534, 1534, 264, 240, 192};
    }

    public ACLParser(InputStream inputStream) {
        this.jj_input_stream = new SimpleCharStream(inputStream, 1, 1);
        this.token_source = new ACLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 14) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 14) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public ACLParser(Reader reader) {
        this.jj_input_stream = new SimpleCharStream(reader, 1, 1);
        this.token_source = new ACLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 14) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public void ReInit(Reader reader) {
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 14) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public ACLParser(ACLParserTokenManager aCLParserTokenManager) {
        this.token_source = aCLParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 14) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public void ReInit(ACLParserTokenManager aCLParserTokenManager) {
        this.token_source = aCLParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 14) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        int n2 = 0;
        while (n2 < n) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
            ++n2;
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int n;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[56];
        int n2 = 0;
        while (n2 < 56) {
            blArray[n2] = false;
            ++n2;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int n3 = 0;
        while (n3 < 14) {
            if (this.jj_la1[n3] == this.jj_gen) {
                n = 0;
                while (n < 32) {
                    if ((jj_la1_0[n3] & 1 << n) != 0) {
                        blArray[n] = true;
                    }
                    if ((jj_la1_1[n3] & 1 << n) != 0) {
                        blArray[32 + n] = true;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        n = 0;
        while (n < 56) {
            if (blArray[n]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = n;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++n;
        }
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        int n4 = 0;
        while (n4 < this.jj_expentries.size()) {
            nArrayArray[n4] = (int[])this.jj_expentries.elementAt(n4);
            ++n4;
        }
        return new ParseException(this.token, nArrayArray, ACLParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        ACLParser.jj_la1_0();
        ACLParser.jj_la1_1();
    }
}

