/*
 * Decompiled with CFR 0.152.
 */
package jade.lang.acl;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.lang.acl.ISO8601;
import jade.lang.acl.StringACLCodec;
import jade.lang.acl.UnreadableException;
import jade.util.leap.ArrayList;
import jade.util.leap.EmptyIterator;
import jade.util.leap.Iterator;
import jade.util.leap.Properties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;

public class ACLMessage
implements Cloneable,
jade.util.leap.Serializable {
    private static final long serialVersionUID = 3945353187608998130L;
    public static final int ACCEPT_PROPOSAL = 0;
    public static final int AGREE = 1;
    public static final int CANCEL = 2;
    public static final int CFP = 3;
    public static final int CONFIRM = 4;
    public static final int DISCONFIRM = 5;
    public static final int FAILURE = 6;
    public static final int INFORM = 7;
    public static final int INFORM_IF = 8;
    public static final int INFORM_REF = 9;
    public static final int NOT_UNDERSTOOD = 10;
    public static final int PROPOSE = 11;
    public static final int QUERY_IF = 12;
    public static final int QUERY_REF = 13;
    public static final int REFUSE = 14;
    public static final int REJECT_PROPOSAL = 15;
    public static final int REQUEST = 16;
    public static final int REQUEST_WHEN = 17;
    public static final int REQUEST_WHENEVER = 18;
    public static final int SUBSCRIBE = 19;
    public static final int PROXY = 20;
    public static final int PROPAGATE = 21;
    public static final int UNKNOWN = -1;
    private int performative;
    private static final String[] performatives = new String[22];
    private AID source = null;
    private static final int RECEIVERS_EXPECTED_SIZE = 1;
    private static final int REPLYTO_EXPECTED_SIZE = 1;
    private ArrayList dests = new ArrayList(1);
    private ArrayList reply_to = null;
    private StringBuffer content = null;
    private byte[] byteSequenceContent = null;
    private String reply_with = null;
    private String in_reply_to = null;
    private String encoding = null;
    private String language = null;
    private String ontology = null;
    private long reply_byInMillisec = 0L;
    private String protocol = null;
    private String conversation_id = null;
    private Properties userDefProps = null;
    private Envelope messageEnvelope;
    private static final String UNSUPPORTED = "Unsupported";
    private Long persistentID;

    public static String[] getAllPerformativeNames() {
        return performatives;
    }

    public ACLMessage() {
        this.performative = 10;
    }

    public ACLMessage(int n) {
        this.performative = n;
    }

    public void setSender(AID aID) {
        this.source = aID;
    }

    public void addReceiver(AID aID) {
        if (aID != null) {
            this.dests.add(aID);
        }
    }

    public boolean removeReceiver(AID aID) {
        if (aID != null) {
            return this.dests.remove(aID);
        }
        return false;
    }

    public void clearAllReceiver() {
        this.dests.clear();
    }

    public void addReplyTo(AID aID) {
        if (aID != null) {
            this.reply_to = this.reply_to == null ? new ArrayList(1) : this.reply_to;
            this.reply_to.add(aID);
        }
    }

    public boolean removeReplyTo(AID aID) {
        if (aID != null && this.reply_to != null) {
            return this.reply_to.remove(aID);
        }
        return false;
    }

    public void clearAllReplyTo() {
        if (this.reply_to != null) {
            this.reply_to.clear();
        }
    }

    public void setPerformative(int n) {
        this.performative = n;
    }

    public void setContent(String string) {
        this.byteSequenceContent = null;
        this.content = string != null ? new StringBuffer(string) : null;
    }

    public void setByteSequenceContent(byte[] byArray) {
        this.content = null;
        this.byteSequenceContent = byArray;
    }

    public void setContentObject(Serializable serializable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        this.setByteSequenceContent(byteArrayOutputStream.toByteArray());
    }

    public Serializable getContentObject() throws UnreadableException {
        try {
            byte[] byArray = this.getByteSequenceContent();
            if (byArray == null) {
                return null;
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            Serializable serializable = (Serializable)objectInputStream.readObject();
            return serializable;
        }
        catch (Error error) {
            throw new UnreadableException(error.getMessage());
        }
        catch (IOException iOException) {
            throw new UnreadableException(iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnreadableException(classNotFoundException.getMessage());
        }
    }

    public void setReplyWith(String string) {
        this.reply_with = string;
    }

    public void setInReplyTo(String string) {
        this.in_reply_to = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setOntology(String string) {
        this.ontology = string;
    }

    public void setReplyByDate(Date date) {
        this.reply_byInMillisec = date == null ? 0L : date.getTime();
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public void setConversationId(String string) {
        this.conversation_id = string;
    }

    public Iterator getAllReceiver() {
        return this.dests.iterator();
    }

    public Iterator getAllReplyTo() {
        if (this.reply_to == null) {
            return EmptyIterator.getInstance();
        }
        return this.reply_to.iterator();
    }

    public AID getSender() {
        return this.source;
    }

    public static String getPerformative(int n) {
        try {
            return performatives[n];
        }
        catch (Exception exception) {
            return performatives[10];
        }
    }

    public static int getInteger(String string) {
        String string2 = string.toUpperCase();
        int n = 0;
        while (n < performatives.length) {
            if (performatives[n].equals(string2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getPerformative() {
        return this.performative;
    }

    public boolean hasByteSequenceContent() {
        return this.byteSequenceContent != null;
    }

    public String getContent() {
        if (this.content != null) {
            return new String(this.content);
        }
        if (this.byteSequenceContent != null) {
            return new String(this.byteSequenceContent);
        }
        return null;
    }

    public byte[] getByteSequenceContent() {
        if (this.content != null) {
            return this.content.toString().getBytes();
        }
        if (this.byteSequenceContent != null) {
            return this.byteSequenceContent;
        }
        return null;
    }

    public String getReplyWith() {
        return this.reply_with;
    }

    public String getInReplyTo() {
        return this.in_reply_to;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getOntology() {
        return this.ontology;
    }

    public String getReplyBy() {
        if (this.reply_byInMillisec != 0L) {
            return ISO8601.toString(new Date(this.reply_byInMillisec));
        }
        return null;
    }

    public Date getReplyByDate() {
        if (this.reply_byInMillisec != 0L) {
            return new Date(this.reply_byInMillisec);
        }
        return null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getConversationId() {
        return this.conversation_id;
    }

    public void addUserDefinedParameter(String string, String string2) {
        this.userDefProps = this.userDefProps == null ? new Properties() : this.userDefProps;
        this.userDefProps.setProperty(string, string2);
    }

    public String getUserDefinedParameter(String string) {
        if (this.userDefProps == null) {
            return null;
        }
        return this.userDefProps.getProperty(string);
    }

    public Properties getAllUserDefinedParameters() {
        this.userDefProps = this.userDefProps == null ? new Properties() : this.userDefProps;
        return this.userDefProps;
    }

    public boolean removeUserDefinedParameter(String string) {
        if (this.userDefProps == null) {
            return false;
        }
        return this.userDefProps.remove(string) != null;
    }

    public void setEnvelope(Envelope envelope) {
        this.messageEnvelope = envelope;
    }

    public void setDefaultEnvelope() {
        this.messageEnvelope = new Envelope();
        this.messageEnvelope.setFrom(this.source);
        Iterator iterator = this.dests.iterator();
        while (iterator.hasNext()) {
            this.messageEnvelope.addTo((AID)iterator.next());
        }
        this.messageEnvelope.setAclRepresentation("fipa.acl.rep.string.std");
        this.messageEnvelope.setDate(new Date());
    }

    public Envelope getEnvelope() {
        return this.messageEnvelope;
    }

    public String toString() {
        return StringACLCodec.toString(this);
    }

    public synchronized Object clone() {
        ACLMessage aCLMessage;
        try {
            AID aID;
            Iterator iterator;
            aCLMessage = (ACLMessage)super.clone();
            aCLMessage.persistentID = null;
            if (this.source != null) {
                aCLMessage.source = (AID)this.source.clone();
            }
            if (this.dests != null) {
                aCLMessage.dests = new ArrayList(this.dests.size());
                iterator = this.dests.iterator();
                while (iterator.hasNext()) {
                    aID = (AID)iterator.next();
                    aCLMessage.dests.add(aID.clone());
                }
            }
            if (this.reply_to != null) {
                aCLMessage.reply_to = new ArrayList(this.reply_to.size());
                iterator = this.reply_to.iterator();
                while (iterator.hasNext()) {
                    aID = (AID)iterator.next();
                    aCLMessage.reply_to.add(aID.clone());
                }
            }
            if (this.userDefProps != null) {
                aCLMessage.userDefProps = (Properties)this.userDefProps.clone();
            }
            if (this.messageEnvelope != null) {
                aCLMessage.messageEnvelope = (Envelope)this.messageEnvelope.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return aCLMessage;
    }

    public void reset() {
        this.source = null;
        this.dests.clear();
        if (this.reply_to != null) {
            this.reply_to.clear();
        }
        this.performative = 10;
        this.content = null;
        this.byteSequenceContent = null;
        this.reply_with = null;
        this.in_reply_to = null;
        this.encoding = null;
        this.language = null;
        this.ontology = null;
        this.reply_byInMillisec = 0L;
        this.protocol = null;
        this.conversation_id = null;
        if (this.userDefProps != null) {
            this.userDefProps.clear();
        }
    }

    public ACLMessage createReply() {
        ACLMessage aCLMessage = (ACLMessage)this.clone();
        aCLMessage.clearAllReceiver();
        Iterator iterator = this.getAllReplyTo();
        while (iterator.hasNext()) {
            aCLMessage.addReceiver((AID)iterator.next());
        }
        if (this.reply_to == null || this.reply_to.isEmpty()) {
            aCLMessage.addReceiver(this.getSender());
        }
        aCLMessage.clearAllReplyTo();
        aCLMessage.setLanguage(this.getLanguage());
        aCLMessage.setOntology(this.getOntology());
        aCLMessage.setProtocol(this.getProtocol());
        aCLMessage.setSender(null);
        aCLMessage.setInReplyTo(this.getReplyWith());
        if (this.source != null) {
            aCLMessage.setReplyWith(this.source.getName() + System.currentTimeMillis());
        } else {
            aCLMessage.setReplyWith("X" + System.currentTimeMillis());
        }
        aCLMessage.setConversationId(this.getConversationId());
        aCLMessage.setReplyByDate(null);
        aCLMessage.setContent(null);
        aCLMessage.setEncoding(null);
        if (this.messageEnvelope != null) {
            aCLMessage.setDefaultEnvelope();
            String string = this.messageEnvelope.getAclRepresentation();
            if (string != null) {
                aCLMessage.getEnvelope().setAclRepresentation(string);
            }
        } else {
            aCLMessage.setEnvelope(null);
        }
        return aCLMessage;
    }

    public Iterator getAllIntendedReceiver() {
        Iterator iterator = null;
        Envelope envelope = this.getEnvelope();
        if (envelope != null && !(iterator = envelope.getAllIntendedReceiver()).hasNext()) {
            iterator = envelope.getAllTo();
        }
        if (iterator == null || !iterator.hasNext()) {
            iterator = this.getAllReceiver();
        }
        return iterator;
    }

    private Long getPersistentID() {
        return this.persistentID;
    }

    private void setPersistentID(Long l) {
        this.persistentID = l;
    }

    private void setReceivers(ArrayList arrayList) {
        this.dests = arrayList;
    }

    private ArrayList getReceivers() {
        return this.dests;
    }

    private void setReplyTo(ArrayList arrayList) {
        this.reply_to = arrayList;
    }

    private ArrayList getReplyTo() {
        return this.reply_to;
    }

    private void setUserDefinedProperties(jade.util.leap.Serializable serializable) {
        this.userDefProps = (Properties)serializable;
    }

    private jade.util.leap.Serializable getUserDefinedProperties() {
        return this.userDefProps;
    }

    static {
        ACLMessage.performatives[0] = "ACCEPT-PROPOSAL";
        ACLMessage.performatives[1] = "AGREE";
        ACLMessage.performatives[2] = "CANCEL";
        ACLMessage.performatives[3] = "CFP";
        ACLMessage.performatives[4] = "CONFIRM";
        ACLMessage.performatives[5] = "DISCONFIRM";
        ACLMessage.performatives[6] = "FAILURE";
        ACLMessage.performatives[7] = "INFORM";
        ACLMessage.performatives[8] = "INFORM-IF";
        ACLMessage.performatives[9] = "INFORM-REF";
        ACLMessage.performatives[10] = "NOT-UNDERSTOOD";
        ACLMessage.performatives[11] = "PROPOSE";
        ACLMessage.performatives[12] = "QUERY-IF";
        ACLMessage.performatives[13] = "QUERY-REF";
        ACLMessage.performatives[14] = "REFUSE";
        ACLMessage.performatives[15] = "REJECT-PROPOSAL";
        ACLMessage.performatives[16] = "REQUEST";
        ACLMessage.performatives[17] = "REQUEST-WHEN";
        ACLMessage.performatives[18] = "REQUEST-WHENEVER";
        ACLMessage.performatives[19] = "SUBSCRIBE";
        ACLMessage.performatives[20] = "PROXY";
        ACLMessage.performatives[21] = "PROPAGATE";
    }
}

