/*
 * Decompiled with CFR 0.152.
 */
package jade.gui;

import jade.core.AID;
import jade.gui.VisualAIDList;
import jade.gui.VisualPropertiesList;
import jade.gui.VisualStringList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AIDGui
extends JDialog {
    private boolean editable;
    private boolean checkSlots;
    private AID agentAID;
    private JTextField nameText;
    private JCheckBox isLocalName;
    private VisualStringList addressListPanel;
    private VisualAIDList resolverListPanel;
    private VisualPropertiesList propertiesListPanel;
    private AID out;
    private Component parentGUI;
    private AIDGui thisGUI;

    public AIDGui(Component component) {
        this.setTitle("AID");
        this.parentGUI = component;
        this.thisGUI = this;
    }

    public AID ShowAIDGui(AID aID, boolean bl, boolean bl2) {
        this.out = null;
        this.editable = bl;
        this.checkSlots = bl2;
        this.agentAID = aID == null ? new AID() : aID;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JLabel jLabel = new JLabel("NAME");
        jLabel.setPreferredSize(new Dimension(80, 26));
        jLabel.setMinimumSize(new Dimension(80, 26));
        jLabel.setMaximumSize(new Dimension(80, 26));
        jPanel2.add(jLabel);
        this.isLocalName = new JCheckBox();
        this.isLocalName.setVisible(bl);
        this.isLocalName.setToolTipText("Select if the name is not a GUID.");
        jPanel2.add(this.isLocalName);
        this.nameText = new JTextField();
        this.nameText.setBackground(Color.white);
        this.nameText.setText(this.agentAID.getName());
        this.nameText.setPreferredSize(new Dimension(125, 26));
        this.nameText.setMinimumSize(new Dimension(125, 26));
        this.nameText.setMaximumSize(new Dimension(125, 26));
        this.nameText.setEditable(this.editable);
        jPanel2.add(this.nameText);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("Addresses"));
        this.addressListPanel = new VisualStringList(this.agentAID.getAllAddresses(), this.parentGUI);
        this.addressListPanel.setDimension(new Dimension(200, 40));
        this.addressListPanel.setEnabled(this.editable);
        jPanel3.add(this.addressListPanel);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder("Resolvers"));
        this.resolverListPanel = new VisualAIDList(this.agentAID.getAllResolvers(), this.parentGUI);
        this.resolverListPanel.setDimension(new Dimension(200, 40));
        this.resolverListPanel.setEnabled(this.editable);
        this.resolverListPanel.setCheckMandatorySlots(bl2);
        jPanel4.add(this.resolverListPanel);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder("Properties"));
        this.propertiesListPanel = new VisualPropertiesList(this.agentAID.getAllUserDefinedSlot(), this.parentGUI);
        this.propertiesListPanel.setDimension(new Dimension(200, 40));
        this.propertiesListPanel.setEnabled(this.editable);
        jPanel5.add(this.propertiesListPanel);
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("OK")) {
                    if (AIDGui.this.editable) {
                        String string2 = AIDGui.this.nameText.getText().trim();
                        if (AIDGui.this.checkSlots && string2.length() == 0) {
                            JOptionPane.showMessageDialog(AIDGui.this.thisGUI, "AID must have a non-empty name.", "Error Message", 0);
                            return;
                        }
                        AIDGui.this.out = new AID();
                        if (AIDGui.this.isLocalName.isSelected()) {
                            AIDGui.this.out.setLocalName(string2);
                        } else {
                            AIDGui.this.out.setName(string2);
                        }
                        Enumeration enumeration = AIDGui.this.addressListPanel.getContent();
                        while (enumeration.hasMoreElements()) {
                            AIDGui.this.out.addAddresses((String)enumeration.nextElement());
                        }
                        Enumeration enumeration2 = AIDGui.this.resolverListPanel.getContent();
                        while (enumeration2.hasMoreElements()) {
                            AIDGui.this.out.addResolvers((AID)enumeration2.nextElement());
                        }
                        Properties properties = AIDGui.this.propertiesListPanel.getContentProperties();
                        Enumeration<?> enumeration3 = properties.propertyNames();
                        while (enumeration3.hasMoreElements()) {
                            String string3 = (String)enumeration3.nextElement();
                            AIDGui.this.out.addUserDefinedSlot(string3, properties.getProperty(string3));
                        }
                    } else {
                        AIDGui.this.out = AIDGui.this.agentAID;
                    }
                    AIDGui.this.dispose();
                }
            }
        });
        jPanel6.add(jButton);
        if (this.editable) {
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Cancel")) {
                        AIDGui.this.out = null;
                        AIDGui.this.dispose();
                    }
                }
            });
            jPanel6.add(jButton2);
        }
        jPanel.add(jPanel6);
        this.getContentPane().add((Component)jPanel, "Center");
        this.setResizable(false);
        this.setModal(true);
        this.ShowCorrect();
        return this.out;
    }

    private void ShowCorrect() {
        this.pack();
        this.setLocation(this.parentGUI.getX() + (this.parentGUI.getWidth() - this.getWidth()) / 2, this.parentGUI.getY() + (this.parentGUI.getHeight() - this.getHeight()) / 2);
        this.setVisible(true);
        this.toFront();
    }
}

