/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.ContentElementList;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.basic.Action;
import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentManager;
import jade.core.Channel;
import jade.core.ContainerID;
import jade.core.Location;
import jade.core.NameClashException;
import jade.core.NotFoundException;
import jade.core.UnreachableException;
import jade.core.behaviours.CyclicBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.event.MTPEvent;
import jade.core.event.PlatformEvent;
import jade.domain.AMSFipaAgentManagementBehaviour;
import jade.domain.AMSJadeAgentManagementBehaviour;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.domain.FIPAAgentManagement.APDescription;
import jade.domain.FIPAAgentManagement.APService;
import jade.domain.FIPAAgentManagement.AlreadyRegistered;
import jade.domain.FIPAAgentManagement.Deregister;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.domain.FIPAAgentManagement.MissingParameter;
import jade.domain.FIPAAgentManagement.Modify;
import jade.domain.FIPAAgentManagement.NotRegistered;
import jade.domain.FIPAAgentManagement.Register;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.Unauthorised;
import jade.domain.FIPAException;
import jade.domain.JADEAgentManagement.CreateAgent;
import jade.domain.JADEAgentManagement.DebugOff;
import jade.domain.JADEAgentManagement.DebugOn;
import jade.domain.JADEAgentManagement.InstallMTP;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.domain.JADEAgentManagement.KillAgent;
import jade.domain.JADEAgentManagement.KillContainer;
import jade.domain.JADEAgentManagement.QueryAgentsOnLocation;
import jade.domain.JADEAgentManagement.QueryPlatformLocationsAction;
import jade.domain.JADEAgentManagement.ShutdownPlatform;
import jade.domain.JADEAgentManagement.SniffOff;
import jade.domain.JADEAgentManagement.SniffOn;
import jade.domain.JADEAgentManagement.UninstallMTP;
import jade.domain.JADEAgentManagement.WhereIsAgentAction;
import jade.domain.introspection.AddedContainer;
import jade.domain.introspection.AddedMTP;
import jade.domain.introspection.BornAgent;
import jade.domain.introspection.ChangedAgentOwnership;
import jade.domain.introspection.DeadAgent;
import jade.domain.introspection.Event;
import jade.domain.introspection.EventRecord;
import jade.domain.introspection.FrozenAgent;
import jade.domain.introspection.IntrospectionOntology;
import jade.domain.introspection.MovedAgent;
import jade.domain.introspection.Occurred;
import jade.domain.introspection.PlatformDescription;
import jade.domain.introspection.RemovedContainer;
import jade.domain.introspection.RemovedMTP;
import jade.domain.introspection.ResetEvents;
import jade.domain.introspection.ResumedAgent;
import jade.domain.introspection.SuspendedAgent;
import jade.domain.introspection.ThawedAgent;
import jade.domain.mobility.CloneAction;
import jade.domain.mobility.MobileAgentDescription;
import jade.domain.mobility.MobilityOntology;
import jade.domain.mobility.MoveAction;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.mtp.MTPDescriptor;
import jade.mtp.MTPException;
import jade.security.Credentials;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.InputQueue;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Map;
import jade.util.leap.Serializable;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;

public class ams
extends Agent
implements AgentManager.Listener {
    private Logger logger = Logger.getMyLogger(this.getClass().getName());
    private AgentManager myPlatform;
    private Codec codec = new SLCodec();
    private ACLMessage toolNotification = new ACLMessage(7);
    private InputQueue eventQueue = new InputQueue();
    private Hashtable pendingNewAgents = new Hashtable();
    private Hashtable pendingDeadAgents = new Hashtable();
    private Hashtable pendingClonedAgents = new Hashtable();
    private Hashtable pendingMovedAgents = new Hashtable();
    private Hashtable pendingRemovedContainers = new Hashtable();
    private APDescription theProfile = new APDescription();
    private static long LIMIT_MAXRESULT = 100L;

    public ams(AgentManager agentManager) {
        this.myPlatform = agentManager;
        this.myPlatform.addListener(this);
    }

    protected void setup() {
        this.theProfile.setName("\"" + this.getHap() + "\"");
        this.writeAPDescription(this.theProfile);
        this.getContentManager().registerOntology(FIPAManagementOntology.getInstance());
        this.getContentManager().registerOntology(JADEManagementOntology.getInstance());
        this.getContentManager().registerOntology(IntrospectionOntology.getInstance());
        this.getContentManager().registerOntology(MobilityOntology.getInstance());
        this.getContentManager().registerLanguage(this.codec, "fipa-sl0");
        this.getContentManager().registerLanguage(this.codec, "fipa-sl1");
        this.getContentManager().registerLanguage(this.codec, "fipa-sl2");
        this.getContentManager().registerLanguage(this.codec, "fipa-sl");
        MessageTemplate messageTemplate = MessageTemplate.and(MessageTemplate.MatchPerformative(16), MessageTemplate.MatchOntology("FIPA-Agent-Management"));
        AMSFipaAgentManagementBehaviour aMSFipaAgentManagementBehaviour = new AMSFipaAgentManagementBehaviour(this, messageTemplate);
        this.addBehaviour(aMSFipaAgentManagementBehaviour);
        MessageTemplate messageTemplate2 = MessageTemplate.and(MessageTemplate.MatchPerformative(16), MessageTemplate.or(MessageTemplate.MatchOntology("JADE-Agent-Management"), MessageTemplate.MatchOntology("jade-mobility-ontology")));
        AMSJadeAgentManagementBehaviour aMSJadeAgentManagementBehaviour = new AMSJadeAgentManagementBehaviour(this, messageTemplate2);
        this.addBehaviour(aMSJadeAgentManagementBehaviour);
        RegisterToolBehaviour registerToolBehaviour = new RegisterToolBehaviour();
        DeregisterToolBehaviour deregisterToolBehaviour = new DeregisterToolBehaviour();
        EventManager eventManager = new EventManager();
        this.addBehaviour(registerToolBehaviour);
        this.addBehaviour(deregisterToolBehaviour);
        this.addBehaviour(eventManager);
        this.eventQueue.associate(eventManager);
        this.toolNotification.setLanguage("fipa-sl0");
        this.toolNotification.setOntology("JADE-Introspection");
        this.toolNotification.setInReplyTo("tool-subscription");
    }

    void createAgentAction(final CreateAgent createAgent, final AID aID, final JADEPrincipal jADEPrincipal, final Credentials credentials) throws FIPAException {
        final String string = createAgent.getAgentName();
        final AID aID2 = new AID(string, false);
        final String string2 = createAgent.getClassName();
        final ContainerID containerID = createAgent.getContainer();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting Create-agent " + aID2 + " on container " + containerID);
        }
        Iterator iterator = createAgent.getAllArguments();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().toString());
        }
        final String[] stringArray = new String[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            stringArray[n] = (String)arrayList.get(n);
            ++n;
        }
        final JADEPrincipal jADEPrincipal2 = createAgent.getOwner();
        final Credentials credentials2 = createAgent.getInitialCredentials();
        Thread thread = new Thread(){

            public void run() {
                try {
                    ams.this.myPlatform.create(string, string2, stringArray, containerID, jADEPrincipal2, credentials2, jADEPrincipal, credentials);
                }
                catch (UnreachableException unreachableException) {
                    ams.this.sendFailureNotification(createAgent, aID2, new InternalError("Destination container unreachable. " + unreachableException.getMessage()));
                }
                catch (JADESecurityException jADESecurityException) {
                    if (ams.this.logger.isLoggable(Logger.SEVERE)) {
                        ams.this.logger.log(Logger.SEVERE, "Agent " + aID.getName() + " does not have permission to perform action Create-agent: " + jADESecurityException);
                    }
                    ams.this.sendFailureNotification(createAgent, aID2, new Unauthorised());
                }
                catch (NotFoundException notFoundException) {
                    ams.this.sendFailureNotification(createAgent, aID2, new InternalError("Destination container not found. " + notFoundException.getMessage()));
                }
                catch (NameClashException nameClashException) {
                    ams.this.sendFailureNotification(createAgent, aID2, new AlreadyRegistered());
                }
                catch (Throwable throwable) {
                    ams.this.sendFailureNotification(createAgent, aID2, new InternalError(throwable.getMessage()));
                }
            }
        };
        thread.start();
    }

    void killAgentAction(KillAgent killAgent, AID aID, JADEPrincipal jADEPrincipal, Credentials credentials) throws FIPAException {
        AID aID2 = killAgent.getAgent();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting Kill-agent " + aID2);
        }
        try {
            this.myPlatform.kill(aID2, jADEPrincipal, credentials);
        }
        catch (JADESecurityException jADESecurityException) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Agent " + aID.getName() + " does not have permission to perform action KillAgent");
            }
            throw new Unauthorised();
        }
        catch (UnreachableException unreachableException) {
            throw new InternalError("Container not reachable. " + unreachableException.getMessage());
        }
        catch (NotFoundException notFoundException) {
            throw new InternalError("Agent not found. " + notFoundException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError("Unexpected exception. " + exception.getMessage());
        }
    }

    void cloneAgentAction(CloneAction cloneAction, AID aID) throws FIPAException {
        MobileAgentDescription mobileAgentDescription = cloneAction.getMobileAgentDescription();
        AID aID2 = mobileAgentDescription.getName();
        ContainerID containerID = (ContainerID)mobileAgentDescription.getDestination();
        String string = cloneAction.getNewName();
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "Agent " + aID + " requesting Clone-agent " + aID2 + " on container " + containerID);
        }
        try {
            this.myPlatform.copy(aID2, containerID, string);
        }
        catch (JADESecurityException jADESecurityException) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Agent " + aID.getName() + " does not have permission to perform action CloneAgent");
            }
            throw new Unauthorised();
        }
        catch (UnreachableException unreachableException) {
            throw new InternalError("Container not reachable. " + unreachableException.getMessage());
        }
        catch (NotFoundException notFoundException) {
            throw new InternalError("NotFoundException. " + notFoundException.getMessage());
        }
        catch (NameClashException nameClashException) {
            throw new AlreadyRegistered();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError("Unexpected exception. " + exception.getMessage());
        }
    }

    void moveAgentAction(MoveAction moveAction, AID aID) throws FIPAException {
        MobileAgentDescription mobileAgentDescription = moveAction.getMobileAgentDescription();
        AID aID2 = mobileAgentDescription.getName();
        ContainerID containerID = (ContainerID)mobileAgentDescription.getDestination();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting Move-agent " + aID2 + " on container " + containerID);
        }
        try {
            this.myPlatform.move(aID2, containerID);
        }
        catch (JADESecurityException jADESecurityException) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Agent " + aID.getName() + " does not have permission to perform action MoveAgent");
            }
            throw new Unauthorised();
        }
        catch (UnreachableException unreachableException) {
            throw new InternalError("Container not reachable. " + unreachableException.getMessage());
        }
        catch (NotFoundException notFoundException) {
            throw new InternalError("NotFoundException. " + notFoundException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError("Unexpected exception. " + exception.getMessage());
        }
    }

    void killContainerAction(final KillContainer killContainer, final AID aID, final JADEPrincipal jADEPrincipal, final Credentials credentials) throws FIPAException {
        final ContainerID containerID = killContainer.getContainer();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting Kill-container " + containerID);
        }
        Thread thread = new Thread(){

            public void run() {
                try {
                    ams.this.myPlatform.killContainer(containerID, jADEPrincipal, credentials);
                }
                catch (JADESecurityException jADESecurityException) {
                    ams.this.logger.log(Logger.SEVERE, "Agent " + aID.getName() + " does not have permission to perform action Kill-container: " + jADESecurityException);
                    ams.this.sendFailureNotification(killContainer, containerID, new Unauthorised());
                }
                catch (NotFoundException notFoundException) {
                    ams.this.sendFailureNotification(killContainer, containerID, new InternalError("Container not found. " + notFoundException.getMessage()));
                }
                catch (UnreachableException unreachableException) {
                    ams.this.sendFailureNotification(killContainer, containerID, new InternalError("Container unreachable. " + unreachableException.getMessage()));
                }
                catch (Throwable throwable) {
                    ams.this.sendFailureNotification(killContainer, containerID, new InternalError(throwable.getMessage()));
                }
            }
        };
        thread.start();
    }

    void shutdownPlatformAction(ShutdownPlatform shutdownPlatform, final AID aID, final JADEPrincipal jADEPrincipal, final Credentials credentials) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting Shutdown-platform ");
        }
        Thread thread = new Thread(){

            public void run() {
                block2: {
                    try {
                        ams.this.myPlatform.shutdownPlatform(jADEPrincipal, credentials);
                    }
                    catch (JADESecurityException jADESecurityException) {
                        if (!ams.this.logger.isLoggable(Logger.SEVERE)) break block2;
                        ams.this.logger.log(Logger.SEVERE, "Agent " + aID.getName() + " does not have permission to perform action Shutdown-Platform: " + jADESecurityException);
                    }
                }
            }
        };
        thread.start();
    }

    MTPDescriptor installMTPAction(InstallMTP installMTP, AID aID) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting Install-MTP");
        }
        try {
            return this.myPlatform.installMTP(installMTP.getAddress(), installMTP.getContainer(), installMTP.getClassName());
        }
        catch (NotFoundException notFoundException) {
            throw new InternalError("Container not found. " + notFoundException.getMessage());
        }
        catch (UnreachableException unreachableException) {
            throw new InternalError("Container unreachable. " + unreachableException.getMessage());
        }
        catch (MTPException mTPException) {
            throw new InternalError("Error in MTP installation. " + mTPException.getMessage());
        }
    }

    void uninstallMTPAction(UninstallMTP uninstallMTP, AID aID) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting Uninstall-MTP");
        }
        try {
            this.myPlatform.uninstallMTP(uninstallMTP.getAddress(), uninstallMTP.getContainer());
        }
        catch (NotFoundException notFoundException) {
            throw new InternalError("Container not found. " + notFoundException.getMessage());
        }
        catch (UnreachableException unreachableException) {
            throw new InternalError("Container unreachable. " + unreachableException.getMessage());
        }
        catch (MTPException mTPException) {
            throw new InternalError("Error in MTP de-installation. " + mTPException.getMessage());
        }
    }

    void sniffOnAction(SniffOn sniffOn, AID aID) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting Sniff-on");
        }
        try {
            this.myPlatform.sniffOn(sniffOn.getSniffer(), sniffOn.getCloneOfSniffedAgents());
        }
        catch (NotFoundException notFoundException) {
            throw new InternalError("Agent not found. " + notFoundException.getMessage());
        }
        catch (UnreachableException unreachableException) {
            throw new InternalError("Container unreachable. " + unreachableException.getMessage());
        }
    }

    void sniffOffAction(SniffOff sniffOff, AID aID) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting Sniff-off");
        }
        try {
            this.myPlatform.sniffOff(sniffOff.getSniffer(), sniffOff.getCloneOfSniffedAgents());
        }
        catch (NotFoundException notFoundException) {
            throw new InternalError("Agent not found. " + notFoundException.getMessage());
        }
        catch (UnreachableException unreachableException) {
            throw new InternalError("Container unreachable. " + unreachableException.getMessage());
        }
    }

    void debugOnAction(DebugOn debugOn, AID aID) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting Debug-on");
        }
        try {
            this.myPlatform.debugOn(debugOn.getDebugger(), debugOn.getCloneOfDebuggedAgents());
        }
        catch (NotFoundException notFoundException) {
            throw new InternalError("Agent not found. " + notFoundException.getMessage());
        }
        catch (UnreachableException unreachableException) {
            throw new InternalError("Container unreachable. " + unreachableException.getMessage());
        }
    }

    void debugOffAction(DebugOff debugOff, AID aID) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting Debug-off");
        }
        try {
            this.myPlatform.debugOff(debugOff.getDebugger(), debugOff.getCloneOfDebuggedAgents());
        }
        catch (NotFoundException notFoundException) {
            throw new InternalError("Agent not found. " + notFoundException.getMessage());
        }
        catch (UnreachableException unreachableException) {
            throw new InternalError("Container unreachable. " + unreachableException.getMessage());
        }
    }

    Location whereIsAgentAction(WhereIsAgentAction whereIsAgentAction, AID aID) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting Where-is-agent");
        }
        try {
            return this.myPlatform.getContainerID(whereIsAgentAction.getAgentIdentifier());
        }
        catch (NotFoundException notFoundException) {
            throw new InternalError("Agent not found. " + notFoundException.getMessage());
        }
    }

    List queryPlatformLocationsAction(QueryPlatformLocationsAction queryPlatformLocationsAction, AID aID) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting Query-platform-locations");
        }
        ContainerID[] containerIDArray = this.myPlatform.containerIDs();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < containerIDArray.length) {
            arrayList.add(containerIDArray[n]);
            ++n;
        }
        return arrayList;
    }

    List queryAgentsOnLocationAction(QueryAgentsOnLocation queryAgentsOnLocation, AID aID) throws FIPAException {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting Query-agents-on-location");
        }
        try {
            return this.myPlatform.containerAgents((ContainerID)queryAgentsOnLocation.getLocation());
        }
        catch (NotFoundException notFoundException) {
            throw new InternalError("Location not found. " + notFoundException.getMessage());
        }
    }

    void registerAction(Register register, AID aID) throws FIPAException {
        AMSAgentDescription aMSAgentDescription = (AMSAgentDescription)register.getDescription();
        AID aID2 = aMSAgentDescription.getName();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting AMS-registration for " + aID2);
        }
        if (aID2 == null || aID2.getName() == null || aID2.getName().length() == 0) {
            throw new MissingParameter("ams-agent-description", "name");
        }
        try {
            this.myPlatform.amsRegister(aMSAgentDescription);
        }
        catch (AlreadyRegistered alreadyRegistered) {
            throw alreadyRegistered;
        }
        catch (JADESecurityException jADESecurityException) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Agent " + aID.getName() + " does not have permission to perform action Register");
            }
            throw new Unauthorised();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError("Unexpected exception. " + exception.getMessage());
        }
    }

    void deregisterAction(Deregister deregister, AID aID) throws FIPAException {
        AMSAgentDescription aMSAgentDescription = (AMSAgentDescription)deregister.getDescription();
        AID aID2 = aMSAgentDescription.getName();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting AMS-deregistration for " + aID2);
        }
        if (aID2 == null || aID2.getName() == null || aID2.getName().length() == 0) {
            throw new MissingParameter("ams-agent-description", "name");
        }
        try {
            this.myPlatform.amsDeregister(aMSAgentDescription);
        }
        catch (NotRegistered notRegistered) {
            throw notRegistered;
        }
        catch (JADESecurityException jADESecurityException) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Agent " + aID.getName() + " does not have permission to perform action Deregister");
            }
            throw new Unauthorised();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError("Unexpected exception. " + exception.getMessage());
        }
    }

    void modifyAction(Modify modify, AID aID) throws FIPAException {
        AMSAgentDescription aMSAgentDescription = (AMSAgentDescription)modify.getDescription();
        AID aID2 = aMSAgentDescription.getName();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting AMS-modification for " + aID2);
            this.logger.log(Logger.FINE, "New state is " + aMSAgentDescription.getState() + ". New ownership is " + aMSAgentDescription.getOwnership());
        }
        if (aID2 == null || aID2.getName() == null || aID2.getName().length() == 0) {
            throw new MissingParameter("ams-agent-description", "name");
        }
        try {
            this.myPlatform.amsModify(aMSAgentDescription);
        }
        catch (NotRegistered notRegistered) {
            throw notRegistered;
        }
        catch (UnreachableException unreachableException) {
            throw new InternalError("Container not reachable. " + unreachableException.getMessage());
        }
        catch (NotFoundException notFoundException) {
            throw new InternalError("Agent not found. " + notFoundException.getMessage());
        }
        catch (JADESecurityException jADESecurityException) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Agent " + aID.getName() + " does not have permission to perform action Modify");
            }
            throw new Unauthorised();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError("Unexpected exception. " + exception.getMessage());
        }
    }

    List searchAction(Search search, AID aID) {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting AMS-search");
        }
        return this.myPlatform.amsSearch((AMSAgentDescription)search.getDescription(), this.getActualMaxResults(search.getConstraints()));
    }

    private long getActualMaxResults(SearchConstraints searchConstraints) {
        long l = searchConstraints.getMaxResults() == null ? 1L : searchConstraints.getMaxResults();
        l = l < 0L ? LIMIT_MAXRESULT : l;
        return l;
    }

    APDescription getDescriptionAction(AID aID) {
        if (aID != null && this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Agent " + aID + " requesting AMS-get-description");
        }
        this.theProfile.clearAllAPServices();
        Iterator iterator = this.platformMTPs().iterator();
        while (iterator.hasNext()) {
            MTPDescriptor mTPDescriptor = (MTPDescriptor)iterator.next();
            this.theProfile.addAPServices(new APService(mTPDescriptor.getName(), mTPDescriptor.getAddresses()));
        }
        return this.theProfile;
    }

    public void resetEvents(boolean bl) {
        block7: {
            this.eventQueue.clear();
            ResetEvents resetEvents = new ResetEvents();
            EventRecord eventRecord = new EventRecord(resetEvents, this.here());
            this.eventQueue.put(eventRecord);
            if (!bl) break block7;
            try {
                Serializable serializable;
                AID[] aIDArray;
                Concept concept;
                ContainerID[] containerIDArray = this.myPlatform.containerIDs();
                int n = 0;
                while (n < containerIDArray.length) {
                    concept = containerIDArray[n];
                    aIDArray = new AddedContainer();
                    aIDArray.setContainer((ContainerID)concept);
                    aIDArray.setOwnership(this.getContainerOwnership((ContainerID)concept));
                    eventRecord = new EventRecord((Event)aIDArray, this.here());
                    this.eventQueue.put(eventRecord);
                    Iterator iterator = this.myPlatform.containerMTPs((ContainerID)concept).iterator();
                    while (iterator.hasNext()) {
                        serializable = new AddedMTP();
                        ((AddedMTP)serializable).setAddress(((MTPDescriptor)iterator.next()).getAddresses()[0]);
                        ((AddedMTP)serializable).setWhere((ContainerID)concept);
                        eventRecord = new EventRecord((Event)serializable, this.here());
                        this.eventQueue.put(eventRecord);
                    }
                    ++n;
                }
                concept = new PlatformDescription();
                ((PlatformDescription)concept).setPlatform(this.getDescriptionAction(null));
                eventRecord = new EventRecord((Event)concept, this.here());
                this.eventQueue.put(eventRecord);
                aIDArray = this.myPlatform.agentNames();
                int n2 = 0;
                while (n2 < aIDArray.length) {
                    serializable = aIDArray[n2];
                    ContainerID containerID = this.myPlatform.getContainerID((AID)serializable);
                    AMSAgentDescription aMSAgentDescription = this.myPlatform.getAMSDescription((AID)serializable);
                    BornAgent bornAgent = new BornAgent();
                    Serializable serializable2 = serializable;
                    if (aMSAgentDescription != null) {
                        if (aMSAgentDescription.getName() != null) {
                            serializable2 = aMSAgentDescription.getName();
                        }
                        bornAgent.setState(aMSAgentDescription.getState());
                        bornAgent.setOwnership(aMSAgentDescription.getOwnership());
                    }
                    bornAgent.setAgent((AID)serializable2);
                    bornAgent.setWhere(containerID);
                    eventRecord = new EventRecord(bornAgent, this.here());
                    this.eventQueue.put(eventRecord);
                    ++n2;
                }
            }
            catch (NotFoundException notFoundException) {
                notFoundException.printStackTrace();
            }
        }
    }

    public void bornAgent(PlatformEvent platformEvent) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, platformEvent.toString());
        }
        ContainerID containerID = platformEvent.getContainer();
        AID aID = platformEvent.getAgent();
        String string = platformEvent.getNewOwnership();
        BornAgent bornAgent = new BornAgent();
        bornAgent.setAgent(aID);
        bornAgent.setWhere(containerID);
        bornAgent.setState("active");
        bornAgent.setOwnership(string);
        EventRecord eventRecord = new EventRecord(bornAgent, this.here());
        eventRecord.setWhen(platformEvent.getTime());
        this.eventQueue.put(eventRecord);
    }

    public void deadAgent(PlatformEvent platformEvent) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, platformEvent.toString());
        }
        ContainerID containerID = platformEvent.getContainer();
        AID aID = platformEvent.getAgent();
        DeadAgent deadAgent = new DeadAgent();
        deadAgent.setAgent(aID);
        deadAgent.setWhere(containerID);
        EventRecord eventRecord = new EventRecord(deadAgent, this.here());
        eventRecord.setWhen(platformEvent.getTime());
        this.eventQueue.put(eventRecord);
    }

    public void suspendedAgent(PlatformEvent platformEvent) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, platformEvent.toString());
        }
        ContainerID containerID = platformEvent.getContainer();
        AID aID = platformEvent.getAgent();
        SuspendedAgent suspendedAgent = new SuspendedAgent();
        suspendedAgent.setAgent(aID);
        suspendedAgent.setWhere(containerID);
        EventRecord eventRecord = new EventRecord(suspendedAgent, this.here());
        eventRecord.setWhen(platformEvent.getTime());
        this.eventQueue.put(eventRecord);
    }

    public void resumedAgent(PlatformEvent platformEvent) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, platformEvent.toString());
        }
        ContainerID containerID = platformEvent.getContainer();
        AID aID = platformEvent.getAgent();
        ResumedAgent resumedAgent = new ResumedAgent();
        resumedAgent.setAgent(aID);
        resumedAgent.setWhere(containerID);
        EventRecord eventRecord = new EventRecord(resumedAgent, this.here());
        eventRecord.setWhen(platformEvent.getTime());
        this.eventQueue.put(eventRecord);
    }

    public void frozenAgent(PlatformEvent platformEvent) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, platformEvent.toString());
        }
        ContainerID containerID = platformEvent.getContainer();
        AID aID = platformEvent.getAgent();
        ContainerID containerID2 = platformEvent.getNewContainer();
        FrozenAgent frozenAgent = new FrozenAgent();
        frozenAgent.setAgent(aID);
        frozenAgent.setWhere(containerID);
        frozenAgent.setBufferContainer(containerID2);
        EventRecord eventRecord = new EventRecord(frozenAgent, this.here());
        eventRecord.setWhen(platformEvent.getTime());
        this.eventQueue.put(eventRecord);
    }

    public void thawedAgent(PlatformEvent platformEvent) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, platformEvent.toString());
        }
        ContainerID containerID = platformEvent.getContainer();
        AID aID = platformEvent.getAgent();
        ContainerID containerID2 = platformEvent.getNewContainer();
        ThawedAgent thawedAgent = new ThawedAgent();
        thawedAgent.setAgent(aID);
        thawedAgent.setWhere(containerID);
        thawedAgent.setBufferContainer(containerID2);
        EventRecord eventRecord = new EventRecord(thawedAgent, this.here());
        eventRecord.setWhen(platformEvent.getTime());
        this.eventQueue.put(eventRecord);
    }

    public void movedAgent(PlatformEvent platformEvent) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, platformEvent.toString());
        }
        ContainerID containerID = platformEvent.getContainer();
        ContainerID containerID2 = platformEvent.getNewContainer();
        AID aID = platformEvent.getAgent();
        MovedAgent movedAgent = new MovedAgent();
        movedAgent.setAgent(aID);
        movedAgent.setFrom(containerID);
        movedAgent.setTo(containerID2);
        EventRecord eventRecord = new EventRecord(movedAgent, this.here());
        eventRecord.setWhen(platformEvent.getTime());
        this.eventQueue.put(eventRecord);
    }

    public void changedAgentPrincipal(PlatformEvent platformEvent) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, platformEvent.toString());
        }
        ContainerID containerID = platformEvent.getContainer();
        AID aID = platformEvent.getAgent();
        ChangedAgentOwnership changedAgentOwnership = new ChangedAgentOwnership();
        changedAgentOwnership.setAgent(aID);
        changedAgentOwnership.setWhere(containerID);
        changedAgentOwnership.setFrom(platformEvent.getOldOwnership());
        changedAgentOwnership.setTo(platformEvent.getNewOwnership());
        EventRecord eventRecord = new EventRecord(changedAgentOwnership, this.here());
        eventRecord.setWhen(platformEvent.getTime());
        this.eventQueue.put(eventRecord);
    }

    public void addedContainer(PlatformEvent platformEvent) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, platformEvent.toString());
        }
        ContainerID containerID = platformEvent.getContainer();
        String string = containerID.getName();
        AddedContainer addedContainer = new AddedContainer();
        addedContainer.setContainer(containerID);
        EventRecord eventRecord = new EventRecord(addedContainer, this.here());
        eventRecord.setWhen(platformEvent.getTime());
        this.eventQueue.put(eventRecord);
    }

    public void removedContainer(PlatformEvent platformEvent) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, platformEvent.toString());
        }
        ContainerID containerID = platformEvent.getContainer();
        String string = containerID.getName();
        RemovedContainer removedContainer = new RemovedContainer();
        removedContainer.setContainer(containerID);
        EventRecord eventRecord = new EventRecord(removedContainer, this.here());
        eventRecord.setWhen(platformEvent.getTime());
        this.eventQueue.put(eventRecord);
    }

    public synchronized void changedContainerPrincipal(PlatformEvent platformEvent) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, platformEvent.toString());
        }
    }

    public synchronized void addedMTP(MTPEvent mTPEvent) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "MTPEvent [added MTP]");
        }
        Channel channel = mTPEvent.getChannel();
        ContainerID containerID = mTPEvent.getPlace();
        String string = channel.getProtocol();
        String string2 = channel.getAddress();
        AddedMTP addedMTP = new AddedMTP();
        addedMTP.setAddress(string2);
        addedMTP.setProto(string);
        addedMTP.setWhere(containerID);
        EventRecord eventRecord = new EventRecord(addedMTP, this.here());
        eventRecord.setWhen(mTPEvent.getTime());
        this.eventQueue.put(eventRecord);
        PlatformDescription platformDescription = new PlatformDescription();
        platformDescription.setPlatform(this.getDescriptionAction(null));
        eventRecord = new EventRecord(platformDescription, this.here());
        eventRecord.setWhen(mTPEvent.getTime());
        this.eventQueue.put(eventRecord);
    }

    public synchronized void removedMTP(MTPEvent mTPEvent) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "MTPEvent [removed MTP]");
        }
        Channel channel = mTPEvent.getChannel();
        ContainerID containerID = mTPEvent.getPlace();
        String string = channel.getProtocol();
        String string2 = channel.getAddress();
        RemovedMTP removedMTP = new RemovedMTP();
        removedMTP.setAddress(string2);
        removedMTP.setProto(string);
        removedMTP.setWhere(containerID);
        EventRecord eventRecord = new EventRecord(removedMTP, this.here());
        eventRecord.setWhen(mTPEvent.getTime());
        this.eventQueue.put(eventRecord);
        PlatformDescription platformDescription = new PlatformDescription();
        platformDescription.setPlatform(this.getDescriptionAction(null));
        eventRecord = new EventRecord(platformDescription, this.here());
        eventRecord.setWhen(mTPEvent.getTime());
        this.eventQueue.put(eventRecord);
    }

    public void messageIn(MTPEvent mTPEvent) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "MTPEvent [message in]");
        }
    }

    public void messageOut(MTPEvent mTPEvent) {
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "MTPEvent [message out]");
        }
    }

    private String getContainerOwnership(ContainerID containerID) {
        return "none";
    }

    private String getAgentOwnership(AID aID) {
        String string = null;
        try {
            AMSAgentDescription aMSAgentDescription = this.myPlatform.getAMSDescription(aID);
            string = aMSAgentDescription.getOwnership();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string != null ? string : "none";
    }

    private void writeAPDescription(APDescription aPDescription) {
        try {
            FileWriter fileWriter = new FileWriter(this.getProperty("file-dir", "") + "APDescription.txt");
            fileWriter.write(aPDescription.toString());
            fileWriter.write(10);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private List platformMTPs() {
        ArrayList arrayList = new ArrayList();
        ContainerID[] containerIDArray = this.myPlatform.containerIDs();
        int n = 0;
        while (n < containerIDArray.length) {
            try {
                List list = this.myPlatform.containerMTPs(containerIDArray[n]);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            ++n;
        }
        return arrayList;
    }

    void storeNotification(Concept concept, Object object, ACLMessage aCLMessage) {
        if (concept instanceof CreateAgent) {
            this.pendingNewAgents.put(object, aCLMessage);
        }
        if (concept instanceof KillAgent) {
            this.pendingDeadAgents.put(object, aCLMessage);
        } else if (concept instanceof CloneAction) {
            this.pendingClonedAgents.put(object, aCLMessage);
        } else if (concept instanceof MoveAction) {
            this.pendingMovedAgents.put(object, aCLMessage);
        } else if (concept instanceof KillContainer) {
            this.pendingRemovedContainers.put(object, aCLMessage);
        }
    }

    private void sendFailureNotification(final Concept concept, final Object object, final FIPAException fIPAException) {
        this.addBehaviour(new OneShotBehaviour(this){

            public void action() {
                ACLMessage aCLMessage = null;
                if (concept instanceof CreateAgent) {
                    aCLMessage = (ACLMessage)ams.this.pendingNewAgents.remove(object);
                } else if (concept instanceof KillContainer) {
                    aCLMessage = (ACLMessage)ams.this.pendingRemovedContainers.remove(object);
                }
                if (aCLMessage != null) {
                    aCLMessage.setPerformative(6);
                    Action action = new Action(ams.this.getAID(), concept);
                    ContentElementList contentElementList = new ContentElementList();
                    contentElementList.add(action);
                    contentElementList.add(fIPAException);
                    try {
                        ams.this.getContentManager().fillContent(aCLMessage, contentElementList);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        aCLMessage.setContent("(" + fIPAException.getMessage() + ")");
                    }
                    ams.this.send(aCLMessage);
                }
            }
        });
    }

    static /* synthetic */ Hashtable access$700(ams ams2) {
        return ams2.pendingDeadAgents;
    }

    static /* synthetic */ Hashtable access$800(ams ams2) {
        return ams2.pendingMovedAgents;
    }

    static /* synthetic */ Hashtable access$1000(ams ams2) {
        return ams2.pendingClonedAgents;
    }

    static /* synthetic */ void access$1100(ams ams2, APDescription aPDescription) {
        ams2.writeAPDescription(aPDescription);
    }

    private class EventManager
    extends CyclicBehaviour {
        private Map handlers = new HashMap();

        public EventManager() {
            this.handlers.put("Removed-Container", new Handler(this){
                private final /* synthetic */ EventManager this$1;
                {
                    this.this$1 = eventManager;
                }

                public void handle(Event event) {
                    RemovedContainer removedContainer = (RemovedContainer)event;
                    ContainerID containerID = removedContainer.getContainer();
                    ACLMessage aCLMessage = (ACLMessage)ams.access$600(EventManager.access$500(this.this$1)).remove(containerID);
                    if (aCLMessage != null) {
                        EventManager.access$500(this.this$1).send(aCLMessage);
                    }
                }
            });
            this.handlers.put("Dead-Agent", new Handler(this){
                private final /* synthetic */ EventManager this$1;
                {
                    this.this$1 = eventManager;
                }

                public void handle(Event event) {
                    DeadAgent deadAgent = (DeadAgent)event;
                    AID aID = deadAgent.getAgent();
                    ACLMessage aCLMessage = (ACLMessage)ams.access$700(EventManager.access$500(this.this$1)).remove(aID);
                    if (aCLMessage != null) {
                        EventManager.access$500(this.this$1).send(aCLMessage);
                    }
                }
            });
            this.handlers.put("Moved-Agent", new Handler(this){
                private final /* synthetic */ EventManager this$1;
                {
                    this.this$1 = eventManager;
                }

                public void handle(Event event) {
                    MovedAgent movedAgent = (MovedAgent)event;
                    AID aID = movedAgent.getAgent();
                    ACLMessage aCLMessage = (ACLMessage)ams.access$800(EventManager.access$500(this.this$1)).remove(aID);
                    if (aCLMessage != null) {
                        EventManager.access$500(this.this$1).send(aCLMessage);
                    }
                }
            });
            this.handlers.put("Born-Agent", new Handler(this){
                private final /* synthetic */ EventManager this$1;
                {
                    this.this$1 = eventManager;
                }

                public void handle(Event event) {
                    BornAgent bornAgent = (BornAgent)event;
                    AID aID = bornAgent.getAgent();
                    ACLMessage aCLMessage = (ACLMessage)ams.access$900(EventManager.access$500(this.this$1)).remove(aID);
                    if (aCLMessage == null) {
                        aCLMessage = (ACLMessage)ams.access$1000(EventManager.access$500(this.this$1)).remove(aID);
                    }
                    if (aCLMessage != null) {
                        EventManager.access$500(this.this$1).send(aCLMessage);
                    }
                }
            });
            this.handlers.put("platform-description", new Handler(this){
                private final /* synthetic */ EventManager this$1;
                {
                    this.this$1 = eventManager;
                }

                public void handle(Event event) {
                    ams.access$1100(EventManager.access$500(this.this$1), ((PlatformDescription)event).getPlatform());
                }
            });
        }

        public void action() {
            block6: {
                try {
                    EventRecord eventRecord = (EventRecord)ams.this.eventQueue.get();
                    if (eventRecord != null) {
                        Serializable serializable;
                        Handler handler;
                        Event event = eventRecord.getWhat();
                        if (ams.this.logger.isLoggable(Logger.FINE)) {
                            ams.this.logger.log(Logger.FINE, "EventManager serving event " + event.getName());
                        }
                        if ((handler = (Handler)this.handlers.get(event.getName())) != null) {
                            handler.handle(event);
                        }
                        ams.this.toolNotification.clearAllReceiver();
                        AID[] aIDArray = ams.this.myPlatform.agentTools();
                        int n = 0;
                        while (n < aIDArray.length) {
                            serializable = aIDArray[n];
                            ams.this.toolNotification.addReceiver((AID)serializable);
                            ++n;
                        }
                        serializable = new Occurred();
                        ((Occurred)serializable).setWhat(eventRecord);
                        ams.this.getContentManager().fillContent(ams.this.toolNotification, (ContentElement)serializable);
                        this.myAgent.send(ams.this.toolNotification);
                        break block6;
                    }
                    this.block();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }

        static /* synthetic */ ams access$500(EventManager eventManager) {
            return eventManager.ams.this;
        }
    }

    private static interface Handler {
        public void handle(Event var1);
    }

    private class DeregisterToolBehaviour
    extends CyclicBehaviour {
        private MessageTemplate cancellationTemplate;

        DeregisterToolBehaviour() {
            MessageTemplate messageTemplate = MessageTemplate.MatchLanguage("fipa-sl0");
            MessageTemplate messageTemplate2 = MessageTemplate.MatchOntology("JADE-Introspection");
            MessageTemplate messageTemplate3 = MessageTemplate.and(messageTemplate, messageTemplate2);
            messageTemplate = MessageTemplate.MatchReplyWith("tool-cancellation");
            messageTemplate2 = MessageTemplate.MatchPerformative(2);
            this.cancellationTemplate = MessageTemplate.and(messageTemplate, messageTemplate2);
            this.cancellationTemplate = MessageTemplate.and(this.cancellationTemplate, messageTemplate3);
        }

        public void action() {
            ACLMessage aCLMessage = ams.this.receive(this.cancellationTemplate);
            if (aCLMessage != null) {
                ams.this.myPlatform.removeTool(aCLMessage.getSender());
            } else {
                this.block();
            }
        }
    }

    private class RegisterToolBehaviour
    extends CyclicBehaviour {
        private MessageTemplate subscriptionTemplate;

        RegisterToolBehaviour() {
            MessageTemplate messageTemplate = MessageTemplate.MatchLanguage("fipa-sl0");
            MessageTemplate messageTemplate2 = MessageTemplate.MatchOntology("JADE-Introspection");
            MessageTemplate messageTemplate3 = MessageTemplate.and(messageTemplate, messageTemplate2);
            messageTemplate = MessageTemplate.MatchReplyWith("tool-subscription");
            messageTemplate2 = MessageTemplate.MatchPerformative(19);
            this.subscriptionTemplate = MessageTemplate.and(messageTemplate, messageTemplate2);
            this.subscriptionTemplate = MessageTemplate.and(this.subscriptionTemplate, messageTemplate3);
        }

        public void action() {
            ACLMessage aCLMessage = ams.this.receive(this.subscriptionTemplate);
            if (aCLMessage != null) {
                AID aID = aCLMessage.getSender();
                ams.this.toolNotification.clearAllReceiver();
                ams.this.toolNotification.addReceiver(aID);
                try {
                    Concept concept;
                    Object object;
                    AID[] aIDArray;
                    ResetEvents resetEvents = new ResetEvents();
                    EventRecord eventRecord = new EventRecord(resetEvents, ams.this.here());
                    Occurred occurred = new Occurred();
                    occurred.setWhat(eventRecord);
                    try {
                        ams.this.getContentManager().fillContent(ams.this.toolNotification, occurred);
                        ams.this.send(ams.this.toolNotification);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    ContainerID[] containerIDArray = ams.this.myPlatform.containerIDs();
                    int n = 0;
                    while (n < containerIDArray.length) {
                        aIDArray = containerIDArray[n];
                        AddedContainer addedContainer = new AddedContainer();
                        addedContainer.setContainer((ContainerID)aIDArray);
                        addedContainer.setOwnership(ams.this.getContainerOwnership((ContainerID)aIDArray));
                        eventRecord = new EventRecord(addedContainer, ams.this.here());
                        occurred = new Occurred();
                        occurred.setWhat(eventRecord);
                        try {
                            ams.this.getContentManager().fillContent(ams.this.toolNotification, occurred);
                            ams.this.send(ams.this.toolNotification);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        object = ams.this.myPlatform.containerMTPs((ContainerID)aIDArray).iterator();
                        while (object.hasNext()) {
                            concept = new AddedMTP();
                            ((AddedMTP)concept).setAddress(((MTPDescriptor)object.next()).getAddresses()[0]);
                            ((AddedMTP)concept).setWhere((ContainerID)aIDArray);
                            eventRecord = new EventRecord((Event)concept, ams.this.here());
                            occurred = new Occurred();
                            occurred.setWhat(eventRecord);
                            try {
                                ams.this.getContentManager().fillContent(ams.this.toolNotification, occurred);
                                ams.this.send(ams.this.toolNotification);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        ++n;
                    }
                    aIDArray = ams.this.myPlatform.agentNames();
                    int n2 = 0;
                    while (n2 < aIDArray.length) {
                        object = aIDArray[n2];
                        concept = ams.this.myPlatform.getContainerID((AID)object);
                        AMSAgentDescription aMSAgentDescription = ams.this.myPlatform.getAMSDescription((AID)object);
                        BornAgent bornAgent = new BornAgent();
                        Serializable serializable = object;
                        if (aMSAgentDescription != null) {
                            if (aMSAgentDescription.getName() != null) {
                                serializable = aMSAgentDescription.getName();
                            }
                            bornAgent.setState(aMSAgentDescription.getState());
                            bornAgent.setOwnership(aMSAgentDescription.getOwnership());
                        }
                        bornAgent.setAgent((AID)serializable);
                        bornAgent.setWhere((ContainerID)concept);
                        eventRecord = new EventRecord(bornAgent, ams.this.here());
                        occurred = new Occurred();
                        occurred.setWhat(eventRecord);
                        try {
                            ams.this.getContentManager().fillContent(ams.this.toolNotification, occurred);
                            ams.this.send(ams.this.toolNotification);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        ++n2;
                    }
                    object = new PlatformDescription();
                    ((PlatformDescription)object).setPlatform(ams.this.getDescriptionAction(null));
                    eventRecord = new EventRecord((Event)object, ams.this.here());
                    occurred = new Occurred();
                    occurred.setWhat(eventRecord);
                    try {
                        ams.this.getContentManager().fillContent(ams.this.toolNotification, occurred);
                        ams.this.send(ams.this.toolNotification);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    ams.this.myPlatform.addTool(aID);
                }
                catch (NotFoundException notFoundException) {
                    notFoundException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.block();
            }
        }
    }
}

