/*
 * Decompiled with CFR 0.152.
 */
package jade.domain.KBManagement;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.KBManagement.KB;
import jade.domain.KBManagement.LeaseManager;
import jade.lang.acl.ACLMessage;
import jade.proto.SubscriptionResponder;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Map;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class MemKB
extends KB {
    protected Map facts = new HashMap();
    protected Hashtable subscriptions = new Hashtable();
    protected LeaseManager lm;
    protected int currentReg = 0;
    protected SubscriptionResponder sr;
    protected static final int MAX_REGISTER_WITHOUT_CLEAN = 100;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());
    int offSetForSubscriptionToReturn = 0;

    public MemKB(int n) {
        super(n);
    }

    protected Object insert(Object object, Object object2) {
        ++this.currentReg;
        if (this.currentReg > 100) {
            this.clean();
            this.currentReg = 0;
        }
        return this.facts.put(object, object2);
    }

    protected Object remove(Object object) {
        return this.facts.remove(object);
    }

    protected abstract boolean match(Object var1, Object var2);

    protected abstract void clean();

    public List search(Object object, int n) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.facts.values().iterator();
        int n2 = 0;
        while (iterator.hasNext() && n2 < n) {
            Object e = iterator.next();
            if (!this.match(object, e)) continue;
            arrayList.add(e);
            ++n2;
        }
        return arrayList;
    }

    public void subscribe(Object object, SubscriptionResponder.Subscription subscription) throws NotUnderstoodException {
        try {
            DFAgentDescription dFAgentDescription = (DFAgentDescription)object;
            ACLMessage aCLMessage = subscription.getMessage();
            this.subscriptions.put(dFAgentDescription, subscription);
        }
        catch (Exception exception) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Subscribe error: " + exception.getMessage());
            }
            throw new NotUnderstoodException(exception.getMessage());
        }
    }

    public Enumeration getSubscriptionDfAgentDescriptions() {
        return this.subscriptions.keys();
    }

    private SubscriptionResponder.Subscription getSubscription(Object object) {
        SubscriptionResponder.Subscription subscription = (SubscriptionResponder.Subscription)this.subscriptions.get(object);
        return subscription;
    }

    public Enumeration getSubscriptions() {
        return this.subscriptions.elements();
    }

    public Enumeration getSubscriptions(int n) {
        return null;
    }

    public void unsubscribe(SubscriptionResponder.Subscription subscription) {
        ACLMessage aCLMessage = subscription.getMessage();
        String string = aCLMessage.getConversationId();
        Enumeration enumeration = this.getSubscriptionDfAgentDescriptions();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                DFAgentDescription dFAgentDescription = (DFAgentDescription)enumeration.nextElement();
                SubscriptionResponder.Subscription subscription2 = this.getSubscription(dFAgentDescription);
                if (!subscription2.getMessage().getConversationId().equals(string)) continue;
                this.subscriptions.remove(dFAgentDescription);
                break;
            }
        }
    }

    protected final boolean matchAID(AID aID, AID aID2) {
        Object object;
        boolean bl;
        Object object2;
        Object object3;
        String string = aID.getName();
        if (!(string == null || (object3 = aID2.getName()) != null && string.equalsIgnoreCase((String)object3))) {
            return false;
        }
        object3 = aID.getAllAddresses();
        Iterator iterator = aID2.getAllAddresses();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            bl = false;
            while (!bl && iterator.hasNext()) {
                object = (String)iterator.next();
                bl = ((String)object2).equalsIgnoreCase((String)object);
            }
            if (bl) continue;
            return false;
        }
        object3 = aID.getAllResolvers();
        iterator = aID2.getAllResolvers();
        while (object3.hasNext()) {
            object2 = (AID)object3.next();
            bl = false;
            while (!bl && iterator.hasNext()) {
                object = (AID)iterator.next();
                bl = this.matchAID((AID)object2, (AID)object);
            }
            if (bl) continue;
            return false;
        }
        return true;
    }
}

