/*
 * Decompiled with CFR 0.152.
 */
package jade.domain.KBManagement;

import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.KBManagement.LeaseManager;
import jade.proto.SubscriptionResponder;
import jade.util.Logger;
import jade.util.leap.List;
import java.util.Enumeration;

public abstract class KB {
    protected LeaseManager lm;
    protected SubscriptionResponder sr;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());
    private int maxResultLimit = -1;

    public KB(int n) {
        this.maxResultLimit = n;
    }

    public void setSubscriptionResponder(SubscriptionResponder subscriptionResponder) {
        this.sr = subscriptionResponder;
    }

    public void setLeaseManager(LeaseManager leaseManager) {
        this.lm = leaseManager;
    }

    public Object register(Object object, Object object2) {
        if (this.lm.isExpired(this.lm.getLeaseTime(object2))) {
            if (this.logger.isLoggable(Logger.WARNING)) {
                this.logger.log(Logger.WARNING, "Fact with lease time already expired");
            }
            return null;
        }
        this.lm.grantLeaseTime(object2);
        Object object3 = this.insert(object, object2);
        if (object3 != null && this.lm.isExpired(this.lm.getLeaseTime(object3))) {
            object3 = null;
        }
        return object3;
    }

    public Object deregister(Object object) {
        Object object2 = this.remove(object);
        if (object2 != null && this.lm.isExpired(this.lm.getLeaseTime(object2))) {
            object2 = null;
        }
        return object2;
    }

    protected abstract Object insert(Object var1, Object var2);

    protected abstract Object remove(Object var1);

    public List search(Object object) {
        return this.search(object, this.maxResultLimit);
    }

    public abstract List search(Object var1, int var2);

    public abstract void subscribe(Object var1, SubscriptionResponder.Subscription var2) throws NotUnderstoodException;

    public abstract Enumeration getSubscriptions();

    public abstract void unsubscribe(SubscriptionResponder.Subscription var1);
}

