/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.KBManagement.DBKB;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.StringACLCodec;
import jade.proto.SubscriptionResponder;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.Collection;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Properties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.security.MessageDigest;
import java.sql.BatchUpdateException;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import starlight.util.Base64;

public class DFDBKB
extends DBKB {
    private static final int MAX_REGISTER_WITHOUT_CLEAN = 100;
    private Logger logger;
    private int regsCnt = 0;
    private PreparedStatement stm_selNrOfDescrForAID;
    private PreparedStatement stm_selAgentAddresses;
    private PreparedStatement stm_selAgentResolverAIDs;
    private PreparedStatement stm_selAgentUserDefSlot;
    private PreparedStatement stm_selLease;
    private PreparedStatement stm_selProtocols;
    private PreparedStatement stm_selLanguages;
    private PreparedStatement stm_selOntologies;
    private PreparedStatement stm_selServices;
    private PreparedStatement stm_selServiceProtocols;
    private PreparedStatement stm_selServiceLanguages;
    private PreparedStatement stm_selServiceOntologies;
    private PreparedStatement stm_selServiceProperties;
    private PreparedStatement stm_selExpiredDescr;
    private PreparedStatement stm_selSubscriptions;
    private PreparedStatement stm_insAgentDescr;
    private PreparedStatement stm_insAgentAddress;
    private PreparedStatement stm_insAgentUserDefSlot;
    private PreparedStatement stm_insAgentResolverAID;
    private PreparedStatement stm_insLanguage;
    private PreparedStatement stm_insOntology;
    private PreparedStatement stm_insProtocol;
    private PreparedStatement stm_insService;
    private PreparedStatement stm_insServiceProtocol;
    private PreparedStatement stm_insServiceOntology;
    private PreparedStatement stm_insServiceLanguage;
    private PreparedStatement stm_insServiceProperty;
    private PreparedStatement stm_insSubscription;
    private PreparedStatement stm_delAgentDescr;
    private PreparedStatement stm_delAgentUserDefSlot;
    private PreparedStatement stm_delAgentResolver;
    private PreparedStatement stm_delAgentAddress;
    private PreparedStatement stm_selDescrId;
    private PreparedStatement stm_selServiceId;
    private PreparedStatement stm_delService;
    private PreparedStatement stm_delLanguage;
    private PreparedStatement stm_delProtocol;
    private PreparedStatement stm_delOntology;
    private PreparedStatement stm_delServiceLanguage;
    private PreparedStatement stm_delServiceOntology;
    private PreparedStatement stm_delServiceProtocol;
    private PreparedStatement stm_delServiceProperty;
    private PreparedStatement stm_delSubscription;
    protected String DEFAULT_LONGVARCHAR_TYPE = "LONGVARCHAR";
    private StringACLCodec codec = new StringACLCodec();

    public DFDBKB(int n, String string, String string2, String string3, String string4, boolean bl) throws SQLException {
        super(string, string2, string3, string4, n, bl);
    }

    protected void setup() throws SQLException {
        block3: {
            this.logger = Logger.getMyLogger(this.getClass().getName());
            try {
                this.conn.setAutoCommit(false);
            }
            catch (Exception exception) {
                if (!this.logger.isLoggable(Logger.WARNING)) break block3;
                this.logger.log(Logger.WARNING, "Disabling auto-commit failed.");
            }
        }
        if (this.cleanTables) {
            this.dropDFTables();
        }
        this.createDFTables();
        this.initPrepStmts();
        this.clean();
    }

    protected String getLongVarCharType() {
        String string = this.DEFAULT_LONGVARCHAR_TYPE;
        try {
            DatabaseMetaData databaseMetaData = this.conn.getMetaData();
            ResultSet resultSet = databaseMetaData.getTypeInfo();
            int n = -1;
            while (resultSet.next()) {
                int n2 = Integer.parseInt(resultSet.getString("DATA_TYPE"));
                int n3 = Integer.parseInt(resultSet.getString("PRECISION"));
                if (n2 != -1 || n3 <= n) continue;
                n = n3;
                string = resultSet.getString("TYPE_NAME");
            }
        }
        catch (SQLException sQLException) {}
        return string;
    }

    protected void setDBConnection(String string, String string2, String string3, String string4) throws SQLException {
        super.setDBConnection(string, string2, string3, string4);
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        String string5 = databaseMetaData.getDatabaseProductName();
        if (string5.toLowerCase().indexOf("sql server") != -1 && string2.toLowerCase().indexOf("selectmethod") == -1) {
            if (!string2.endsWith(";")) {
                string2 = string2 + ";";
            }
            string2 = string2 + "SelectMethod=cursor";
            this.conn.close();
            super.setDBConnection(string, string2, string3, string4);
        }
    }

    protected void initPrepStmts() {
        block2: {
            try {
                this.stm_selNrOfDescrForAID = this.conn.prepareStatement("SELECT COUNT(*) FROM dfagentdescr WHERE aid = ?");
                this.stm_selAgentAddresses = this.conn.prepareStatement("SELECT address FROM agentaddress WHERE aid = ?");
                this.stm_selAgentResolverAIDs = this.conn.prepareStatement("SELECT resolveraid FROM agentresolver WHERE aid = ?");
                this.stm_selAgentUserDefSlot = this.conn.prepareStatement("SELECT slotkey, slotval FROM agentuserdefslot WHERE aid = ?");
                this.stm_selLease = this.conn.prepareStatement("SELECT id, lease FROM dfagentdescr WHERE aid = ?");
                this.stm_selProtocols = this.conn.prepareStatement("SELECT protocol FROM protocol WHERE descrid = ?");
                this.stm_selLanguages = this.conn.prepareStatement("SELECT language FROM language WHERE descrid = ?");
                this.stm_selOntologies = this.conn.prepareStatement("SELECT ontology FROM ontology WHERE descrid = ?");
                this.stm_selServices = this.conn.prepareStatement("SELECT id, sname, stype, sownership FROM service WHERE descrid = ?");
                this.stm_selServiceProtocols = this.conn.prepareStatement("SELECT protocol FROM serviceprotocol WHERE serviceid = ?");
                this.stm_selServiceLanguages = this.conn.prepareStatement("SELECT ontology FROM serviceontology WHERE serviceid = ?");
                this.stm_selServiceOntologies = this.conn.prepareStatement("SELECT language FROM servicelanguage WHERE serviceid = ?");
                this.stm_selServiceProperties = this.conn.prepareStatement("SELECT propkey, propval FROM serviceproperty WHERE serviceid = ?");
                this.stm_selDescrId = this.conn.prepareStatement("SELECT id FROM dfagentdescr WHERE aid = ?");
                this.stm_selServiceId = this.conn.prepareStatement("SELECT id FROM service WHERE descrid = ?");
                this.stm_selExpiredDescr = this.conn.prepareStatement("SELECT aid FROM dfagentdescr WHERE lease < ? AND lease <> '-1'");
                this.stm_selSubscriptions = this.conn.prepareStatement("SELECT * FROM subscription");
                this.stm_insAgentDescr = this.conn.prepareStatement("INSERT INTO dfagentdescr VALUES (?, ?, ?)");
                this.stm_insAgentAddress = this.conn.prepareStatement("INSERT INTO agentaddress VALUES (?, ?, ?)");
                this.stm_insAgentUserDefSlot = this.conn.prepareStatement("INSERT INTO agentuserdefslot VALUES (?, ?, ?, ?)");
                this.stm_insAgentResolverAID = this.conn.prepareStatement("INSERT INTO agentresolver VALUES (?, ?, ?)");
                this.stm_insLanguage = this.conn.prepareStatement("INSERT INTO language VALUES (?, ?)");
                this.stm_insOntology = this.conn.prepareStatement("INSERT INTO ontology VALUES (?, ?)");
                this.stm_insProtocol = this.conn.prepareStatement("INSERT INTO protocol VALUES (?, ?)");
                this.stm_insService = this.conn.prepareStatement("INSERT INTO service VALUES (?, ?, ?, ?, ?)");
                this.stm_insServiceProtocol = this.conn.prepareStatement("INSERT INTO serviceprotocol VALUES (?, ?)");
                this.stm_insServiceOntology = this.conn.prepareStatement("INSERT INTO serviceontology VALUES (?, ?)");
                this.stm_insServiceLanguage = this.conn.prepareStatement("INSERT INTO servicelanguage VALUES (?, ?)");
                this.stm_insServiceProperty = this.conn.prepareStatement("INSERT INTO serviceproperty VALUES (?, ?, ?, ?)");
                this.stm_insSubscription = this.conn.prepareStatement("INSERT INTO subscription VALUES (?, ?)");
                this.stm_delAgentDescr = this.conn.prepareStatement("DELETE FROM dfagentdescr WHERE id = ?");
                this.stm_delAgentUserDefSlot = this.conn.prepareStatement("DELETE FROM agentuserdefslot WHERE aid = ?");
                this.stm_delAgentResolver = this.conn.prepareStatement("DELETE FROM agentresolver WHERE aid = ?");
                this.stm_delAgentAddress = this.conn.prepareStatement("DELETE FROM agentaddress WHERE aid = ?");
                this.stm_delLanguage = this.conn.prepareStatement("DELETE FROM language WHERE descrid = ?");
                this.stm_delProtocol = this.conn.prepareStatement("DELETE FROM protocol WHERE descrid = ?");
                this.stm_delOntology = this.conn.prepareStatement("DELETE FROM ontology WHERE descrid = ?");
                this.stm_delService = this.conn.prepareStatement("DELETE FROM service WHERE descrid = ?");
                this.stm_delServiceLanguage = this.conn.prepareStatement("DELETE FROM servicelanguage WHERE serviceid = ?");
                this.stm_delServiceOntology = this.conn.prepareStatement("DELETE FROM serviceontology WHERE serviceid = ?");
                this.stm_delServiceProtocol = this.conn.prepareStatement("DELETE FROM serviceprotocol WHERE serviceid = ?");
                this.stm_delServiceProperty = this.conn.prepareStatement("DELETE FROM serviceproperty WHERE serviceid = ?");
                this.stm_delSubscription = this.conn.prepareStatement("DELETE FROM subscription WHERE id = ?");
            }
            catch (SQLException sQLException) {
                if (!this.logger.isLoggable(Logger.SEVERE)) break block2;
                this.logger.log(Logger.SEVERE, "Error preparing SQL statements for DF", sQLException);
            }
        }
    }

    protected String getGUID() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string = "localhost";
        }
        UID uID = new UID();
        return string + ":" + uID;
    }

    protected void dropTable(Statement statement, String string) {
        try {
            statement.execute("DROP TABLE " + string);
            this.conn.commit();
        }
        catch (SQLException sQLException) {}
    }

    protected void dropDFTables() throws SQLException {
        if (this.logger.isLoggable(Logger.INFO)) {
            this.logger.log(Logger.INFO, "Cleaning tables for DF");
        }
        Statement statement = this.conn.createStatement();
        this.dropTable(statement, "subscription");
        this.dropTable(statement, "serviceprotocol");
        this.dropTable(statement, "serviceontology");
        this.dropTable(statement, "servicelanguage");
        this.dropTable(statement, "serviceproperty");
        this.dropTable(statement, "service");
        this.dropTable(statement, "language");
        this.dropTable(statement, "ontology");
        this.dropTable(statement, "protocol");
        this.dropTable(statement, "agentuserdefslot");
        this.dropTable(statement, "agentresolver");
        this.dropTable(statement, "agentaddress");
        this.dropTable(statement, "dfagentdescr");
        statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean tableExists(String string) {
        boolean bl;
        Statement statement = null;
        try {
            try {
                statement = this.conn.createStatement();
                statement.execute("SELECT COUNT(*) FROM " + string);
                bl = true;
                Object var6_5 = null;
                if (statement == null) return bl;
            }
            catch (SQLException sQLException) {
                boolean bl2 = false;
                Object var6_6 = null;
                if (statement == null) return bl2;
                try {
                    statement.close();
                    return bl2;
                }
                catch (SQLException sQLException3) {
                    sQLException3.printStackTrace();
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (statement == null) throw throwable;
            try {}
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
                throw throwable;
            }
            statement.close();
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return bl;
        }
        statement.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createTable(String string, String[] stringArray) {
        if (this.tableExists(string)) return;
        Statement statement = null;
        statement = this.conn.createStatement();
        String string2 = "CREATE TABLE " + string + " (";
        int n = 0;
        while (n < stringArray.length) {
            string2 = string2 + stringArray[n];
            string2 = n < stringArray.length - 1 ? string2 + ", " : string2 + ")";
            ++n;
        }
        statement.executeUpdate(string2);
        this.conn.commit();
        Object var7_7 = null;
        if (statement == null) return;
        try {
            statement.close();
            return;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return;
        {
            catch (SQLException sQLException) {
                if (this.logger.isLoggable(Logger.SEVERE)) {
                    this.logger.log(Logger.SEVERE, "Error creating table '" + string + "'", sQLException);
                }
                Object var7_8 = null;
                if (statement == null) return;
                try {
                    statement.close();
                    return;
                }
                catch (SQLException sQLException2) {
                    sQLException2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createIndices() {
        Statement statement = null;
        statement = this.conn.createStatement();
        statement.execute("CREATE INDEX dfagentDescrIdx ON dfagentdescr( aid )");
        statement.execute("CREATE INDEX leaseIdx ON dfagentdescr( lease )");
        statement.execute("CREATE INDEX agentAddressIdx ON agentaddress( aid )");
        statement.execute("CREATE INDEX agentResolverIdx ON agentresolver( aid )");
        statement.execute("CREATE INDEX agentUserdefslotIdx ON agentuserdefslot( aid )");
        statement.execute("CREATE INDEX serviceLanguageIdx ON servicelanguage( serviceid )");
        statement.execute("CREATE INDEX serviceProtocolIdx ON serviceprotocol( serviceid )");
        statement.execute("CREATE INDEX serviceOntologyIdx ON serviceontology( serviceid )");
        statement.execute("CREATE INDEX servicePropertyIdx ON serviceproperty( serviceid )");
        statement.execute("CREATE INDEX ontologyIdx ON ontology( descrid )");
        statement.execute("CREATE INDEX protocolIdx ON ontology( descrid )");
        statement.execute("CREATE INDEX languageIdx ON ontology( descrid )");
        this.conn.commit();
        Object var4_2 = null;
        if (statement == null) return;
        try {
            statement.close();
            return;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return;
        {
            catch (SQLException sQLException) {
                if (this.logger.isLoggable(Logger.FINE)) {
                    this.logger.log(Logger.FINE, "Indices for DF tables couldn't be created", sQLException);
                }
                Object var4_3 = null;
                if (statement == null) return;
                try {
                    statement.close();
                    return;
                }
                catch (SQLException sQLException2) {
                    sQLException2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            throw throwable;
        }
    }

    protected void createDFTables() {
        Object var1_1 = null;
        String string = this.getLongVarCharType();
        this.createTable("dfagentdescr", new String[]{"id VARCHAR(255)", "aid VARCHAR(255)", "lease VARCHAR(20)", "PRIMARY KEY( id )"});
        this.createTable("agentaddress", new String[]{"id VARCHAR(255)", "aid VARCHAR(255)", "address VARCHAR(255)", "PRIMARY KEY( id )"});
        this.createTable("agentresolver", new String[]{"id VARCHAR(255)", "aid VARCHAR(255)", "resolveraid VARCHAR(255)", "PRIMARY KEY( id )"});
        this.createTable("agentuserdefslot", new String[]{"id VARCHAR(255)", "aid\tVARCHAR(255)", "slotkey\tVARCHAR(255)", "slotval\t" + string, "PRIMARY KEY( id )"});
        this.createTable("ontology", new String[]{"descrid VARCHAR(255)", "ontology VARCHAR(32)", "PRIMARY KEY( descrid, ontology )", "FOREIGN KEY( descrid ) REFERENCES dfagentdescr( id )"});
        this.createTable("protocol", new String[]{"descrid VARCHAR(255)", "protocol VARCHAR(32)", "PRIMARY KEY( descrid, protocol )", "FOREIGN KEY( descrid ) REFERENCES dfagentdescr( id )"});
        this.createTable("language", new String[]{"descrid VARCHAR(255)", "language VARCHAR(32)", "PRIMARY KEY( descrid, language )", "FOREIGN KEY( descrid ) REFERENCES dfagentdescr( id )"});
        this.createTable("service", new String[]{"id VARCHAR(255)", "descrid VARCHAR(255)", "sname VARCHAR(255)", "stype VARCHAR(64)", "sownership VARCHAR(64)", "PRIMARY KEY( id )", "FOREIGN KEY( descrid ) REFERENCES dfagentdescr( id )"});
        this.createTable("serviceprotocol", new String[]{"serviceid VARCHAR(255)", "protocol VARCHAR(32)", "PRIMARY KEY( serviceid, protocol )", "FOREIGN KEY( serviceid ) REFERENCES service( id )"});
        this.createTable("serviceontology", new String[]{"serviceid VARCHAR(255)", "ontology VARCHAR(32)", "PRIMARY KEY( serviceid, ontology )", "FOREIGN KEY( serviceid ) REFERENCES service( id )"});
        this.createTable("servicelanguage", new String[]{"serviceid VARCHAR(255)", "language VARCHAR(32)", "PRIMARY KEY( serviceid, language )", "FOREIGN KEY( serviceid ) REFERENCES service( id )"});
        this.createTable("serviceproperty", new String[]{"serviceid VARCHAR(255)", "propkey VARCHAR(245)", "propval " + string, "propvalhash VARCHAR(100)", "PRIMARY KEY( serviceid, propkey )", "FOREIGN KEY( serviceid ) REFERENCES service( id )"});
        this.createTable("subscription", new String[]{"id\t VARCHAR(255)", "aclm " + string, "PRIMARY KEY( id )"});
        this.createIndices();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Tables correctly created");
        }
    }

    private String getBatchUpdateErroMsg(BatchUpdateException batchUpdateException) {
        StringBuffer stringBuffer = new StringBuffer("SQLException: " + batchUpdateException.getMessage() + "\n");
        stringBuffer.append("SQLState:  " + batchUpdateException.getSQLState() + "\n");
        stringBuffer.append("Message:  " + batchUpdateException.getMessage() + "\n");
        stringBuffer.append("Vendor:  " + batchUpdateException.getErrorCode() + "\n");
        stringBuffer.append("Update counts: ");
        int[] nArray = batchUpdateException.getUpdateCounts();
        int n = 0;
        while (n < nArray.length) {
            stringBuffer.append(nArray[n] + "   ");
            ++n;
        }
        return stringBuffer.toString();
    }

    private void saveResolverAID(AID aID, AID aID2) throws SQLException {
        this.saveAID(aID2);
        this.stm_insAgentResolverAID.setString(1, this.getGUID());
        this.stm_insAgentResolverAID.setString(2, aID.getName());
        this.stm_insAgentResolverAID.setString(3, aID2.getName());
        this.stm_insAgentResolverAID.addBatch();
    }

    private void saveAID(AID aID) throws SQLException {
        Object object;
        String string = aID.getName();
        Iterator iterator = aID.getAllAddresses();
        while (iterator.hasNext()) {
            this.stm_insAgentAddress.setString(1, this.getGUID());
            this.stm_insAgentAddress.setString(2, string);
            this.stm_insAgentAddress.setString(3, (String)iterator.next());
            this.stm_insAgentAddress.addBatch();
        }
        this.stm_insAgentAddress.executeBatch();
        Properties properties = aID.getAllUserDefinedSlot();
        if (properties.size() > 0) {
            this.stm_insAgentUserDefSlot.clearBatch();
            object = properties.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry<Object, Object> entry = object.next();
                this.stm_insAgentUserDefSlot.setString(1, this.getGUID());
                this.stm_insAgentUserDefSlot.setString(2, string);
                this.stm_insAgentUserDefSlot.setString(3, (String)entry.getKey());
                this.stm_insAgentUserDefSlot.setString(4, (String)entry.getValue());
                this.stm_insAgentUserDefSlot.addBatch();
            }
            this.stm_insAgentUserDefSlot.executeBatch();
        }
        if ((iterator = aID.getAllResolvers()).hasNext()) {
            this.stm_insAgentResolverAID.clearBatch();
            while (iterator.hasNext()) {
                object = (AID)iterator.next();
                this.saveResolverAID(aID, (AID)object);
            }
            this.stm_insAgentResolverAID.executeBatch();
        }
    }

    private Collection getResolverAIDs(String string) throws SQLException {
        ArrayList arrayList = new ArrayList();
        this.stm_selAgentResolverAIDs.setString(1, string);
        ResultSet resultSet = this.stm_selAgentResolverAIDs.executeQuery();
        while (resultSet.next()) {
            arrayList.add(resultSet.getString(1));
        }
        return arrayList;
    }

    private void saveServices(String string, Iterator iterator) throws SQLException {
        if (iterator.hasNext()) {
            this.stm_insService.clearBatch();
            this.stm_insServiceOntology.clearBatch();
            this.stm_insServiceOntology.clearBatch();
            this.stm_insServiceLanguage.clearBatch();
            this.stm_insServiceProperty.clearBatch();
            while (iterator.hasNext()) {
                ServiceDescription serviceDescription = (ServiceDescription)iterator.next();
                String string2 = this.getGUID();
                this.stm_insService.clearParameters();
                this.stm_insService.setString(1, string2);
                this.stm_insService.setString(2, string);
                this.stm_insService.setString(3, serviceDescription.getName());
                this.stm_insService.setString(4, serviceDescription.getType());
                this.stm_insService.setString(5, serviceDescription.getOwnership());
                this.stm_insService.addBatch();
                Iterator iterator2 = serviceDescription.getAllProtocols();
                while (iterator2.hasNext()) {
                    this.stm_insServiceProtocol.setString(1, string2);
                    this.stm_insServiceProtocol.setString(2, (String)iterator2.next());
                    this.stm_insServiceProtocol.addBatch();
                }
                iterator2 = serviceDescription.getAllOntologies();
                while (iterator2.hasNext()) {
                    this.stm_insServiceOntology.setString(1, string2);
                    this.stm_insServiceOntology.setString(2, (String)iterator2.next());
                    this.stm_insServiceOntology.addBatch();
                }
                iterator2 = serviceDescription.getAllLanguages();
                while (iterator2.hasNext()) {
                    this.stm_insServiceLanguage.setString(1, string2);
                    this.stm_insServiceLanguage.setString(2, (String)iterator2.next());
                    this.stm_insServiceLanguage.addBatch();
                }
                iterator2 = serviceDescription.getAllProperties();
                while (iterator2.hasNext()) {
                    Property property = (Property)iterator2.next();
                    try {
                        this.stm_insServiceProperty.setString(1, string2);
                        this.stm_insServiceProperty.setString(2, property.getName());
                        Object object = property.getValue();
                        String string3 = this.getHashValue(object);
                        String string4 = this.serializeObj(object);
                        this.stm_insServiceProperty.setString(3, string4);
                        this.stm_insServiceProperty.setString(4, string3);
                        this.stm_insServiceProperty.addBatch();
                    }
                    catch (Exception exception) {
                        if (!this.logger.isLoggable(Logger.SEVERE)) continue;
                        this.logger.log(Logger.SEVERE, "Cannot serialize property '" + property.getName() + "' for service '" + serviceDescription.getName() + "'", exception);
                    }
                }
            }
            this.stm_insService.executeBatch();
            this.stm_insServiceProtocol.executeBatch();
            this.stm_insServiceOntology.executeBatch();
            this.stm_insServiceLanguage.executeBatch();
            this.stm_insServiceProperty.executeBatch();
        }
    }

    public Object insert(Object object, Object object2) {
        DFAgentDescription dFAgentDescription;
        block13: {
            DFAgentDescription dFAgentDescription2 = (DFAgentDescription)object2;
            AID aID = dFAgentDescription2.getName();
            String string = aID.getName();
            dFAgentDescription = null;
            String string2 = "";
            try {
                dFAgentDescription = (DFAgentDescription)this.remove(dFAgentDescription2.getName());
                Date date = dFAgentDescription2.getLeaseTime();
                long l = date != null ? date.getTime() : -1L;
                String string3 = this.getGUID();
                this.stm_insAgentDescr.setString(1, string3);
                this.stm_insAgentDescr.setString(2, string);
                this.stm_insAgentDescr.setString(3, String.valueOf(l));
                this.stm_insAgentDescr.executeUpdate();
                this.saveAID(aID);
                Iterator iterator = dFAgentDescription2.getAllLanguages();
                if (iterator.hasNext()) {
                    this.stm_insLanguage.clearBatch();
                    while (iterator.hasNext()) {
                        this.stm_insLanguage.setString(1, string3);
                        this.stm_insLanguage.setString(2, (String)iterator.next());
                        this.stm_insLanguage.addBatch();
                    }
                    this.stm_insLanguage.executeBatch();
                }
                if ((iterator = dFAgentDescription2.getAllOntologies()).hasNext()) {
                    this.stm_insOntology.clearBatch();
                    while (iterator.hasNext()) {
                        this.stm_insOntology.setString(1, string3);
                        this.stm_insOntology.setString(2, (String)iterator.next());
                        this.stm_insOntology.addBatch();
                    }
                    this.stm_insOntology.executeBatch();
                }
                if ((iterator = dFAgentDescription2.getAllProtocols()).hasNext()) {
                    this.stm_insProtocol.clearBatch();
                    while (iterator.hasNext()) {
                        this.stm_insProtocol.setString(1, string3);
                        this.stm_insProtocol.setString(2, (String)iterator.next());
                        this.stm_insProtocol.addBatch();
                        this.stm_insService.executeBatch();
                    }
                    this.stm_insProtocol.executeBatch();
                }
                this.saveServices(string3, dFAgentDescription2.getAllServices());
                ++this.regsCnt;
                if (this.regsCnt > 100) {
                    this.clean();
                    this.regsCnt = 0;
                }
                this.conn.commit();
            }
            catch (BatchUpdateException batchUpdateException) {
                string2 = "\n" + this.getBatchUpdateErroMsg(batchUpdateException);
            }
            catch (Exception exception) {
                if (this.logger.isLoggable(Logger.SEVERE)) {
                    this.logger.log(Logger.SEVERE, "Error inserting DFD for agent " + dFAgentDescription2.getName() + string2, exception);
                }
                try {
                    this.conn.rollback();
                }
                catch (SQLException sQLException) {
                    if (!this.logger.isLoggable(Logger.SEVERE)) break block13;
                    this.logger.log(Logger.SEVERE, "Rollback for incomplete insertion of DFD for agent " + dFAgentDescription2.getName() + " failed.");
                }
            }
        }
        return dFAgentDescription;
    }

    protected Object remove(Object object) {
        AID aID = (AID)object;
        String string = aID.getName();
        DFAgentDescription dFAgentDescription = this.getDFD(string);
        if (dFAgentDescription != null) {
            this.remove(string);
        }
        return dFAgentDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List search(Object object, int n) {
        Object object2;
        Statement statement;
        ResultSet resultSet;
        String string;
        ArrayList arrayList;
        String string2;
        block9: {
            string2 = "Error searching for DFDs matching template.";
            arrayList = new ArrayList();
            string = null;
            resultSet = null;
            statement = null;
            try {
                string = this.createSelect((DFAgentDescription)object);
            }
            catch (Exception exception) {
                if (!this.logger.isLoggable(Logger.SEVERE)) break block9;
                this.logger.log(Logger.SEVERE, string2 + " Couldn't create the SQL SELECT statement.", exception);
            }
        }
        try {
            Object var10_11;
            try {
                statement = this.conn.createStatement();
                statement.setMaxRows(n);
                statement.setFetchSize(n);
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    object2 = resultSet.getString("aid");
                    arrayList.add(object2);
                }
            }
            catch (SQLException sQLException) {
                if (this.logger.isLoggable(Logger.SEVERE)) {
                    this.logger.log(Logger.SEVERE, string2 + " DB operation: " + string, sQLException);
                }
                var10_11 = null;
                this.closeResultSet(resultSet);
                this.closeStatement(statement);
            }
            var10_11 = null;
            this.closeResultSet(resultSet);
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.closeResultSet(resultSet);
            this.closeStatement(statement);
            throw throwable;
        }
        object2 = new ArrayList(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object2.add(this.getDFD((String)iterator.next()));
        }
        return object2;
    }

    private AID getAID(String string) throws SQLException {
        ResultSet resultSet = null;
        AID aID = new AID(string, true);
        this.stm_selAgentAddresses.setString(1, string);
        resultSet = this.stm_selAgentAddresses.executeQuery();
        while (resultSet.next()) {
            aID.addAddresses(resultSet.getString(1));
        }
        Collection collection = this.getResolverAIDs(string);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            aID.addResolvers(this.getAID((String)iterator.next()));
        }
        this.stm_selAgentUserDefSlot.setString(1, string);
        resultSet = this.stm_selAgentUserDefSlot.executeQuery();
        while (resultSet.next()) {
            String string2 = resultSet.getString("slotkey");
            String string3 = resultSet.getString("slotval");
            aID.addUserDefinedSlot(string2, string3);
        }
        return aID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DFAgentDescription getDFD(String string) {
        Object object;
        String string2;
        ResultSet resultSet;
        ResultSet resultSet2;
        DFAgentDescription dFAgentDescription;
        block16: {
            dFAgentDescription = null;
            AID aID = null;
            resultSet2 = null;
            resultSet = null;
            string2 = null;
            this.stm_selLease.setString(1, string);
            resultSet2 = this.stm_selLease.executeQuery();
            if (resultSet2.next()) {
                dFAgentDescription = new DFAgentDescription();
                aID = this.getAID(string);
                dFAgentDescription.setName(aID);
                object = resultSet2.getString("lease");
                string2 = resultSet2.getString("id");
                long l = Long.parseLong((String)object);
                if (l != -1L) {
                    dFAgentDescription.setLeaseTime(new Date(l));
                }
                break block16;
            }
            DFAgentDescription dFAgentDescription2 = null;
            Object var12_12 = null;
            this.closeResultSet(resultSet2);
            this.closeResultSet(resultSet);
            return dFAgentDescription2;
        }
        try {
            try {
                this.closeResultSet(resultSet2);
                this.stm_selProtocols.setString(1, string2);
                resultSet2 = this.stm_selProtocols.executeQuery();
                while (resultSet2.next()) {
                    dFAgentDescription.addProtocols(resultSet2.getString("protocol"));
                }
                this.closeResultSet(resultSet2);
                this.stm_selLanguages.setString(1, string2);
                resultSet2 = this.stm_selLanguages.executeQuery();
                while (resultSet2.next()) {
                    dFAgentDescription.addLanguages(resultSet2.getString("language"));
                }
                this.closeResultSet(resultSet2);
                this.stm_selOntologies.setString(1, string2);
                resultSet2 = this.stm_selOntologies.executeQuery();
                while (resultSet2.next()) {
                    dFAgentDescription.addOntologies(resultSet2.getString("ontology"));
                }
                this.closeResultSet(resultSet2);
                this.stm_selServices.setString(1, string2);
                resultSet2 = this.stm_selServices.executeQuery();
                while (resultSet2.next()) {
                    object = new ServiceDescription();
                    String string3 = resultSet2.getString("id");
                    ((ServiceDescription)object).setName(resultSet2.getString("sname"));
                    ((ServiceDescription)object).setType(resultSet2.getString("stype"));
                    ((ServiceDescription)object).setOwnership(resultSet2.getString("sownership"));
                    this.stm_selServiceProtocols.setString(1, string3);
                    resultSet = this.stm_selServiceProtocols.executeQuery();
                    while (resultSet.next()) {
                        ((ServiceDescription)object).addProtocols(resultSet.getString("protocol"));
                    }
                    this.closeResultSet(resultSet);
                    this.stm_selServiceLanguages.setString(1, string3);
                    resultSet = this.stm_selServiceLanguages.executeQuery();
                    while (resultSet.next()) {
                        ((ServiceDescription)object).addOntologies(resultSet.getString("ontology"));
                    }
                    this.closeResultSet(resultSet);
                    this.stm_selServiceOntologies.setString(1, string3);
                    resultSet = this.stm_selServiceOntologies.executeQuery();
                    while (resultSet.next()) {
                        ((ServiceDescription)object).addLanguages(resultSet.getString("language"));
                    }
                    this.closeResultSet(resultSet);
                    this.stm_selServiceProperties.setString(1, string3);
                    resultSet = this.stm_selServiceProperties.executeQuery();
                    while (resultSet.next()) {
                        Property property = new Property();
                        property.setName(resultSet.getString("propkey"));
                        Object object2 = this.deserializeObj(resultSet.getString("propval"));
                        property.setValue(object2);
                        ((ServiceDescription)object).addProperties(property);
                    }
                    dFAgentDescription.addServices((ServiceDescription)object);
                }
            }
            catch (Exception exception) {
                if (this.logger.isLoggable(Logger.WARNING)) {
                    this.logger.log(Logger.WARNING, "Error reconstructing DFD for agent " + string, exception);
                }
                Object var12_14 = null;
                this.closeResultSet(resultSet2);
                this.closeResultSet(resultSet);
            }
            Object var12_13 = null;
            this.closeResultSet(resultSet2);
            this.closeResultSet(resultSet);
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.closeResultSet(resultSet2);
            this.closeResultSet(resultSet);
            throw throwable;
        }
        return dFAgentDescription;
    }

    private void removeAID(String string) throws SQLException {
        this.stm_selNrOfDescrForAID.setString(1, string);
        ResultSet resultSet = this.stm_selNrOfDescrForAID.executeQuery();
        int n = 0;
        if (resultSet.next()) {
            n = Integer.parseInt(resultSet.getString(1));
        }
        if (n == 0) {
            this.stm_delAgentUserDefSlot.setString(1, string);
            this.stm_delAgentUserDefSlot.execute();
            Collection collection = this.getResolverAIDs(string);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.removeAID((String)iterator.next());
            }
            this.stm_delAgentResolver.setString(1, string);
            this.stm_delAgentResolver.execute();
            this.stm_delAgentAddress.setString(1, string);
            this.stm_delAgentAddress.execute();
        }
    }

    private void removeServices(String string) throws SQLException {
        ResultSet resultSet = null;
        this.stm_selServiceId.setString(1, string);
        resultSet = this.stm_selServiceId.executeQuery();
        while (resultSet.next()) {
            String string2 = resultSet.getString("id");
            this.stm_delServiceLanguage.setString(1, string2);
            this.stm_delServiceLanguage.addBatch();
            this.stm_delServiceOntology.setString(1, string2);
            this.stm_delServiceOntology.addBatch();
            this.stm_delServiceProtocol.setString(1, string2);
            this.stm_delServiceProtocol.addBatch();
            this.stm_delServiceProperty.setString(1, string2);
            this.stm_delServiceProperty.addBatch();
            this.stm_delService.setString(1, string);
            this.stm_delService.addBatch();
        }
        resultSet.close();
        this.stm_delServiceLanguage.executeBatch();
        this.stm_delServiceOntology.executeBatch();
        this.stm_delServiceProtocol.executeBatch();
        this.stm_delServiceProperty.executeBatch();
        this.stm_delService.executeBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(String string) {
        ResultSet resultSet = null;
        try {
            block6: {
                try {
                    this.stm_selDescrId.setString(1, string);
                    resultSet = this.stm_selDescrId.executeQuery();
                    if (resultSet.next()) {
                        String string2 = resultSet.getString("id");
                        this.closeResultSet(resultSet);
                        this.stm_delOntology.setString(1, string2);
                        this.stm_delOntology.execute();
                        this.stm_delProtocol.setString(1, string2);
                        this.stm_delProtocol.execute();
                        this.stm_delLanguage.setString(1, string2);
                        this.stm_delLanguage.execute();
                        this.removeServices(string2);
                        this.stm_delAgentDescr.setString(1, string2);
                        this.stm_delAgentDescr.execute();
                        this.removeAID(string);
                        this.conn.commit();
                        break block6;
                    }
                    if (!this.logger.isLoggable(Logger.FINE)) break block6;
                    this.logger.log(Logger.FINE, "No DF description found to remove for agent '" + string + "'");
                }
                catch (SQLException sQLException) {
                    if (this.logger.isLoggable(Logger.WARNING)) {
                        this.logger.log(Logger.WARNING, "Error removing DFD for agent " + string, sQLException);
                    }
                    Object var5_6 = null;
                    this.closeResultSet(resultSet);
                }
            }
            Object var5_5 = null;
            this.closeResultSet(resultSet);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeResultSet(resultSet);
            throw throwable;
        }
    }

    private String createSelect(DFAgentDescription dFAgentDescription) throws Exception {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("SELECT dfagentdescr.aid, dfagentdescr.lease FROM dfagentdescr");
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        AID aID = dFAgentDescription.getName();
        if (aID != null) {
            arrayList2.add(" dfagentdescr.aid = '" + aID.getName() + "'");
        }
        Date date = dFAgentDescription.getLeaseTime();
        long l = System.currentTimeMillis();
        arrayList2.add(" (dfagentdescr.lease = '-1' OR dfagentdescr.lease > '" + l + "')");
        Iterator iterator = dFAgentDescription.getAllLanguages();
        int n = 0;
        while (iterator.hasNext()) {
            object = "language" + n;
            arrayList.add(", language AS " + (String)object);
            arrayList2.add((String)object + ".language='" + (String)iterator.next() + "'");
            arrayList2.add((String)object + ".descrid=dfagentdescr.id");
            ++n;
        }
        iterator = dFAgentDescription.getAllOntologies();
        n = 0;
        while (iterator.hasNext()) {
            object = "ontology" + n;
            arrayList.add(", ontology AS " + (String)object);
            arrayList2.add((String)object + ".ontology='" + (String)iterator.next() + "'");
            arrayList2.add((String)object + ".descrid=dfagentdescr.id");
            ++n;
        }
        iterator = dFAgentDescription.getAllProtocols();
        n = 0;
        while (iterator.hasNext()) {
            object = "protocol" + n;
            arrayList.add(", protocol AS " + (String)object);
            arrayList2.add((String)object + ".protocol='" + (String)iterator.next() + "'");
            arrayList2.add((String)object + ".descrid=dfagentdescr.id");
            ++n;
        }
        iterator = dFAgentDescription.getAllServices();
        n = 0;
        while (iterator.hasNext()) {
            String string;
            object = (ServiceDescription)iterator.next();
            String string2 = ((ServiceDescription)object).getName();
            String string3 = ((ServiceDescription)object).getType();
            String string4 = ((ServiceDescription)object).getOwnership();
            String string5 = "service" + n;
            arrayList.add(", service AS " + string5);
            if (string2 != null) {
                arrayList2.add(string5 + ".sname='" + string2 + "'");
            }
            if (string3 != null) {
                arrayList2.add(string5 + ".stype='" + string3 + "'");
            }
            if (string4 != null) {
                arrayList2.add(string5 + ".sownership='" + string4 + "'");
            }
            arrayList2.add(string5 + ".descrid=dfagentdescr.id");
            ++n;
            Iterator iterator2 = ((ServiceDescription)object).getAllLanguages();
            int n2 = 0;
            while (iterator2.hasNext()) {
                string = "servicelanguage" + n2;
                arrayList.add(", servicelanguage AS " + string);
                arrayList2.add(string + ".language='" + (String)iterator2.next() + "'");
                arrayList2.add(string + ".serviceid=" + string5 + ".id");
                ++n2;
            }
            iterator2 = ((ServiceDescription)object).getAllOntologies();
            n2 = 0;
            while (iterator2.hasNext()) {
                string = "serviceontology" + n2;
                arrayList.add(", serviceontology AS " + string);
                arrayList2.add(string + ".ontology='" + (String)iterator2.next() + "'");
                arrayList2.add(string + ".serviceid=" + string5 + ".id");
                ++n2;
            }
            iterator2 = ((ServiceDescription)object).getAllProtocols();
            n2 = 0;
            while (iterator2.hasNext()) {
                string = "serviceprotocol" + n2;
                arrayList.add(", serviceprotocol AS " + string);
                arrayList2.add(string + ".protocol='" + (String)iterator2.next() + "'");
                arrayList2.add(string + ".serviceid=" + string5 + ".id");
                ++n2;
            }
            iterator2 = ((ServiceDescription)object).getAllProperties();
            n2 = 0;
            while (iterator2.hasNext()) {
                string = "serviceproperty" + n2;
                arrayList.add(", serviceproperty AS " + string);
                Property property = (Property)iterator2.next();
                if (property.getName() != null) {
                    arrayList2.add(string + ".propkey='" + property.getName() + "'");
                }
                if (property.getValue() != null) {
                    String string6 = this.getHashValue(property.getValue());
                    arrayList2.add(string + ".propvalhash='" + string6 + "'");
                }
                arrayList2.add(string + ".serviceid=" + string5 + ".id");
                ++n2;
            }
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
        }
        if (arrayList2.size() > 0) {
            stringBuffer.append(" WHERE ");
        }
        iterator = arrayList2.iterator();
        n = 0;
        while (iterator.hasNext()) {
            if (n > 0) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append((String)iterator.next());
            ++n;
        }
        return stringBuffer.toString();
    }

    private void clean() {
        this.cleanExpiredRegistrations();
        this.cleanExpiredSubscriptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanExpiredRegistrations() {
        ResultSet resultSet = null;
        long l = System.currentTimeMillis();
        try {
            try {
                ArrayList arrayList = new ArrayList();
                this.stm_selExpiredDescr.setString(1, String.valueOf(l));
                resultSet = this.stm_selExpiredDescr.executeQuery();
                while (resultSet.next()) {
                    this.remove(resultSet.getString("aid"));
                }
            }
            catch (SQLException sQLException) {
                if (this.logger.isLoggable(Logger.WARNING)) {
                    this.logger.log(Logger.WARNING, "Error cleaning expired DF registrations", sQLException);
                }
                Object var6_6 = null;
                this.closeResultSet(resultSet);
            }
            Object var6_5 = null;
            this.closeResultSet(resultSet);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeResultSet(resultSet);
            throw throwable;
        }
    }

    private void cleanExpiredSubscriptions() {
    }

    public void subscribe(Object object, SubscriptionResponder.Subscription subscription) throws NotUnderstoodException {
        ACLMessage aCLMessage = subscription.getMessage();
        String string = aCLMessage.toString();
        String string2 = aCLMessage.getConversationId();
        this.registerSubscription(string2, string);
    }

    private void registerSubscription(String string, String string2) {
        block2: {
            try {
                String string3 = new String(Base64.encode(string2.getBytes()));
                this.stm_insSubscription.setString(1, string);
                this.stm_insSubscription.setString(2, string3);
                this.stm_insSubscription.execute();
            }
            catch (Exception exception) {
                if (!this.logger.isLoggable(Logger.SEVERE)) break block2;
                this.logger.log(Logger.SEVERE, "Error registering subscription", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getSubscriptions() {
        Vector<SubscriptionResponder.Subscription> vector = new Vector<SubscriptionResponder.Subscription>();
        StringACLCodec stringACLCodec = new StringACLCodec();
        ResultSet resultSet = null;
        try {
            try {
                resultSet = this.stm_selSubscriptions.executeQuery();
                while (resultSet.next()) {
                    String string = resultSet.getString("aclm");
                    String string2 = new String(Base64.decode(string.toCharArray()));
                    ACLMessage aCLMessage = stringACLCodec.decode(string2.getBytes(), "US-ASCII");
                    vector.add(this.sr.createSubscription(aCLMessage));
                }
            }
            catch (Exception exception) {
                if (this.logger.isLoggable(Logger.SEVERE)) {
                    this.logger.log(Logger.SEVERE, "Error retrieving subscriptions from the database", exception);
                }
                Object var8_9 = null;
                this.closeResultSet(resultSet);
            }
            Object var8_8 = null;
            this.closeResultSet(resultSet);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.closeResultSet(resultSet);
            throw throwable;
        }
        return vector.elements();
    }

    public void unsubscribe(SubscriptionResponder.Subscription subscription) {
        ACLMessage aCLMessage = subscription.getMessage();
        String string = aCLMessage.getConversationId();
        boolean bl = this.deregisterSubscription(string);
        if (!bl && this.logger.isLoggable(Logger.WARNING)) {
            this.logger.log(Logger.WARNING, "No subscription to delete.");
        }
    }

    public boolean deregisterSubscription(String string) {
        try {
            this.stm_delSubscription.setString(1, string);
            int n = this.stm_delSubscription.executeUpdate();
            return n != 0;
        }
        catch (SQLException sQLException) {
            if (this.logger.isLoggable(Logger.WARNING)) {
                this.logger.log(Logger.WARNING, "Cannot remove subscription with id '" + string + "' from database", sQLException);
            }
            return false;
        }
    }

    private void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
        }
        catch (SQLException sQLException) {}
    }

    private void closeStatement(Statement statement) {
        block3: {
            try {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
            catch (Exception exception) {
                if (!this.logger.isLoggable(Logger.WARNING)) break block3;
                this.logger.log(Logger.WARNING, "Closing SQL statement failed.");
            }
        }
    }

    private String serializeObj(Object object) throws IOException {
        if (object == null) {
            return "null";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return new String(Base64.encode(byArray));
    }

    private Object deserializeObj(String string) throws IOException, ClassNotFoundException {
        if (string == null) {
            return null;
        }
        byte[] byArray = Base64.decode(string.toCharArray());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    protected String getHashValue(Object object) throws Exception {
        if (object == null) {
            return "null";
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray2 = messageDigest.digest(byArray);
            return new String(Base64.encode(byArray2));
        }
        catch (Exception exception) {
            throw new Exception("Couldn't create MD5 hash for given object.", exception);
        }
    }

    protected String prepDBStr(String string) {
        if (string == null) {
            return "";
        }
        String string2 = this.replace(string, "'", "''");
        string2 = this.replace(string2, "\"", "\"\"");
        return string2;
    }

    protected String replace(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            stringBuffer.append(string.substring(n, n2));
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            n = n2 + string2.length();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }
}

