/*
 * Decompiled with CFR 0.152.
 */
package jade.core.mobility;

import jade.core.IMTPException;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.mobility.AgentMobilitySlice;
import jade.util.Logger;

class MobileAgentClassLoader
extends ClassLoader {
    private AgentMobilitySlice classServer;
    private String sliceName;
    private ServiceFinder finder;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    public MobileAgentClassLoader(String string, ServiceFinder serviceFinder, Logger logger) {
        super(Thread.currentThread().getContextClassLoader());
        try {
            this.sliceName = string;
            this.finder = serviceFinder;
            this.classServer = (AgentMobilitySlice)this.finder.findSlice("jade.core.mobility.AgentMobility", this.sliceName);
            this.myLogger = logger;
        }
        catch (IMTPException iMTPException) {
            iMTPException.printStackTrace();
        }
        catch (ServiceException serviceException) {
            serviceException.printStackTrace();
        }
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        byte[] byArray;
        try {
            if (this.myLogger != null && this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Remote retrieval of code for class " + string);
            }
            try {
                byArray = this.classServer.fetchClassFile(string);
            }
            catch (IMTPException iMTPException) {
                this.classServer = (AgentMobilitySlice)this.finder.findSlice("jade.core.mobility.AgentMobility", this.sliceName);
                byArray = this.classServer.fetchClassFile(string);
            }
        }
        catch (IMTPException iMTPException) {
            iMTPException.printStackTrace();
            throw new ClassNotFoundException(string);
        }
        catch (ServiceException serviceException) {
            throw new ClassNotFoundException(string);
        }
        if (byArray != null) {
            if (this.myLogger != null && this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Code of class " + string + " retrieved. Length is " + byArray.length);
            }
            return this.defineClass(string, byArray, 0, byArray.length);
        }
        throw new ClassNotFoundException(string);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (this.myLogger != null && this.myLogger.isLoggable(Logger.FINER)) {
            this.myLogger.log(Logger.FINER, "Loading class " + string);
        }
        Class<?> clazz = super.loadClass(string, bl);
        if (this.myLogger != null && this.myLogger.isLoggable(Logger.FINER)) {
            this.myLogger.log(Logger.FINER, "Class " + string + " loaded");
        }
        return clazz;
    }
}

