/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessageManager;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import jade.util.leap.Map;
import jade.util.leap.RoundList;

class OutBox {
    private int size = 0;
    private int maxSize;
    private boolean overMaxSize = false;
    private final Map messagesByReceiver = new HashMap();
    private final RoundList messagesByOrder = new RoundList();
    private Logger myLogger;

    OutBox(int n) {
        this.maxSize = n;
        this.myLogger = Logger.getMyLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLast(AID aID, GenericMessage genericMessage, MessageManager.Channel channel) {
        Object object;
        if (genericMessage.getPayload() != null && (object = genericMessage.getACLMessage()) != null) {
            ((ACLMessage)object).setContent(null);
        }
        this.increaseSize(genericMessage.length());
        object = this;
        synchronized (object) {
            Box box = (Box)this.messagesByReceiver.get(aID);
            if (box == null) {
                box = new Box(aID);
                this.messagesByReceiver.put(aID, box);
                this.messagesByOrder.add(box);
            }
            box.addLast(new MessageManager.PendingMsg(genericMessage, aID, channel, -1L));
            this.notifyAll();
        }
    }

    final synchronized MessageManager.PendingMsg get() {
        Box box = null;
        while ((box = this.getNextIdle()) == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        MessageManager.PendingMsg pendingMsg = box.removeFirst();
        this.decreaseSize(pendingMsg.getMessage().length());
        return pendingMsg;
    }

    private final Box getNextIdle() {
        int n = 0;
        while (n < this.messagesByOrder.size()) {
            Box box = (Box)this.messagesByOrder.get();
            if (!box.isBusy()) {
                box.setBusy(true);
                return box;
            }
            ++n;
        }
        return null;
    }

    final synchronized void handleServed(AID aID) {
        Box box = (Box)this.messagesByReceiver.get(aID);
        if (box.isEmpty()) {
            this.messagesByReceiver.remove(aID);
            this.messagesByOrder.remove(box);
        } else {
            box.setBusy(false);
        }
    }

    private void increaseSize(int n) {
        block3: {
            this.size += n;
            if (this.size <= this.maxSize) break block3;
            if (!this.overMaxSize) {
                this.myLogger.log(Logger.WARNING, "MessageManager queue size > " + this.maxSize);
                this.overMaxSize = true;
            }
            long l = (1 + (this.size - this.maxSize) / 1000000) * 100;
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void decreaseSize(int n) {
        this.size -= n;
        if (this.size < this.maxSize && this.overMaxSize) {
            this.myLogger.log(Logger.INFO, "MessageManager queue size < " + this.maxSize);
            this.overMaxSize = false;
        }
    }

    private class Box {
        private final AID receiver;
        private boolean busy;
        private final List messages;

        public Box(AID aID) {
            this.receiver = aID;
            this.busy = false;
            this.messages = new LinkedList();
        }

        private AID getReceiver() {
            return this.receiver;
        }

        private void setBusy(boolean bl) {
            this.busy = bl;
        }

        private boolean isBusy() {
            return this.busy;
        }

        private void addLast(MessageManager.PendingMsg pendingMsg) {
            this.messages.add(pendingMsg);
        }

        private MessageManager.PendingMsg removeFirst() {
            return (MessageManager.PendingMsg)this.messages.remove(0);
        }

        private boolean isEmpty() {
            return this.messages.isEmpty();
        }
    }
}

