/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.AgentContainer;
import jade.core.BaseService;
import jade.core.CaseInsensitiveString;
import jade.core.ContainerID;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.MainContainer;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.Sink;
import jade.core.Specifier;
import jade.core.VerticalCommand;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.IncomingEncodingFilter;
import jade.core.messaging.MessageManager;
import jade.core.messaging.MessagingSlice;
import jade.core.messaging.OutgoingEncodingFilter;
import jade.core.messaging.RoutingTable;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.domain.FIPAAgentManagement.ReceivedObject;
import jade.lang.acl.ACLCodec;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.LEAPACLCodec;
import jade.lang.acl.StringACLCodec;
import jade.mtp.InChannel;
import jade.mtp.MTP;
import jade.mtp.MTPDescriptor;
import jade.mtp.MTPException;
import jade.mtp.TransportAddress;
import jade.security.JADESecurityException;
import jade.util.HashCache;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Map;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;

public class MessagingService
extends BaseService
implements MessageManager.Channel {
    public static final String CACHE_SIZE = "jade_core_messaging_MessagingService_cachesize";
    public static final int CACHE_SIZE_DEFAULT = 100;
    public static final String ATTACH_PLATFORM_INFO = "jade_core_messaging_MessagingService_attachplatforminfo";
    public static final String PLATFORM_IDENTIFIER = "x-sender-platform-identifer";
    public static final String MTP_IDENTIFIER = "x-sender-mtp-identifer";
    private Profile myProfile;
    private boolean acceptForeignAgents = false;
    private String platformID;
    private AgentContainer myContainer;
    private Service persistentDeliveryService;
    private final ServiceComponent localSlice = new ServiceComponent();
    private final CommandSourceSink senderSink = new CommandSourceSink();
    private final CommandTargetSink receiverSink = new CommandTargetSink();
    private Filter encOutFilter;
    private Filter encInFilter;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());
    private Map cachedSlices;
    private RoutingTable routes;
    private static final int EXPECTED_ACLENCODINGS_SIZE = 3;
    private final Map messageEncodings = new HashMap(3);
    private String accID;
    private MessageManager myMessageManager;
    private static final String[] OWNED_COMMANDS = new String[]{"Send-Message", "Notify-Failure", "Install-MTP", "Uninstall-MTP", "New-MTP", "Dead-MTP", "Set-Platform-Addresses"};

    public void init(AgentContainer agentContainer, Profile profile) throws ProfileException {
        super.init(agentContainer, profile);
        this.myProfile = profile;
        this.myContainer = agentContainer;
        int n = 100;
        try {
            n = Integer.parseInt(this.myProfile.getParameter(CACHE_SIZE, null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cachedSlices = new HashCache(n);
        this.routes = new RoutingTable(this.myProfile.getBooleanProperty(ATTACH_PLATFORM_INFO, false));
        this.acceptForeignAgents = this.myProfile.getBooleanProperty("accept-foreign-agents", false);
        this.platformID = this.myContainer.getPlatformID();
        this.accID = "fipa-mts://" + this.platformID + "/acc";
        this.encOutFilter = new OutgoingEncodingFilter(this.messageEncodings, this.myContainer, this);
        this.encInFilter = new IncomingEncodingFilter(this.messageEncodings);
        this.myMessageManager = MessageManager.instance(profile);
    }

    public String getName() {
        return "jade.core.messaging.Messaging";
    }

    public Class getHorizontalInterface() {
        try {
            return Class.forName("jade.core.messaging.MessagingSlice");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    public Filter getCommandFilter(boolean bl) {
        if (bl) {
            return this.encOutFilter;
        }
        return this.encInFilter;
    }

    public Sink getCommandSink(boolean bl) {
        if (!bl) {
            return this.senderSink;
        }
        return this.receiverSink;
    }

    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    public void boot(Profile profile) throws ServiceException {
        this.myProfile = profile;
        try {
            Object object;
            Object object2;
            CharSequence charSequence;
            Object object3;
            StringACLCodec stringACLCodec = new StringACLCodec();
            this.messageEncodings.put(stringACLCodec.getName().toLowerCase(), stringACLCodec);
            LEAPACLCodec lEAPACLCodec = new LEAPACLCodec();
            this.messageEncodings.put(lEAPACLCodec.getName().toLowerCase(), lEAPACLCodec);
            List list = profile.getSpecifiers("aclcodecs");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object3 = (Specifier)iterator.next();
                charSequence = ((Specifier)object3).getClassName();
                try {
                    object2 = Class.forName(charSequence);
                    object = (ACLCodec)((Class)object2).newInstance();
                    this.messageEncodings.put(object.getName().toLowerCase(), object);
                    if (!this.logger.isLoggable(Logger.CONFIG)) continue;
                    this.logger.log(Logger.CONFIG, "Installed " + object.getName() + " ACLCodec implemented by " + charSequence + "\n");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ACLCodec.CodecException("ERROR: The class " + charSequence + " for the ACLCodec not found.", classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    throw new ACLCodec.CodecException("The class " + charSequence + " raised InstantiationException (see NestedException)", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ACLCodec.CodecException("The class " + charSequence + " raised IllegalAccessException (see nested exception)", illegalAccessException);
                }
            }
            list = profile.getSpecifiers("mtps");
            object3 = null;
            charSequence = null;
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (Specifier)object2.next();
                String string = ((Specifier)object).getClassName();
                String string2 = null;
                Object[] objectArray = ((Specifier)object).getArgs();
                if (objectArray != null && objectArray.length > 0 && (string2 = objectArray[0].toString()).equals("")) {
                    string2 = null;
                }
                MessagingSlice messagingSlice = (MessagingSlice)this.getSlice(this.getLocalNode().getName());
                MTPDescriptor mTPDescriptor = messagingSlice.installMTP(string2, string);
                String[] stringArray = mTPDescriptor.getAddresses();
                if (object3 == null) {
                    String string3 = profile.getParameter("file-dir", "") + "MTPs-" + this.myContainer.getID().getName() + ".txt";
                    object3 = new PrintWriter(new FileWriter(string3));
                    charSequence = new StringBuffer("MTP addresses:");
                }
                ((PrintWriter)object3).println(stringArray[0]);
                ((StringBuffer)charSequence).append("\n");
                ((StringBuffer)charSequence).append(stringArray[0]);
            }
            if (object3 != null) {
                this.myLogger.log(Logger.INFO, ((StringBuffer)charSequence).toString());
                ((PrintWriter)object3).close();
            }
        }
        catch (ProfileException profileException) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Error reading MTPs/Codecs");
            }
            profileException.printStackTrace();
        }
        catch (ServiceException serviceException) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Error installing local MTPs");
            }
            serviceException.printStackTrace();
        }
        catch (ACLCodec.CodecException codecException) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Error installing ACL Codec");
            }
            codecException.printStackTrace();
        }
        catch (MTPException mTPException) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Error installing MTP");
            }
            mTPException.printStackTrace();
        }
        catch (IOException iOException) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Error writing platform address");
            }
            iOException.printStackTrace();
        }
        catch (IMTPException iMTPException) {
            iMTPException.printStackTrace();
        }
    }

    public void deliverNow(GenericMessage genericMessage, AID aID) {
        block9: {
            try {
                if (!genericMessage.hasForeignReceiver()) {
                    this.localSlice.deliverNow(genericMessage, aID);
                    break block9;
                }
                Iterator iterator = aID.getAllAddresses();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    try {
                        this.forwardMessage(genericMessage, aID, string);
                        return;
                    }
                    catch (MTPException mTPException) {
                        if (!this.logger.isLoggable(Logger.WARNING)) continue;
                        this.logger.log(Logger.WARNING, "Cannot deliver message to address: " + string + " [" + mTPException.toString() + "]. Trying the next one...");
                    }
                }
                this.notifyFailureToSender(genericMessage, aID, new InternalError("No valid address contained within the AID " + aID.getName()));
            }
            catch (NotFoundException notFoundException) {
                this.notifyFailureToSender(genericMessage, aID, new InternalError("Agent not found: " + notFoundException.getMessage()));
            }
            catch (IMTPException iMTPException) {
                this.notifyFailureToSender(genericMessage, aID, new InternalError("Agent unreachable: " + iMTPException.getMessage()));
            }
            catch (ServiceException serviceException) {
                this.notifyFailureToSender(genericMessage, aID, new InternalError("Service error: " + serviceException.getMessage()));
            }
            catch (JADESecurityException jADESecurityException) {
                this.notifyFailureToSender(genericMessage, aID, new InternalError("Not authorized: " + jADESecurityException.getMessage()));
            }
        }
    }

    private void forwardMessage(GenericMessage genericMessage, AID aID, String string) throws MTPException {
        AID aID2 = genericMessage.getEnvelope().getFrom();
        if (aID2 == null) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "ERROR: null message sender. Aborting message dispatch...");
            }
            return;
        }
        if (!aID2.getAllAddresses().hasNext()) {
            this.addPlatformAddresses(aID2);
        }
        try {
            this.localSlice.routeOut(genericMessage.getEnvelope(), genericMessage.getPayload(), aID, string);
        }
        catch (IMTPException iMTPException) {
            throw new MTPException("Error during message routing", iMTPException);
        }
    }

    public void notifyFailureToSender(GenericMessage genericMessage, AID aID, InternalError internalError) {
        if (aID.equals(this.myContainer.getAMS()) && genericMessage.getAttemptCnt() < 3 && !internalError.getErrorMessage().startsWith("Not authorized")) {
            this.myLogger.log(Logger.WARNING, "Error \"" + internalError.getErrorMessage() + "\" delivering message to the AMS. It must be due to a main fault recovery in progress. Wait a bit then try again");
            genericMessage.incAttemptCnt();
            this.waitABit(3000L);
            this.deliverNow(genericMessage, aID);
        } else {
            GenericCommand genericCommand = new GenericCommand("Notify-Failure", "jade.core.messaging.Messaging", null);
            genericCommand.addParam(genericMessage);
            genericCommand.addParam(aID);
            genericCommand.addParam(internalError);
            try {
                this.submit(genericCommand);
            }
            catch (ServiceException serviceException) {
                serviceException.printStackTrace();
            }
        }
    }

    private void addPlatformAddresses(AID aID) {
        Iterator iterator = this.localSlice.getAddresses();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            aID.addAddresses(string);
        }
    }

    final boolean livesHere(AID aID) {
        if (!this.acceptForeignAgents) {
            String string = aID.getHap();
            return CaseInsensitiveString.equalsIgnoreCase(string, this.platformID);
        }
        String[] stringArray = aID.getAddressesArray();
        if (stringArray.length == 0) {
            return true;
        }
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            if (!this.isPlatformAddress(stringArray[n])) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            return true;
        }
        try {
            MainContainer mainContainer = this.myContainer.getMain();
            if (mainContainer != null) {
                mainContainer.getContainerID(aID);
            } else {
                MessagingSlice messagingSlice = (MessagingSlice)this.getSlice("$$$Main-Slice$$$");
                try {
                    messagingSlice.getAgentLocation(aID);
                }
                catch (IMTPException iMTPException) {
                    messagingSlice = (MessagingSlice)this.getFreshSlice("$$$Main-Slice$$$");
                    messagingSlice.getAgentLocation(aID);
                }
            }
            return true;
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private final boolean isPlatformAddress(String string) {
        Iterator iterator = this.localSlice.getAddresses();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!CaseInsensitiveString.equalsIgnoreCase(string2, string)) continue;
            return true;
        }
        return false;
    }

    private void waitABit(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected Service.Slice getFreshSlice(String string) throws ServiceException {
        return super.getFreshSlice(string);
    }

    private class ServiceComponent
    implements Service.Slice {
        private ServiceComponent() {
        }

        public Iterator getAddresses() {
            return MessagingService.this.routes.getAddresses();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void deliverNow(GenericMessage genericMessage, AID aID) throws IMTPException, ServiceException, NotFoundException, JADESecurityException {
            MainContainer mainContainer;
            if (MessagingService.this.logger.isLoggable(Logger.FINE)) {
                MessagingService.this.logger.log(Logger.FINE, "Delivering message for " + aID.getName());
            }
            if ((mainContainer = MessagingService.this.myContainer.getMain()) == null) {
                MessagingSlice messagingSlice = (MessagingSlice)MessagingService.this.cachedSlices.get(aID);
                if (messagingSlice == null) {
                    this.deliverUntilOK(genericMessage, aID);
                    return;
                }
                try {
                    messagingSlice.dispatchLocally(genericMessage.getSender(), genericMessage, aID);
                    return;
                }
                catch (IMTPException iMTPException) {
                    if (MessagingService.this.logger.isLoggable(Logger.FINER)) {
                        MessagingService.this.logger.log(Logger.FINER, "Cached slice for agent " + aID.getName() + " unreachable. Remove it.");
                    }
                    MessagingService.this.cachedSlices.remove(aID);
                    this.deliverUntilOK(genericMessage, aID);
                    return;
                }
                catch (NotFoundException notFoundException) {
                    if (MessagingService.this.logger.isLoggable(Logger.FINER)) {
                        MessagingService.this.logger.log(Logger.FINER, "Cached slice does not contain agent " + aID.getName() + ". Remove it.");
                    }
                    MessagingService.this.cachedSlices.remove(aID);
                    this.deliverUntilOK(genericMessage, aID);
                    return;
                }
            }
            while (true) {
                MessagingSlice messagingSlice = null;
                ContainerID containerID = mainContainer.getContainerID(aID);
                messagingSlice = (MessagingSlice)MessagingService.this.getSlice(containerID.getName());
                try {
                    try {
                        messagingSlice.dispatchLocally(genericMessage.getSender(), genericMessage, aID);
                        return;
                    }
                    catch (IMTPException iMTPException) {
                        messagingSlice = (MessagingSlice)MessagingService.this.getFreshSlice(containerID.getName());
                        messagingSlice.dispatchLocally(genericMessage.getSender(), genericMessage, aID);
                    }
                    return;
                }
                catch (NotFoundException notFoundException) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                break;
            }
        }

        private void deliverUntilOK(GenericMessage genericMessage, AID aID) throws IMTPException, NotFoundException, ServiceException, JADESecurityException {
            boolean bl = false;
            do {
                ContainerID containerID;
                MessagingSlice messagingSlice = (MessagingSlice)MessagingService.this.getSlice("$$$Main-Slice$$$");
                try {
                    containerID = messagingSlice.getAgentLocation(aID);
                }
                catch (IMTPException iMTPException) {
                    messagingSlice = (MessagingSlice)MessagingService.this.getFreshSlice("$$$Main-Slice$$$");
                    containerID = messagingSlice.getAgentLocation(aID);
                }
                MessagingSlice messagingSlice2 = (MessagingSlice)MessagingService.this.getSlice(containerID.getName());
                try {
                    block12: {
                        try {
                            messagingSlice2.dispatchLocally(genericMessage.getSender(), genericMessage, aID);
                        }
                        catch (IMTPException iMTPException) {
                            if (MessagingService.this.logger.isLoggable(Logger.FINER)) {
                                MessagingService.this.logger.log(Logger.FINER, "Slice " + messagingSlice2 + " for agent " + aID.getName() + " unreachable. Try to get a fresh slice.");
                            }
                            try {
                                messagingSlice2 = (MessagingSlice)MessagingService.this.getFreshSlice(containerID.getName());
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                                throw (IMTPException)throwable;
                            }
                            if (MessagingService.this.logger.isLoggable(Logger.FINEST)) {
                                MessagingService.this.logger.log(Logger.FINEST, "Fresh slice is " + messagingSlice2);
                            }
                            messagingSlice2.dispatchLocally(genericMessage.getSender(), genericMessage, aID);
                            if (!MessagingService.this.logger.isLoggable(Logger.FINEST)) break block12;
                            MessagingService.this.logger.log(Logger.FINEST, "Dispatch successful");
                        }
                    }
                    MessagingService.this.cachedSlices.put(aID, messagingSlice2);
                    bl = true;
                }
                catch (NotFoundException notFoundException) {
                    bl = false;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            } while (!bl);
        }

        public Service getService() {
            return MessagingService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return MessagingService.this.getLocalNode();
            }
            catch (IMTPException iMTPException) {
                throw new ServiceException("Problem in contacting the IMTP Manager", iMTPException);
            }
        }

        public VerticalCommand serve(HorizontalCommand horizontalCommand) {
            GenericCommand genericCommand = null;
            try {
                String string = horizontalCommand.getName();
                Object[] objectArray = horizontalCommand.getParams();
                if (string.equals("1")) {
                    GenericCommand genericCommand2 = new GenericCommand("Send-Message", "jade.core.messaging.Messaging", null);
                    AID aID = (AID)objectArray[0];
                    GenericMessage genericMessage = (GenericMessage)objectArray[1];
                    AID aID2 = (AID)objectArray[2];
                    genericCommand2.addParam(aID);
                    genericCommand2.addParam(genericMessage);
                    genericCommand2.addParam(aID2);
                    genericCommand = genericCommand2;
                } else if (string.equals("2")) {
                    Envelope envelope = (Envelope)objectArray[0];
                    byte[] byArray = (byte[])objectArray[1];
                    AID aID = (AID)objectArray[2];
                    String string2 = (String)objectArray[3];
                    this.routeOut(envelope, byArray, aID, string2);
                } else if (string.equals("3")) {
                    AID aID = (AID)objectArray[0];
                    horizontalCommand.setReturnValue(this.getAgentLocation(aID));
                } else if (string.equals("4")) {
                    GenericCommand genericCommand3 = new GenericCommand("Install-MTP", "jade.core.messaging.Messaging", null);
                    String string3 = (String)objectArray[0];
                    String string4 = (String)objectArray[1];
                    genericCommand3.addParam(string3);
                    genericCommand3.addParam(string4);
                    genericCommand = genericCommand3;
                } else if (string.equals("5")) {
                    GenericCommand genericCommand4 = new GenericCommand("Uninstall-MTP", "jade.core.messaging.Messaging", null);
                    String string5 = (String)objectArray[0];
                    genericCommand4.addParam(string5);
                    genericCommand = genericCommand4;
                } else if (string.equals("6")) {
                    MTPDescriptor mTPDescriptor = (MTPDescriptor)objectArray[0];
                    ContainerID containerID = (ContainerID)objectArray[1];
                    GenericCommand genericCommand5 = new GenericCommand("New-MTP", "jade.core.messaging.Messaging", null);
                    genericCommand5.addParam(mTPDescriptor);
                    genericCommand5.addParam(containerID);
                    genericCommand = genericCommand5;
                } else if (string.equals("7")) {
                    MTPDescriptor mTPDescriptor = (MTPDescriptor)objectArray[0];
                    ContainerID containerID = (ContainerID)objectArray[1];
                    GenericCommand genericCommand6 = new GenericCommand("Dead-MTP", "jade.core.messaging.Messaging", null);
                    genericCommand6.addParam(mTPDescriptor);
                    genericCommand6.addParam(containerID);
                    genericCommand = genericCommand6;
                } else if (string.equals("8")) {
                    MTPDescriptor mTPDescriptor = (MTPDescriptor)objectArray[0];
                    String string6 = (String)objectArray[1];
                    this.addRoute(mTPDescriptor, string6);
                } else if (string.equals("9")) {
                    MTPDescriptor mTPDescriptor = (MTPDescriptor)objectArray[0];
                    String string7 = (String)objectArray[1];
                    this.removeRoute(mTPDescriptor, string7);
                }
            }
            catch (Throwable throwable) {
                horizontalCommand.setReturnValue(throwable);
            }
            return genericCommand;
        }

        private void routeOut(Envelope envelope, byte[] byArray, AID aID, String string) throws IMTPException, MTPException {
            RoutingTable.OutPort outPort = MessagingService.this.routes.lookup(string);
            if (MessagingService.this.logger.isLoggable(Logger.FINE)) {
                MessagingService.this.logger.log(Logger.FINE, "Routing message to " + aID.getName() + " towards port " + outPort);
            }
            if (outPort == null) {
                throw new MTPException("No suitable route found for address " + string + ".");
            }
            outPort.route(envelope, byArray, aID, string);
        }

        private ContainerID getAgentLocation(AID aID) throws IMTPException, NotFoundException {
            MainContainer mainContainer = MessagingService.this.myContainer.getMain();
            if (mainContainer != null) {
                return mainContainer.getContainerID(aID);
            }
            return null;
        }

        private void addRoute(MTPDescriptor mTPDescriptor, String string) throws IMTPException, ServiceException {
            MessagingSlice messagingSlice = (MessagingSlice)MessagingService.this.getFreshSlice(string);
            MessagingService.this.routes.addRemoteMTP(mTPDescriptor, string, messagingSlice);
            String[] stringArray = mTPDescriptor.getSupportedProtocols();
            int n = 0;
            while (n < stringArray.length) {
                if (MessagingService.this.logger.isLoggable(Logger.CONFIG)) {
                    MessagingService.this.logger.log(Logger.CONFIG, "Added Route-Via-Slice(" + string + ") for protocol " + stringArray[n]);
                }
                ++n;
            }
            String[] stringArray2 = mTPDescriptor.getAddresses();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                MessagingService.this.myContainer.addAddressToLocalAgents(stringArray2[n2]);
                ++n2;
            }
        }

        private void removeRoute(MTPDescriptor mTPDescriptor, String string) throws IMTPException, ServiceException {
            MessagingSlice messagingSlice = (MessagingSlice)MessagingService.this.getSlice(string);
            MessagingService.this.routes.removeRemoteMTP(mTPDescriptor, string, messagingSlice);
            String[] stringArray = mTPDescriptor.getSupportedProtocols();
            int n = 0;
            while (n < stringArray.length) {
                if (MessagingService.this.logger.isLoggable(Logger.CONFIG)) {
                    MessagingService.this.logger.log(Logger.CONFIG, "Removed Route-Via-Slice(" + string + ") for protocol " + stringArray[n]);
                }
                ++n;
            }
            String[] stringArray2 = mTPDescriptor.getAddresses();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                MessagingService.this.myContainer.removeAddressFromLocalAgents(stringArray2[n2]);
                ++n2;
            }
        }
    }

    private class CommandTargetSink
    implements Sink {
        private CommandTargetSink() {
        }

        public void consume(VerticalCommand verticalCommand) {
            try {
                String string = verticalCommand.getName();
                if (string.equals("Send-Message")) {
                    this.handleSendMessage(verticalCommand);
                } else if (string.equals("Install-MTP")) {
                    MTPDescriptor mTPDescriptor = this.handleInstallMTP(verticalCommand);
                    verticalCommand.setReturnValue(mTPDescriptor);
                } else if (string.equals("Uninstall-MTP")) {
                    this.handleUninstallMTP(verticalCommand);
                } else if (string.equals("New-MTP")) {
                    this.handleNewMTP(verticalCommand);
                } else if (string.equals("Dead-MTP")) {
                    this.handleDeadMTP(verticalCommand);
                } else if (string.equals("Set-Platform-Addresses")) {
                    this.handleSetPlatformAddresses(verticalCommand);
                } else if (string.equals("New-Slice")) {
                    this.handleNewSlice(verticalCommand);
                }
            }
            catch (IMTPException iMTPException) {
                verticalCommand.setReturnValue(iMTPException);
            }
            catch (NotFoundException notFoundException) {
                verticalCommand.setReturnValue(notFoundException);
            }
            catch (ServiceException serviceException) {
                verticalCommand.setReturnValue(serviceException);
            }
            catch (MTPException mTPException) {
                verticalCommand.setReturnValue(mTPException);
            }
        }

        private void handleSendMessage(VerticalCommand verticalCommand) throws NotFoundException {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            GenericMessage genericMessage = (GenericMessage)objectArray[1];
            AID aID2 = (AID)objectArray[2];
            this.dispatchLocally(genericMessage.getACLMessage(), aID2);
        }

        private MTPDescriptor handleInstallMTP(VerticalCommand verticalCommand) throws IMTPException, ServiceException, MTPException {
            Object[] objectArray = verticalCommand.getParams();
            String string = (String)objectArray[0];
            String string2 = (String)objectArray[1];
            return this.installMTP(string, string2);
        }

        private void handleUninstallMTP(VerticalCommand verticalCommand) throws IMTPException, ServiceException, NotFoundException, MTPException {
            Object[] objectArray = verticalCommand.getParams();
            String string = (String)objectArray[0];
            this.uninstallMTP(string);
        }

        private void handleNewMTP(VerticalCommand verticalCommand) throws IMTPException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            MTPDescriptor mTPDescriptor = (MTPDescriptor)objectArray[0];
            ContainerID containerID = (ContainerID)objectArray[1];
            this.newMTP(mTPDescriptor, containerID);
        }

        private void handleDeadMTP(VerticalCommand verticalCommand) throws IMTPException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            MTPDescriptor mTPDescriptor = (MTPDescriptor)objectArray[0];
            ContainerID containerID = (ContainerID)objectArray[1];
            this.deadMTP(mTPDescriptor, containerID);
        }

        private void handleSetPlatformAddresses(VerticalCommand verticalCommand) {
        }

        private void handleNewSlice(VerticalCommand verticalCommand) {
            block7: {
                MainContainer mainContainer = MessagingService.this.myContainer.getMain();
                if (mainContainer == null) break block7;
                Object[] objectArray = verticalCommand.getParams();
                String string = (String)objectArray[0];
                try {
                    MessagingSlice messagingSlice = (MessagingSlice)MessagingService.this.getFreshSlice(string);
                    ContainerID[] containerIDArray = mainContainer.containerIDs();
                    int n = 0;
                    while (n < containerIDArray.length) {
                        ContainerID containerID = containerIDArray[n];
                        try {
                            List list = mainContainer.containerMTPs(containerID);
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                MTPDescriptor mTPDescriptor = (MTPDescriptor)iterator.next();
                                messagingSlice.addRoute(mTPDescriptor, containerID.getName());
                            }
                        }
                        catch (NotFoundException notFoundException) {
                            notFoundException.printStackTrace();
                        }
                        ++n;
                    }
                }
                catch (ServiceException serviceException) {
                    serviceException.printStackTrace();
                }
                catch (IMTPException iMTPException) {
                    iMTPException.printStackTrace();
                }
            }
        }

        private void dispatchLocally(ACLMessage aCLMessage, AID aID) throws NotFoundException {
            boolean bl;
            if (MessagingService.this.logger.isLoggable(Logger.FINE)) {
                MessagingService.this.logger.log(Logger.FINE, "Posting message from " + aCLMessage.getSender().getName() + " to " + aID);
            }
            if (!(bl = MessagingService.this.myContainer.postMessageToLocalAgent(aCLMessage, aID))) {
                throw new NotFoundException("Messaging service slice failed to find " + aID);
            }
        }

        private MTPDescriptor installMTP(String string, String string2) throws IMTPException, ServiceException, MTPException {
            try {
                Object object;
                Class<?> clazz = Class.forName(string2);
                MTP mTP = (MTP)clazz.newInstance();
                InChannel.Dispatcher dispatcher = new InChannel.Dispatcher(){

                    public void dispatchMessage(Envelope envelope, byte[] byArray) {
                        Object object;
                        if (MessagingService.this.logger.isLoggable(Logger.FINE)) {
                            MessagingService.this.logger.log(Logger.FINE, "Message from remote platform received");
                        }
                        ReceivedObject[] receivedObjectArray = envelope.getStamps();
                        int n = 0;
                        while (n < receivedObjectArray.length) {
                            object = receivedObjectArray[n].getBy();
                            if (CaseInsensitiveString.equalsIgnoreCase((String)object, MessagingService.this.accID)) {
                                System.err.println("ERROR: Message loop detected !!!");
                                System.err.println("Route is: ");
                                int n2 = 0;
                                while (n2 < receivedObjectArray.length) {
                                    System.err.println("[" + n2 + "]" + receivedObjectArray[n2].getBy());
                                    ++n2;
                                }
                                System.err.println("Message dispatch aborted.");
                                return;
                            }
                            ++n;
                        }
                        object = new ReceivedObject();
                        ((ReceivedObject)object).setBy(MessagingService.this.accID);
                        ((ReceivedObject)object).setDate(new Date());
                        envelope.setReceived((ReceivedObject)object);
                        Iterator iterator = envelope.getAllIntendedReceiver();
                        while (iterator.hasNext()) {
                            AID aID = (AID)iterator.next();
                            GenericMessage genericMessage = new GenericMessage(envelope, byArray);
                            MessagingService.this.myMessageManager.deliver(genericMessage, aID, MessagingService.this);
                        }
                    }
                };
                if (string == null) {
                    object = mTP.activate(dispatcher, MessagingService.this.myProfile);
                    string = mTP.addrToStr((TransportAddress)object);
                } else {
                    object = mTP.strToAddr(string);
                    mTP.activate(dispatcher, (TransportAddress)object, MessagingService.this.myProfile);
                }
                MessagingService.this.routes.addLocalMTP(string, mTP);
                object = new MTPDescriptor(mTP.getName(), string2, new String[]{string}, mTP.getSupportedProtocols());
                String[] stringArray = ((MTPDescriptor)object).getSupportedProtocols();
                int n = 0;
                while (n < stringArray.length) {
                    if (MessagingService.this.logger.isLoggable(Logger.CONFIG)) {
                        MessagingService.this.logger.log(Logger.CONFIG, "Added Route-Via-MTP for protocol " + stringArray[n]);
                    }
                    ++n;
                }
                String[] stringArray2 = ((MTPDescriptor)object).getAddresses();
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    MessagingService.this.myContainer.addAddressToLocalAgents(stringArray2[n2]);
                    ++n2;
                }
                GenericCommand genericCommand = new GenericCommand("New-MTP", "jade.core.messaging.Messaging", null);
                genericCommand.addParam(object);
                genericCommand.addParam(MessagingService.this.myContainer.getID());
                MessagingService.this.submit(genericCommand);
                return object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MTPException("ERROR: The class " + string2 + " for the " + string + " MTP was not found");
            }
            catch (InstantiationException instantiationException) {
                throw new MTPException("The class " + string2 + " raised InstantiationException (see nested exception)", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MTPException("The class " + string2 + " raised IllegalAccessException (see nested exception)", illegalAccessException);
            }
        }

        private void uninstallMTP(String string) throws IMTPException, ServiceException, NotFoundException, MTPException {
            MTPDescriptor mTPDescriptor;
            MTP mTP = MessagingService.this.routes.removeLocalMTP(string);
            if (mTP != null) {
                TransportAddress transportAddress = mTP.strToAddr(string);
                mTP.deactivate(transportAddress);
                mTPDescriptor = new MTPDescriptor(mTP.getName(), mTP.getClass().getName(), new String[]{string}, mTP.getSupportedProtocols());
                String[] stringArray = mTPDescriptor.getAddresses();
                int n = 0;
                while (n < stringArray.length) {
                    MessagingService.this.myContainer.removeAddressFromLocalAgents(stringArray[n]);
                    ++n;
                }
            } else {
                throw new MTPException("No such address was found on this container: " + string);
            }
            GenericCommand genericCommand = new GenericCommand("Dead-MTP", "jade.core.messaging.Messaging", null);
            genericCommand.addParam(mTPDescriptor);
            genericCommand.addParam(MessagingService.this.myContainer.getID());
            MessagingService.this.submit(genericCommand);
        }

        private void newMTP(MTPDescriptor mTPDescriptor, ContainerID containerID) throws IMTPException, ServiceException {
            MainContainer mainContainer = MessagingService.this.myContainer.getMain();
            if (mainContainer != null) {
                Service.Slice[] sliceArray = MessagingService.this.getAllSlices();
                int n = 0;
                while (n < sliceArray.length) {
                    try {
                        MessagingSlice messagingSlice = (MessagingSlice)sliceArray[n];
                        String string = messagingSlice.getNode().getName();
                        if (!string.equals(containerID.getName())) {
                            messagingSlice.addRoute(mTPDescriptor, containerID.getName());
                        }
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof IMTPException) {
                            throw (IMTPException)throwable;
                        }
                        if (throwable instanceof ServiceException) {
                            throw (ServiceException)throwable;
                        }
                        MessagingService.this.logger.log(Logger.WARNING, "### addRoute() threw " + throwable + " ###");
                    }
                    ++n;
                }
                mainContainer.newMTP(mTPDescriptor, containerID);
            }
        }

        private void deadMTP(MTPDescriptor mTPDescriptor, ContainerID containerID) throws IMTPException, ServiceException {
            MainContainer mainContainer = MessagingService.this.myContainer.getMain();
            if (mainContainer != null) {
                Service.Slice[] sliceArray = MessagingService.this.getAllSlices();
                int n = 0;
                while (n < sliceArray.length) {
                    try {
                        MessagingSlice messagingSlice = (MessagingSlice)sliceArray[n];
                        String string = messagingSlice.getNode().getName();
                        if (!string.equals(containerID.getName())) {
                            messagingSlice.removeRoute(mTPDescriptor, containerID.getName());
                        }
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof IMTPException) {
                            throw (IMTPException)throwable;
                        }
                        if (throwable instanceof ServiceException) {
                            throw (ServiceException)throwable;
                        }
                        MessagingService.this.logger.log(Logger.WARNING, "### removeRoute() threw " + throwable + " ###");
                    }
                    ++n;
                }
                mainContainer.deadMTP(mTPDescriptor, containerID);
            }
        }
    }

    private class CommandSourceSink
    implements Sink {
        private CommandSourceSink() {
        }

        public void consume(VerticalCommand verticalCommand) {
            try {
                String string = verticalCommand.getName();
                if (string.equals("Send-Message")) {
                    this.handleSendMessage(verticalCommand);
                } else if (string.equals("Notify-Failure")) {
                    this.handleNotifyFailure(verticalCommand);
                } else if (string.equals("Install-MTP")) {
                    MTPDescriptor mTPDescriptor = this.handleInstallMTP(verticalCommand);
                    verticalCommand.setReturnValue(mTPDescriptor);
                } else if (string.equals("Uninstall-MTP")) {
                    this.handleUninstallMTP(verticalCommand);
                } else if (string.equals("New-MTP")) {
                    this.handleNewMTP(verticalCommand);
                } else if (string.equals("Dead-MTP")) {
                    this.handleDeadMTP(verticalCommand);
                } else if (string.equals("Set-Platform-Addresses")) {
                    this.handleSetPlatformAddresses(verticalCommand);
                }
            }
            catch (IMTPException iMTPException) {
                iMTPException.printStackTrace();
            }
            catch (NotFoundException notFoundException) {
                notFoundException.printStackTrace();
            }
            catch (ServiceException serviceException) {
                serviceException.printStackTrace();
            }
            catch (MTPException mTPException) {
                mTPException.printStackTrace();
            }
            catch (Throwable throwable) {
                verticalCommand.setReturnValue(throwable);
            }
        }

        private void handleSendMessage(VerticalCommand verticalCommand) {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            GenericMessage genericMessage = (GenericMessage)objectArray[1];
            AID aID2 = (AID)objectArray[2];
            genericMessage.setSenderPrincipal(verticalCommand.getPrincipal());
            genericMessage.setSenderCredentials(verticalCommand.getCredentials());
            if (MessagingService.this.logger.isLoggable(Logger.FINE)) {
                MessagingService.this.logger.log(Logger.FINE, "Enqueuing message for " + aID2.getName() + " to MessageManager");
            }
            if (MessagingService.this.logger.isLoggable(Logger.FINE)) {
                MessagingService.this.logger.log(Logger.FINE, "Enqueuing message for " + aID2.getName() + " to MessageManager");
            }
            MessagingService.this.myMessageManager.deliver(genericMessage, aID2, MessagingService.this);
        }

        private void handleNotifyFailure(VerticalCommand verticalCommand) {
            Object[] objectArray = verticalCommand.getParams();
            GenericMessage genericMessage = (GenericMessage)objectArray[0];
            AID aID = (AID)objectArray[1];
            InternalError internalError = (InternalError)objectArray[2];
            ACLMessage aCLMessage = genericMessage.getACLMessage();
            if (aCLMessage.getSender() == null || aCLMessage.getSender().equals(MessagingService.this.myContainer.getAMS()) && aCLMessage.getPerformative() == 6) {
                return;
            }
            ACLMessage aCLMessage2 = aCLMessage.createReply();
            aCLMessage2.setPerformative(6);
            AID aID2 = MessagingService.this.myContainer.getAMS();
            aCLMessage2.setSender(aID2);
            aCLMessage2.setLanguage("fipa-sl");
            String string = "( (action " + genericMessage.getSender().toString();
            string = string + " (ACLMessage) ) (MTS-error " + aID + " " + internalError.getMessage() + ") )";
            aCLMessage2.setContent(string);
            try {
                GenericCommand genericCommand = new GenericCommand("Send-Message", "jade.core.messaging.Messaging", null);
                genericCommand.addParam(aID2);
                GenericMessage genericMessage2 = new GenericMessage(aCLMessage2);
                genericMessage2.setAMSFailure(true);
                genericCommand.addParam(genericMessage2);
                genericCommand.addParam((AID)aCLMessage2.getAllReceiver().next());
                MessagingService.this.submit(genericCommand);
            }
            catch (ServiceException serviceException) {
                serviceException.printStackTrace();
            }
        }

        private MTPDescriptor handleInstallMTP(VerticalCommand verticalCommand) throws IMTPException, ServiceException, NotFoundException, MTPException {
            Object[] objectArray = verticalCommand.getParams();
            String string = (String)objectArray[0];
            ContainerID containerID = (ContainerID)objectArray[1];
            String string2 = (String)objectArray[2];
            MessagingSlice messagingSlice = (MessagingSlice)MessagingService.this.getSlice(containerID.getName());
            try {
                return messagingSlice.installMTP(string, string2);
            }
            catch (IMTPException iMTPException) {
                messagingSlice = (MessagingSlice)MessagingService.this.getFreshSlice(containerID.getName());
                return messagingSlice.installMTP(string, string2);
            }
        }

        private void handleUninstallMTP(VerticalCommand verticalCommand) throws IMTPException, ServiceException, NotFoundException, MTPException {
            Object[] objectArray = verticalCommand.getParams();
            String string = (String)objectArray[0];
            ContainerID containerID = (ContainerID)objectArray[1];
            MessagingSlice messagingSlice = (MessagingSlice)MessagingService.this.getSlice(containerID.getName());
            try {
                messagingSlice.uninstallMTP(string);
            }
            catch (IMTPException iMTPException) {
                messagingSlice = (MessagingSlice)MessagingService.this.getFreshSlice(containerID.getName());
                messagingSlice.uninstallMTP(string);
            }
        }

        private void handleNewMTP(VerticalCommand verticalCommand) throws IMTPException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            MTPDescriptor mTPDescriptor = (MTPDescriptor)objectArray[0];
            ContainerID containerID = (ContainerID)objectArray[1];
            MessagingSlice messagingSlice = (MessagingSlice)MessagingService.this.getSlice("$$$Main-Slice$$$");
            try {
                messagingSlice.newMTP(mTPDescriptor, containerID);
            }
            catch (IMTPException iMTPException) {
                messagingSlice = (MessagingSlice)MessagingService.this.getFreshSlice("$$$Main-Slice$$$");
                messagingSlice.newMTP(mTPDescriptor, containerID);
            }
        }

        private void handleDeadMTP(VerticalCommand verticalCommand) throws IMTPException, ServiceException {
            Object[] objectArray = verticalCommand.getParams();
            MTPDescriptor mTPDescriptor = (MTPDescriptor)objectArray[0];
            ContainerID containerID = (ContainerID)objectArray[1];
            MessagingSlice messagingSlice = (MessagingSlice)MessagingService.this.getSlice("$$$Main-Slice$$$");
            try {
                messagingSlice.deadMTP(mTPDescriptor, containerID);
            }
            catch (IMTPException iMTPException) {
                messagingSlice = (MessagingSlice)MessagingService.this.getFreshSlice("$$$Main-Slice$$$");
                messagingSlice.deadMTP(mTPDescriptor, containerID);
            }
        }

        private void handleSetPlatformAddresses(VerticalCommand verticalCommand) {
            Object[] objectArray = verticalCommand.getParams();
            AID aID = (AID)objectArray[0];
            aID.clearAllAddresses();
            MessagingService.this.addPlatformAddresses(aID);
        }
    }

    public static class UnknownACLEncodingException
    extends NotFoundException {
        UnknownACLEncodingException(String string) {
            super(string);
        }
    }
}

