/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.behaviours.SimpleBehaviour;
import java.util.Date;

public abstract class WakerBehaviour
extends SimpleBehaviour {
    private long wakeupTime;
    private long blockTime;
    private long timeout;
    private int state;
    private boolean finished;

    public WakerBehaviour(Agent agent, Date date) {
        super(agent);
        this.wakeupTime = date.getTime();
        this.state = 0;
        this.finished = false;
    }

    public WakerBehaviour(Agent agent, long l) {
        super(agent);
        this.wakeupTime = -1L;
        this.timeout = l;
        this.state = 0;
        this.finished = false;
    }

    public final void action() {
        switch (this.state) {
            case 0: {
                if (this.wakeupTime == -1L) {
                    this.wakeupTime = System.currentTimeMillis() + this.timeout;
                }
                this.blockTime = this.wakeupTime - System.currentTimeMillis();
                if (this.blockTime > 0L) {
                    this.block(this.blockTime);
                }
                ++this.state;
                break;
            }
            case 1: {
                this.blockTime = this.wakeupTime - System.currentTimeMillis();
                if (this.blockTime <= 0L) {
                    this.finished = true;
                    this.onWake();
                    break;
                }
                this.block(this.blockTime);
                break;
            }
            default: {
                this.state = 0;
            }
        }
    }

    protected void onWake() {
        this.handleElapsedTimeout();
    }

    protected void handleElapsedTimeout() {
    }

    public void reset(Date date) {
        super.reset();
        this.wakeupTime = date.getTime();
        this.state = 0;
        this.finished = false;
    }

    public void reset(long l) {
        this.wakeupTime = -1L;
        this.timeout = l;
        this.state = 0;
        this.finished = false;
    }

    public final boolean done() {
        return this.finished;
    }
}

