/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.behaviours.SimpleBehaviour;

public abstract class TickerBehaviour
extends SimpleBehaviour {
    private long wakeupTime;
    private long period;
    private int state;
    private boolean finished;
    private int tickCount = 0;

    public TickerBehaviour(Agent agent, long l) {
        super(agent);
        if (l <= 0L) {
            throw new IllegalArgumentException("Period must be greater than 0");
        }
        this.period = l;
        this.state = 0;
    }

    public void onStart() {
        this.wakeupTime = System.currentTimeMillis() + this.period;
    }

    public final void action() {
        if (!this.finished) {
            long l = this.wakeupTime - System.currentTimeMillis();
            if (l <= 0L) {
                ++this.tickCount;
                this.onTick();
                this.wakeupTime = System.currentTimeMillis() + this.period;
                l = this.period;
            }
            if (this.myAgent != null) {
                this.block(l);
            }
        }
    }

    public final boolean done() {
        return this.finished;
    }

    protected abstract void onTick();

    public void reset(long l) {
        this.reset();
        if (l <= 0L) {
            throw new IllegalArgumentException("Period must be greater than 0");
        }
        this.period = l;
    }

    public void reset() {
        super.reset();
        this.state = 0;
        this.finished = false;
        this.tickCount = 0;
    }

    public void stop() {
        this.finished = true;
    }

    public final int getTickCount() {
        return this.tickCount;
    }

    private void setTickCount(int n) {
        this.tickCount = n;
    }

    private void setPeriod(long l) {
        this.period = l;
    }

    private long getPeriod() {
        return this.period;
    }

    private void setWakeupTime(long l) {
        this.wakeupTime = l;
    }

    private long getWakeupTime() {
        return this.wakeupTime;
    }
}

