/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.content.ContentManager;
import jade.content.lang.Codec;
import jade.content.lang.leap.LEAPCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.domain.mobility.BehaviourLoadingOntology;
import jade.domain.mobility.LoadBehaviour;
import jade.domain.mobility.Parameter;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class LoaderBehaviour
extends Behaviour {
    private Codec codec = new LEAPCodec();
    private Ontology onto = BehaviourLoadingOntology.getInstance();
    private ContentManager myContentManager = new ContentManager();
    private MessageTemplate myTemplate = MessageTemplate.and(MessageTemplate.MatchPerformative(16), MessageTemplate.and(MessageTemplate.MatchLanguage(this.codec.getName()), MessageTemplate.MatchOntology(this.onto.getName())));
    private boolean finished = false;

    public LoaderBehaviour() {
        this.init();
    }

    public LoaderBehaviour(Agent agent) {
        super(agent);
        this.init();
    }

    public final void action() {
        if (!this.finished) {
            ACLMessage aCLMessage = this.myAgent.receive(this.myTemplate);
            if (aCLMessage != null) {
                ACLMessage aCLMessage2 = aCLMessage.createReply();
                if (this.accept(aCLMessage)) {
                    try {
                        Action action = (Action)this.myContentManager.extractContent(aCLMessage);
                        LoadBehaviour loadBehaviour = (LoadBehaviour)action.getAction();
                        String string = loadBehaviour.getClassName();
                        Behaviour behaviour = null;
                        byte[] byArray = loadBehaviour.getCode();
                        byte[] byArray2 = loadBehaviour.getZip();
                        behaviour = byArray != null ? this.loadFromCode(string, byArray) : (byArray2 != null ? this.loadFromZip(string, byArray2) : (Behaviour)Class.forName(string).newInstance());
                        List list = loadBehaviour.getParameters();
                        this.setInputParameters(behaviour, list);
                        SequentialBehaviour sequentialBehaviour = new SequentialBehaviour(this.myAgent);
                        sequentialBehaviour.addSubBehaviour(behaviour);
                        sequentialBehaviour.addSubBehaviour(new ResultCollector(behaviour, list, action, aCLMessage));
                        this.myAgent.addBehaviour(sequentialBehaviour);
                        aCLMessage2.setPerformative(1);
                    }
                    catch (Codec.CodecException codecException) {
                        codecException.printStackTrace();
                        aCLMessage2.setPerformative(10);
                        aCLMessage2.setContent("((unrecognised-value content))");
                    }
                    catch (OntologyException ontologyException) {
                        ontologyException.printStackTrace();
                        aCLMessage2.setPerformative(10);
                        aCLMessage2.setContent("((unrecognised-value content))");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        aCLMessage2.setPerformative(6);
                        aCLMessage2.setContent("((internal-error \"" + exception.toString() + "\"))");
                    }
                } else {
                    aCLMessage2.setPerformative(14);
                }
                this.myAgent.send(aCLMessage2);
            } else {
                this.block();
            }
        }
    }

    public boolean done() {
        return this.finished;
    }

    public void stop() {
        this.finished = true;
        this.restart();
    }

    protected void addBehaviour(Behaviour behaviour, ACLMessage aCLMessage) {
        this.myAgent.addBehaviour(behaviour);
    }

    protected boolean accept(ACLMessage aCLMessage) {
        return true;
    }

    private void init() {
        this.myContentManager.registerLanguage(this.codec);
        this.myContentManager.registerOntology(this.onto);
    }

    private Behaviour loadFromCode(String string, byte[] byArray) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Hashtable<String, byte[]> hashtable = new Hashtable<String, byte[]>(1);
        hashtable.put(string, byArray);
        return this.load(string, hashtable);
    }

    private Behaviour loadFromZip(String string, byte[] byArray) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Hashtable<String, byte[]> hashtable = new Hashtable<String, byte[]>();
        try {
            ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(byArray));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[1024];
                int n = zipInputStream.read(byArray2, 0, byArray2.length);
                while (n > 0) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                    n = zipInputStream.read(byArray2, 0, byArray2.length);
                }
                hashtable.put(zipEntry.getName(), byteArrayOutputStream.toByteArray());
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
            return this.load(string, hashtable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ClassNotFoundException("Error reading zip for class " + string + ". " + exception);
        }
    }

    private Behaviour load(String string, Hashtable hashtable) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        HashClassLoader hashClassLoader = new HashClassLoader(hashtable, this.getClass().getClassLoader());
        Class<?> clazz = hashClassLoader.loadClass(string);
        return (Behaviour)clazz.newInstance();
    }

    private void setInputParameters(Behaviour behaviour, List list) {
        DataStore dataStore = behaviour.getDataStore();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (parameter.getMode() != 0 && parameter.getMode() != 2) continue;
            dataStore.put(parameter.getName(), parameter.getValue());
        }
    }

    private void getOutputParameters(Behaviour behaviour, List list) {
        DataStore dataStore = behaviour.getDataStore();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (parameter.getMode() != 1 && parameter.getMode() != 2) continue;
            parameter.setValue(dataStore.get(parameter.getName()));
        }
    }

    private class ResultCollector
    extends OneShotBehaviour {
        private Behaviour myBehaviour;
        private List myParams;
        private Action actionExpr;
        private ACLMessage request;

        ResultCollector(Behaviour behaviour, List list, Action action, ACLMessage aCLMessage) {
            this.myBehaviour = behaviour;
            this.myParams = list;
            this.actionExpr = action;
            this.request = aCLMessage;
        }

        public void action() {
            LoadBehaviour loadBehaviour = (LoadBehaviour)this.actionExpr.getAction();
            loadBehaviour.setCode(null);
            loadBehaviour.setZip(null);
            LoaderBehaviour.this.getOutputParameters(this.myBehaviour, this.myParams);
            Result result = new Result(this.actionExpr, this.myParams);
            ACLMessage aCLMessage = this.request.createReply();
            try {
                LoaderBehaviour.this.myContentManager.fillContent(aCLMessage, result);
                aCLMessage.setPerformative(7);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                aCLMessage.setPerformative(6);
                aCLMessage.setContent("((internal-error \"" + exception.toString() + "\"))");
            }
            this.myAgent.send(aCLMessage);
        }
    }

    private class HashClassLoader
    extends ClassLoader {
        private Hashtable classes;

        public HashClassLoader(Hashtable hashtable, ClassLoader classLoader) {
            super(classLoader);
            this.classes = hashtable;
        }

        protected Class findClass(String string) throws ClassNotFoundException {
            String string2 = string.replace('.', '/') + ".class";
            byte[] byArray = (byte[])this.classes.get(string2);
            if (byArray != null) {
                return this.defineClass(string, byArray, 0, byArray.length);
            }
            throw new ClassNotFoundException("Class " + string + " does not exist");
        }
    }
}

