/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Node;
import jade.core.NodeEventListener;
import jade.core.nodeMonitoring.NodeMonitoringService;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import jade.util.leap.List;

public abstract class NodeFailureMonitor {
    private static NodeMonitoringService theMonitoringService;
    protected Node target;
    protected NodeEventListener listener;
    protected List childNodes = new LinkedList();

    public void start(Node node, NodeEventListener nodeEventListener) {
        this.target = node;
        this.listener = nodeEventListener;
    }

    public abstract void stop();

    public synchronized void addChild(Node node) {
        this.childNodes.add(node);
    }

    public synchronized void removeChild(Node node) {
        this.childNodes.remove(node);
    }

    public Node getNode() {
        return this.target;
    }

    protected synchronized void fireNodeAdded() {
        this.listener.nodeAdded(this.target);
        Iterator iterator = this.childNodes.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            this.listener.nodeAdded(node);
        }
    }

    protected synchronized void fireNodeRemoved() {
        this.listener.nodeRemoved(this.target);
        Iterator iterator = this.childNodes.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            this.listener.nodeRemoved(node);
        }
    }

    protected synchronized void fireNodeReachable() {
        this.listener.nodeReachable(this.target);
        Iterator iterator = this.childNodes.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            this.listener.nodeReachable(node);
        }
    }

    protected synchronized void fireNodeUnreachable() {
        this.listener.nodeUnreachable(this.target);
        Iterator iterator = this.childNodes.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            this.listener.nodeUnreachable(node);
        }
    }

    public static NodeFailureMonitor getFailureMonitor() {
        NodeFailureMonitor nodeFailureMonitor;
        block3: {
            nodeFailureMonitor = null;
            if (theMonitoringService != null) {
                nodeFailureMonitor = theMonitoringService.getFailureMonitor();
            }
            if (nodeFailureMonitor != null) break block3;
            try {
                nodeFailureMonitor = (NodeFailureMonitor)Class.forName("jade.core.nodeMonitoring.BlockingNodeFailureMonitor").newInstance();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return nodeFailureMonitor;
    }

    public static void init(NodeMonitoringService nodeMonitoringService) {
        theMonitoringService = nodeMonitoringService;
    }
}

