/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AID;
import jade.core.Agent;
import jade.util.leap.HashMap;
import jade.util.leap.Map;

class LADT {
    private Map agents;

    public LADT(int n) {
        this.agents = new HashMap(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent put(AID aID, Agent agent) {
        Row row;
        Map map = this.agents;
        synchronized (map) {
            row = (Row)this.agents.get(aID);
        }
        if (row == null) {
            this.agents.put(aID, new Row(agent));
            return null;
        }
        row.lock();
        this.agents.put(aID, new Row(agent));
        Agent agent2 = row.get();
        row.unlock();
        return agent2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent remove(AID aID) {
        Row row;
        Map map = this.agents;
        synchronized (map) {
            row = (Row)this.agents.get(aID);
        }
        if (row == null) {
            return null;
        }
        row.lock();
        this.agents.remove(aID);
        Agent agent = row.get();
        row.clear();
        row.unlock();
        return agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent acquire(AID aID) {
        Row row;
        Map map = this.agents;
        synchronized (map) {
            row = (Row)this.agents.get(aID);
        }
        if (row == null) {
            return null;
        }
        row.lock();
        return row.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(AID aID) {
        Row row;
        Map map = this.agents;
        synchronized (map) {
            row = (Row)this.agents.get(aID);
        }
        if (row != null) {
            row.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AID[] keys() {
        Map map = this.agents;
        synchronized (map) {
            Object[] objectArray = this.agents.keySet().toArray();
            AID[] aIDArray = new AID[objectArray.length];
            int n = 0;
            while (n < aIDArray.length) {
                aIDArray[n] = (AID)objectArray[n];
                ++n;
            }
            return aIDArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent[] values() {
        Map map = this.agents;
        synchronized (map) {
            Object[] objectArray = this.agents.values().toArray();
            Agent[] agentArray = new Agent[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                Row row = (Row)objectArray[n];
                agentArray[n] = row.get();
                ++n;
            }
            return agentArray;
        }
    }

    private static class Row {
        private Agent value;
        private Thread owner;
        private long depth;

        public Row(Agent agent) {
            this.value = agent;
            this.depth = 0L;
        }

        public synchronized Agent get() {
            return this.value;
        }

        public synchronized void clear() {
            this.value = null;
        }

        public synchronized void lock() {
            if (this.value != null) {
                try {
                    Thread thread = Thread.currentThread();
                    while (this.owner != null && this.owner != thread) {
                        this.wait();
                        if (this.value != null) continue;
                        return;
                    }
                    this.owner = thread;
                    ++this.depth;
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }

        public synchronized void unlock() {
            if (this.owner != Thread.currentThread()) {
                return;
            }
            --this.depth;
            if (this.depth == 0L || this.value == null) {
                this.owner = null;
                this.notifyAll();
            }
        }
    }
}

