/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.ContainerID;
import jade.core.NotFoundException;
import jade.mtp.MTPDescriptor;
import jade.util.Logger;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import jade.util.leap.Map;

class ContainerTable {
    private static final int CONTAINERS_SIZE = 10;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    private Map entries = new HashMap(10);

    ContainerTable() {
    }

    public synchronized void addContainer(ContainerID containerID) {
        Entry entry = new Entry();
        this.entries.put(containerID, entry);
    }

    public synchronized void addMTP(ContainerID containerID, MTPDescriptor mTPDescriptor) throws NotFoundException {
        Entry entry = (Entry)this.entries.get(containerID);
        if (entry == null) {
            throw new NotFoundException("No container named " + containerID.getName() + " was found.");
        }
        List list = entry.getMTPs();
        list.add(mTPDescriptor);
    }

    public synchronized void removeContainer(ContainerID containerID) {
        this.entries.remove(containerID);
        this.notifyAll();
    }

    public synchronized void removeMTP(ContainerID containerID, MTPDescriptor mTPDescriptor) throws NotFoundException {
        Entry entry = (Entry)this.entries.get(containerID);
        if (entry == null) {
            throw new NotFoundException("No container named " + containerID.getName() + " was found.");
        }
        List list = entry.getMTPs();
        list.remove(mTPDescriptor);
    }

    public synchronized List getMTPs(ContainerID containerID) throws NotFoundException {
        Entry entry = (Entry)this.entries.get(containerID);
        if (entry == null) {
            throw new NotFoundException("No container named " + containerID.getName() + " was found.");
        }
        return entry.getMTPs();
    }

    public int size() {
        return this.entries.size();
    }

    public synchronized ContainerID[] names() {
        ContainerID[] containerIDArray = new ContainerID[this.entries.size()];
        Iterator iterator = this.entries.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            containerIDArray[n++] = (ContainerID)iterator.next();
        }
        return containerIDArray;
    }

    synchronized boolean waitForRemoval(ContainerID containerID, long l) {
        try {
            while (this.entries.containsKey(containerID)) {
                this.wait(l);
                if (!this.entries.containsKey(containerID)) continue;
                this.myLogger.log(Logger.WARNING, "Container " + containerID.getName() + " did not terminate when requested to do so.");
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            this.myLogger.log(Logger.WARNING, "Interrupted while waiting for container " + containerID.getName() + " termination");
            return false;
        }
        return true;
    }

    synchronized boolean waitUntilEmpty(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        try {
            while (!this.entries.isEmpty()) {
                if (l > 0L && l2 >= l3) {
                    this.myLogger.log(Logger.WARNING, "Some entries still present in container table");
                    break;
                }
                this.wait(l3 - l2);
                l2 = System.currentTimeMillis();
            }
        }
        catch (InterruptedException interruptedException) {
            this.myLogger.log(Logger.WARNING, "Interrupted while waiting for container table to be empty");
        }
        return this.entries.isEmpty();
    }

    private static class Entry {
        private List mtps = new LinkedList();

        public void addMTP(MTPDescriptor mTPDescriptor) {
            this.mtps.add(mTPDescriptor);
        }

        public void removeMTP(MTPDescriptor mTPDescriptor) {
            this.mtps.remove(mTPDescriptor);
        }

        public List getMTPs() {
            return this.mtps;
        }
    }
}

