/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Filter;
import jade.core.ServiceException;
import jade.core.Sink;
import jade.core.VerticalCommand;
import java.util.Hashtable;

class CommandProcessor {
    private Filter firstDownFilter;
    private Filter firstUpFilter;
    private final Hashtable downSinks = new Hashtable(4);
    private final Hashtable upSinks = new Hashtable(4);
    private SinksFilter lastDownFilter = new SinksFilter(this.downSinks);
    private SinksFilter lastUpFilter = new SinksFilter(this.upSinks);

    public CommandProcessor() {
        this.firstDownFilter = this.lastDownFilter;
        this.firstUpFilter = this.lastUpFilter;
    }

    public void addFilter(Filter filter, boolean bl) {
        if (!bl) {
            this.firstUpFilter = this.insertFilter(filter, this.firstUpFilter);
        } else {
            this.firstDownFilter = this.insertFilter(filter, this.firstDownFilter);
        }
    }

    private synchronized Filter insertFilter(Filter filter, Filter filter2) {
        if (filter != null) {
            if (filter.getPreferredPosition() < filter2.getPreferredPosition()) {
                filter.setNext(filter2);
                return filter;
            }
            Filter filter3 = filter2;
            Filter filter4 = filter3.getNext();
            while (true) {
                if (filter.getPreferredPosition() < filter4.getPreferredPosition()) {
                    filter.setNext(filter4);
                    filter3.setNext(filter);
                    break;
                }
                filter3 = filter4;
                filter4 = filter3.getNext();
            }
        }
        return filter2;
    }

    public void removeFilter(Filter filter, boolean bl) {
        if (!bl) {
            this.firstUpFilter = this.removeFilter(filter, this.firstUpFilter);
        } else {
            this.firstDownFilter = this.removeFilter(filter, this.firstDownFilter);
        }
    }

    private synchronized Filter removeFilter(Filter filter, Filter filter2) {
        if (filter2 != null && filter != null) {
            if (filter.equals(filter2)) {
                return filter2.getNext();
            }
            Filter filter3 = filter2;
            Filter filter4 = filter3.getNext();
            while (true) {
                if (filter.equals(filter4)) {
                    filter3.setNext(filter4.getNext());
                    break;
                }
                filter3 = filter4;
                filter4 = filter3.getNext();
            }
        }
        return filter2;
    }

    public synchronized void registerSink(Sink sink, boolean bl, String string) throws ServiceException {
        Hashtable hashtable = !bl ? this.downSinks : this.upSinks;
        hashtable.put(string, sink);
    }

    public synchronized void deregisterSink(boolean bl, String string) throws ServiceException {
        Hashtable hashtable = !bl ? this.downSinks : this.upSinks;
        hashtable.remove(string);
    }

    public Object processOutgoing(VerticalCommand verticalCommand) {
        this.firstDownFilter.filter(verticalCommand);
        return verticalCommand.getReturnValue();
    }

    public Object processIncoming(VerticalCommand verticalCommand) {
        this.firstUpFilter.filter(verticalCommand);
        return verticalCommand.getReturnValue();
    }

    private class SinksFilter
    extends Filter {
        private Hashtable mySinks;

        private SinksFilter(Hashtable hashtable) {
            this.mySinks = hashtable;
            this.preferredPosition = 101;
        }

        protected boolean accept(VerticalCommand verticalCommand) {
            Sink sink;
            String string = verticalCommand.getService();
            if (string != null && (sink = (Sink)this.mySinks.get(string)) != null) {
                sink.consume(verticalCommand);
            }
            return false;
        }
    }
}

