/*
 * Decompiled with CFR 0.152.
 */
package jade.content.schema;

import jade.content.abs.AbsObject;
import jade.content.onto.BasicOntology;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.Facet;
import jade.content.schema.ObjectSchema;
import jade.content.schema.facets.CardinalityFacet;
import jade.content.schema.facets.TypedAggregateFacet;
import jade.core.CaseInsensitiveString;
import jade.util.Logger;
import jade.util.leap.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class ObjectSchemaImpl
extends ObjectSchema {
    private Logger logger = Logger.getMyLogger(this.getClass().getName());
    private String typeName = null;
    private Hashtable slots;
    private Vector slotNames;
    private Vector superSchemas;
    private Hashtable facets;

    private ObjectSchemaImpl() {
        this("Object");
    }

    protected ObjectSchemaImpl(String string) {
        this.typeName = string;
    }

    protected void add(String string, ObjectSchema objectSchema, int n) {
        CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string);
        if (this.slots == null) {
            this.slots = new Hashtable();
            this.slotNames = new Vector();
        }
        if (this.slots.put(caseInsensitiveString, new SlotDescriptor(string, objectSchema, n)) == null) {
            this.slotNames.addElement(caseInsensitiveString);
        }
    }

    protected void add(String string, ObjectSchema objectSchema) {
        this.add(string, objectSchema, 0);
    }

    protected void add(String string, ObjectSchema objectSchema, int n, int n2) {
        this.add(string, objectSchema, n, n2, "sequence");
    }

    protected void add(String string, ObjectSchema objectSchema, int n, int n2, String string2) {
        int n3 = n == 0 ? 1 : 0;
        try {
            this.add(string, BasicOntology.getInstance().getSchema(string2), n3);
            this.addFacet(string, new TypedAggregateFacet(objectSchema));
            this.addFacet(string, new CardinalityFacet(n, n2));
        }
        catch (OntologyException ontologyException) {
            ontologyException.printStackTrace();
        }
    }

    protected void addSuperSchema(ObjectSchema objectSchema) {
        if (this.superSchemas == null) {
            this.superSchemas = new Vector();
        }
        this.superSchemas.addElement(objectSchema);
    }

    protected void addFacet(String string, Facet facet) throws OntologyException {
        Vector<Facet> vector;
        if (this.containsSlot(string)) {
            CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string);
            if (this.facets == null) {
                this.facets = new Hashtable();
            }
            if ((vector = (Vector<Facet>)this.facets.get(caseInsensitiveString)) == null) {
                vector = new Vector<Facet>();
                this.facets.put(caseInsensitiveString, vector);
                if (this.logger.isLoggable(Logger.CONFIG)) {
                    this.logger.log(Logger.CONFIG, "Added facet " + facet + " to slot " + string);
                }
            }
        } else {
            throw new OntologyException(string + " is not a valid slot in this schema");
        }
        vector.addElement(facet);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String[] getNames() {
        Vector vector = new Vector();
        this.fillAllSlotNames(vector);
        String[] stringArray = new String[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = ((CaseInsensitiveString)enumeration.nextElement()).toString();
        }
        return stringArray;
    }

    public ObjectSchema getSchema(String string) throws OntologyException {
        SlotDescriptor slotDescriptor = this.getSlot(new CaseInsensitiveString(string));
        if (slotDescriptor == null) {
            throw new OntologyException("No slot named: " + string);
        }
        return slotDescriptor.schema;
    }

    public boolean containsSlot(String string) {
        SlotDescriptor slotDescriptor = this.getSlot(new CaseInsensitiveString(string));
        return slotDescriptor != null;
    }

    public boolean isMandatory(String string) throws OntologyException {
        SlotDescriptor slotDescriptor = this.getSlot(new CaseInsensitiveString(string));
        if (slotDescriptor == null) {
            throw new OntologyException("No slot named: " + string);
        }
        return slotDescriptor.optionality == 0;
    }

    public AbsObject newInstance() throws OntologyException {
        throw new OntologyException("AbsObject cannot be instantiated");
    }

    private final void fillAllSlotNames(Vector vector) {
        Enumeration enumeration;
        if (this.superSchemas != null) {
            enumeration = this.superSchemas.elements();
            while (enumeration.hasMoreElements()) {
                ObjectSchemaImpl objectSchemaImpl = (ObjectSchemaImpl)enumeration.nextElement();
                objectSchemaImpl.fillAllSlotNames(vector);
            }
        }
        if (this.slotNames != null) {
            enumeration = this.slotNames.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
    }

    public void validate(AbsObject absObject, Ontology ontology) throws OntologyException {
        this.validateSlots(absObject, ontology);
    }

    protected void validateSlots(AbsObject absObject, Ontology ontology) throws OntologyException {
        String[] stringArray = this.getNames();
        int n = 0;
        while (n < stringArray.length) {
            AbsObject absObject2 = absObject.getAbsObject(stringArray[n]);
            CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(stringArray[n]);
            this.validate(caseInsensitiveString, absObject2, ontology);
            ++n;
        }
    }

    private boolean validate(CaseInsensitiveString caseInsensitiveString, AbsObject absObject, Ontology ontology) throws OntologyException {
        Object object;
        Object object2;
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Validating " + absObject + " as a value for slot " + caseInsensitiveString);
        }
        boolean bl = false;
        SlotDescriptor slotDescriptor = this.getOwnSlot(caseInsensitiveString);
        if (slotDescriptor != null) {
            if (this.logger.isLoggable(Logger.CONFIG)) {
                this.logger.log(Logger.CONFIG, "Slot " + caseInsensitiveString + " is defined in schema " + this);
            }
            if (absObject == null) {
                if (slotDescriptor.optionality == 0) {
                    throw new OntologyException("Missing value for mandatory slot " + caseInsensitiveString + ". Schema is " + this);
                }
                return true;
            }
            object2 = ontology.getSchema(absObject.getTypeName());
            if (this.logger.isLoggable(Logger.CONFIG)) {
                this.logger.log(Logger.CONFIG, "Actual schema for " + absObject + " is " + object2);
            }
            if (object2 == null) {
                throw new OntologyException("No schema found for type " + absObject.getTypeName());
            }
            if (!((ObjectSchema)object2).isCompatibleWith(slotDescriptor.schema)) {
                throw new OntologyException("Schema " + object2 + " for element " + absObject + " is not compatible with schema " + slotDescriptor.schema + " for slot " + caseInsensitiveString);
            }
            if (this.logger.isLoggable(Logger.CONFIG)) {
                this.logger.log(Logger.CONFIG, "Schema " + object2 + " for type " + absObject + " is compatible with schema " + slotDescriptor.schema + " for slot " + caseInsensitiveString);
            }
            ((ObjectSchema)object2).validate(absObject, ontology);
            bl = true;
        } else if (this.superSchemas != null) {
            object2 = this.superSchemas.elements();
            while (object2.hasMoreElements()) {
                object = (ObjectSchemaImpl)object2.nextElement();
                if (!((ObjectSchemaImpl)object).validate(caseInsensitiveString, absObject, ontology)) continue;
                bl = true;
                break;
            }
        }
        if (bl && this.facets != null) {
            object2 = (Vector)this.facets.get(caseInsensitiveString);
            if (object2 != null) {
                object = ((Vector)object2).elements();
                while (object.hasMoreElements()) {
                    Facet facet = (Facet)object.nextElement();
                    if (this.logger.isLoggable(Logger.CONFIG)) {
                        this.logger.log(Logger.CONFIG, "Checking facet " + facet + " defined on slot " + caseInsensitiveString);
                    }
                    facet.validate(absObject, ontology);
                }
            } else if (this.logger.isLoggable(Logger.CONFIG)) {
                this.logger.log(Logger.CONFIG, "No facets for slot " + caseInsensitiveString);
            }
        }
        return bl;
    }

    public boolean isCompatibleWith(ObjectSchema objectSchema) {
        if (this.equals(objectSchema)) {
            return true;
        }
        if (this.isSubSchemaOf(objectSchema)) {
            return true;
        }
        return this.descendsFrom(objectSchema);
    }

    protected boolean descendsFrom(ObjectSchema objectSchema) {
        if (objectSchema != null) {
            return objectSchema.equals(ObjectSchema.getBaseSchema());
        }
        return false;
    }

    private boolean isSubSchemaOf(ObjectSchema objectSchema) {
        if (this.superSchemas != null) {
            Enumeration enumeration = this.superSchemas.elements();
            while (enumeration.hasMoreElements()) {
                ObjectSchemaImpl objectSchemaImpl = (ObjectSchemaImpl)enumeration.nextElement();
                if (objectSchemaImpl.equals(objectSchema)) {
                    return true;
                }
                if (!objectSchemaImpl.isSubSchemaOf(objectSchema)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "-" + this.getTypeName();
    }

    public boolean equals(Object object) {
        if (object != null) {
            return this.toString().equals(object.toString());
        }
        return false;
    }

    public Facet[] getFacets(String string) {
        Facet[] facetArray;
        block4: {
            block3: {
                Vector vector;
                facetArray = null;
                CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string);
                if (this.getOwnSlot(caseInsensitiveString) == null) break block3;
                if (this.facets == null || (vector = (Vector)this.facets.get(caseInsensitiveString)) == null) break block4;
                facetArray = new Facet[vector.size()];
                int n = 0;
                while (n < vector.size()) {
                    facetArray[n] = (Facet)vector.elementAt(n);
                    ++n;
                }
                break block4;
            }
            if (this.superSchemas != null) {
                int n = 0;
                while (n < this.superSchemas.size() && facetArray == null) {
                    facetArray = ((ObjectSchema)this.superSchemas.elementAt(n)).getFacets(string);
                    ++n;
                }
            }
        }
        return facetArray;
    }

    private final SlotDescriptor getOwnSlot(CaseInsensitiveString caseInsensitiveString) {
        return this.slots != null ? (SlotDescriptor)this.slots.get(caseInsensitiveString) : null;
    }

    private final SlotDescriptor getSlot(CaseInsensitiveString caseInsensitiveString) {
        SlotDescriptor slotDescriptor = this.getOwnSlot(caseInsensitiveString);
        if (slotDescriptor == null && this.superSchemas != null) {
            int n = 0;
            while (n < this.superSchemas.size()) {
                ObjectSchemaImpl objectSchemaImpl = (ObjectSchemaImpl)this.superSchemas.elementAt(n);
                slotDescriptor = objectSchemaImpl.getSlot(caseInsensitiveString);
                if (slotDescriptor != null) break;
                ++n;
            }
        }
        return slotDescriptor;
    }

    static {
        ObjectSchema.baseSchema = new ObjectSchemaImpl();
    }

    private class SlotDescriptor
    implements Serializable {
        private String name = null;
        private ObjectSchema schema = null;
        private int optionality = 0;

        private SlotDescriptor(String string, ObjectSchema objectSchema, int n) {
            this.name = string;
            this.schema = objectSchema;
            this.optionality = n;
        }
    }
}

