/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.onto.Introspector;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.schema.AggregateSchema;
import jade.content.schema.ObjectSchema;
import jade.core.CaseInsensitiveString;
import jade.util.leap.List;
import java.lang.reflect.Method;

public class ReflectiveIntrospector
implements Introspector {
    public AbsObject externalise(Object object, ObjectSchema objectSchema, Class clazz, Ontology ontology) throws OntologyException {
        try {
            AbsObject absObject = objectSchema.newInstance();
            String[] stringArray = objectSchema.getNames();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                String string2 = "get" + this.translateName(string);
                Method method = this.findMethodCaseInsensitive(string2, clazz);
                Object object2 = this.invokeAccessorMethod(method, object);
                if (object2 != null) {
                    Object object3;
                    ObjectSchema objectSchema2 = objectSchema.getSchema(string);
                    if (objectSchema2 instanceof AggregateSchema) {
                        object3 = (List)object2;
                        if (!object3.isEmpty() || objectSchema.isMandatory(string)) {
                            AbsAggregate absAggregate = AbsHelper.externaliseList((List)object3, ontology, objectSchema2.getTypeName());
                            AbsHelper.setAttribute(absObject, string, absAggregate);
                        }
                    } else {
                        object3 = ontology.fromObject(object2);
                        AbsHelper.setAttribute(absObject, string, (AbsObject)object3);
                    }
                }
                ++n;
            }
            return absObject;
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (Throwable throwable) {
            throw new OntologyException("Schema and Java class do not match", throwable);
        }
    }

    protected Object invokeAccessorMethod(Method method, Object object) throws OntologyException {
        try {
            return method.invoke(object, (Object[])null);
        }
        catch (Exception exception) {
            throw new OntologyException("Error invoking accessor method " + method.getName() + " on object " + object, exception);
        }
    }

    public Object internalise(AbsObject absObject, ObjectSchema objectSchema, Class clazz, Ontology ontology) throws UngroundedException, OntologyException {
        try {
            Object t = clazz.newInstance();
            String[] stringArray = objectSchema.getNames();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                AbsObject absObject2 = absObject.getAbsObject(string);
                if (absObject2 != null) {
                    Object object = ontology.toObject(absObject2);
                    String string2 = "set" + this.translateName(string);
                    Method method = this.findMethodCaseInsensitive(string2, clazz);
                    this.invokeSetterMethod(method, t, object);
                }
                ++n;
            }
            return t;
        }
        catch (OntologyException ontologyException) {
            throw ontologyException;
        }
        catch (InstantiationException instantiationException) {
            throw new OntologyException("Class " + clazz + " can't be instantiated", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new OntologyException("Class " + clazz + " does not have an accessible constructor", illegalAccessException);
        }
        catch (Throwable throwable) {
            throw new OntologyException("Schema and Java class do not match", throwable);
        }
    }

    protected void invokeSetterMethod(Method method, Object object, Object object2) throws OntologyException {
        try {
            Object[] objectArray = new Object[]{object2};
            try {
                method.invoke(object, objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (object2 instanceof Long) {
                    Integer n = new Integer((int)((Long)object2).longValue());
                    objectArray[0] = n;
                } else if (object2 instanceof Double) {
                    Float f = new Float((float)((Double)object2).doubleValue());
                    objectArray[0] = f;
                }
                method.invoke(object, objectArray);
            }
        }
        catch (Exception exception) {
            throw new OntologyException("Error invoking setter method " + method.getName() + " on object " + object + " with parameter " + object2, exception);
        }
    }

    public void checkClass(ObjectSchema objectSchema, Class clazz, Ontology ontology) throws OntologyException {
    }

    protected Method findMethodCaseInsensitive(String string, Class clazz) throws OntologyException {
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            String string2 = methodArray[n].getName();
            if (CaseInsensitiveString.equalsIgnoreCase(string2, string)) {
                return methodArray[n];
            }
            ++n;
        }
        throw new OntologyException("Method " + string + " not found in class " + clazz.getName());
    }

    protected String translateName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case ':': {
                    break;
                }
                case '-': {
                    bl = true;
                    break;
                }
                default: {
                    if (bl) {
                        stringBuffer.append(Character.toUpperCase(c));
                        bl = false;
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

