/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.sl;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsConcept;
import jade.content.abs.AbsContentElement;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsTerm;
import jade.content.abs.AbsVariable;
import jade.content.lang.Codec;
import jade.content.lang.StringCodec;
import jade.content.lang.sl.SLOntology;
import jade.content.lang.sl.SimpleSLTokenizer;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.schema.ObjectSchema;
import jade.core.CaseInsensitiveString;
import jade.lang.acl.ISO8601;
import jade.util.Logger;
import jade.util.leap.Iterator;

class SimpleSLCodec
extends StringCodec {
    private int indent = 0;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());

    public SimpleSLCodec() {
        super("fipa-sl");
    }

    public String encode(Ontology ontology, AbsContentElement absContentElement) throws Codec.CodecException {
        StringBuffer stringBuffer = new StringBuffer("(");
        if (absContentElement instanceof AbsContentElementList) {
            Iterator iterator = ((AbsContentElementList)absContentElement).iterator();
            while (iterator.hasNext()) {
                AbsObject absObject = (AbsObject)iterator.next();
                this.stringify(absObject, ontology, stringBuffer);
                stringBuffer.append(" ");
            }
        } else {
            this.stringify(absContentElement, ontology, stringBuffer);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void stringify(AbsObject absObject, Ontology ontology, StringBuffer stringBuffer) throws Codec.CodecException {
        if (absObject instanceof AbsPrimitive) {
            this.stringifyPrimitive((AbsPrimitive)absObject, stringBuffer);
        } else if (absObject instanceof AbsVariable) {
            this.stringifyVariable((AbsVariable)absObject, stringBuffer);
        } else if (absObject instanceof AbsAggregate) {
            this.stringifyAggregate((AbsAggregate)absObject, ontology, stringBuffer);
        } else {
            this.stringifyComplex(absObject, ontology, stringBuffer);
        }
    }

    private void stringifyComplex(AbsObject absObject, Ontology ontology, StringBuffer stringBuffer) throws Codec.CodecException {
        stringBuffer.append("(");
        stringBuffer.append(absObject.getTypeName());
        ObjectSchema objectSchema = null;
        try {
            objectSchema = ontology.getSchema(absObject.getTypeName());
        }
        catch (OntologyException ontologyException) {
            throw new Codec.CodecException("Error getting the schema for element " + absObject, ontologyException);
        }
        if (absObject instanceof AbsConcept && !objectSchema.getEncodingByOrder()) {
            this.encodeSlotsByName(absObject, absObject.getNames(), ontology, stringBuffer);
        } else {
            this.encodeSlotsByOrder(absObject, objectSchema.getNames(), ontology, stringBuffer);
        }
        stringBuffer.append(")");
    }

    private void encodeSlotsByOrder(AbsObject absObject, String[] stringArray, Ontology ontology, StringBuffer stringBuffer) throws Codec.CodecException {
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            AbsObject absObject2 = absObject.getAbsObject(stringArray[n]);
            if (absObject2 != null) {
                if (bl) {
                    throw new Codec.CodecException("Non-empty slot " + stringArray[n] + " follows empty slot " + stringArray[n - 1]);
                }
                stringBuffer.append(" ");
                this.stringify(absObject2, ontology, stringBuffer);
            } else {
                bl = true;
            }
            ++n;
        }
    }

    private void encodeSlotsByName(AbsObject absObject, String[] stringArray, Ontology ontology, StringBuffer stringBuffer) throws Codec.CodecException {
        int n = 0;
        while (n < stringArray.length) {
            AbsObject absObject2 = absObject.getAbsObject(stringArray[n]);
            if (absObject2 != null) {
                stringBuffer.append(" :");
                stringBuffer.append(stringArray[n]);
                stringBuffer.append(" ");
                this.stringify(absObject2, ontology, stringBuffer);
            }
            ++n;
        }
    }

    private void stringifyAggregate(AbsAggregate absAggregate, Ontology ontology, StringBuffer stringBuffer) throws Codec.CodecException {
        stringBuffer.append("(");
        stringBuffer.append(absAggregate.getTypeName());
        Iterator iterator = absAggregate.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" ");
            this.stringify((AbsObject)iterator.next(), ontology, stringBuffer);
        }
        stringBuffer.append(")");
    }

    private void stringifyVariable(AbsVariable absVariable, StringBuffer stringBuffer) throws Codec.CodecException {
        stringBuffer.append("?");
        stringBuffer.append(absVariable.getName());
    }

    private void stringifyPrimitive(AbsPrimitive absPrimitive, StringBuffer stringBuffer) throws Codec.CodecException {
        String string = absPrimitive.getTypeName();
        if (string.equals("BO_String")) {
            String string2 = absPrimitive.getString();
            if (CaseInsensitiveString.equalsIgnoreCase("true", string2) || CaseInsensitiveString.equalsIgnoreCase("false", string2)) {
                string2 = '\"' + string2 + '\"';
            } else if (!SimpleSLTokenizer.isAWord(string2)) {
                string2 = SimpleSLTokenizer.quoteString(string2);
            }
            stringBuffer.append(string2);
        } else if (string.equals("BO_Date")) {
            stringBuffer.append(ISO8601.toString(absPrimitive.getDate()));
        } else {
            if (string.equals("BO_Byte-sequence")) {
                throw new Codec.CodecException("SL_does_not_allow_encoding_sequencesOfBytes");
            }
            stringBuffer.append(absPrimitive.getObject().toString());
        }
    }

    public AbsContentElement decode(Ontology ontology, String string) throws Codec.CodecException {
        SimpleSLTokenizer simpleSLTokenizer = new SimpleSLTokenizer(string);
        try {
            simpleSLTokenizer.consumeChar('(');
            AbsContentElement absContentElement = (AbsContentElement)this.parse(simpleSLTokenizer, ontology);
            if (!simpleSLTokenizer.nextToken().equals(")")) {
                AbsContentElementList absContentElementList = new AbsContentElementList();
                absContentElementList.add(absContentElement);
                do {
                    AbsContentElement absContentElement2 = (AbsContentElement)this.parse(simpleSLTokenizer, ontology);
                    absContentElementList.add(absContentElement2);
                } while (!simpleSLTokenizer.nextToken().equals(")"));
                absContentElement = absContentElementList;
            }
            simpleSLTokenizer.consumeChar(')');
            return absContentElement;
        }
        catch (ClassCastException classCastException) {
            throw new Codec.CodecException("Error converting to AbsContentElement", classCastException);
        }
    }

    private AbsObject parse(SimpleSLTokenizer simpleSLTokenizer, Ontology ontology) throws Codec.CodecException {
        AbsObject absObject = null;
        absObject = simpleSLTokenizer.nextToken().startsWith("(") ? this.parseComplex(simpleSLTokenizer, ontology) : this.parseSimple(simpleSLTokenizer);
        return absObject;
    }

    private AbsObject parseComplex(SimpleSLTokenizer simpleSLTokenizer, Ontology ontology) throws Codec.CodecException {
        AbsObject absObject = null;
        simpleSLTokenizer.consumeChar('(');
        String string = simpleSLTokenizer.getElement();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Parse complex descriptor: " + string);
        }
        ++this.indent;
        try {
            ObjectSchema objectSchema = ontology.getSchema(string);
            absObject = objectSchema.newInstance();
            if (absObject instanceof AbsAggregate) {
                this.fillAggregate((AbsAggregate)absObject, simpleSLTokenizer, ontology);
            } else if (simpleSLTokenizer.nextToken().startsWith(":")) {
                this.fillSlotsByName((AbsConcept)absObject, simpleSLTokenizer, ontology);
            } else {
                this.fillSlotsByOrder(absObject, objectSchema, simpleSLTokenizer, ontology);
            }
        }
        catch (Codec.CodecException codecException) {
            throw codecException;
        }
        catch (Throwable throwable) {
            throw new Codec.CodecException("Unexpeceted error parsing " + string, throwable);
        }
        --this.indent;
        simpleSLTokenizer.consumeChar(')');
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, absObject.toString());
        }
        return absObject;
    }

    private void fillSlotsByOrder(AbsObject absObject, ObjectSchema objectSchema, SimpleSLTokenizer simpleSLTokenizer, Ontology ontology) throws Codec.CodecException {
        String[] stringArray = objectSchema.getNames();
        int n = 0;
        while (!simpleSLTokenizer.nextToken().startsWith(")")) {
            AbsObject absObject2 = this.parse(simpleSLTokenizer, ontology);
            try {
                AbsHelper.setAttribute(absObject, stringArray[n], absObject2);
                ++n;
            }
            catch (OntologyException ontologyException) {
                throw new Codec.CodecException("Can't assign " + absObject2 + " to slot " + stringArray[n] + " of " + absObject);
            }
        }
    }

    private void fillSlotsByName(AbsConcept absConcept, SimpleSLTokenizer simpleSLTokenizer, Ontology ontology) throws Codec.CodecException {
        while (!simpleSLTokenizer.nextToken().startsWith(")")) {
            String string = simpleSLTokenizer.getElement();
            try {
                AbsTerm absTerm = (AbsTerm)this.parse(simpleSLTokenizer, ontology);
                absConcept.set(string, absTerm);
            }
            catch (ClassCastException classCastException) {
                throw new Codec.CodecException("Non Term value for slot " + string + " of Concept " + absConcept);
            }
        }
    }

    private void fillAggregate(AbsAggregate absAggregate, SimpleSLTokenizer simpleSLTokenizer, Ontology ontology) throws Codec.CodecException {
        int n = 0;
        while (!simpleSLTokenizer.nextToken().startsWith(")")) {
            try {
                AbsTerm absTerm = (AbsTerm)this.parse(simpleSLTokenizer, ontology);
                absAggregate.add(absTerm);
                ++n;
            }
            catch (ClassCastException classCastException) {
                throw new Codec.CodecException("Non Term value for element " + n + " of Aggregate " + absAggregate);
            }
        }
    }

    private AbsObject parseSimple(SimpleSLTokenizer simpleSLTokenizer) throws Codec.CodecException {
        String string = simpleSLTokenizer.getElement();
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "Parse simple descriptor: " + string + ". Next is " + simpleSLTokenizer.nextToken());
        }
        try {
            return AbsPrimitive.wrap(Long.parseLong(string));
        }
        catch (Exception exception) {
            try {
                return AbsPrimitive.wrap(Double.valueOf(string));
            }
            catch (Exception exception2) {
                try {
                    return AbsPrimitive.wrap(ISO8601.toDate(string));
                }
                catch (Exception exception3) {
                    if (string.equals("true")) {
                        return AbsPrimitive.wrap(true);
                    }
                    if (string.equals("false")) {
                        return AbsPrimitive.wrap(false);
                    }
                    if (string.startsWith("?")) {
                        return new AbsVariable(string.substring(1, string.length()), null);
                    }
                    if (string.startsWith("\"")) {
                        return AbsPrimitive.wrap(string.substring(1, string.length() - 1));
                    }
                    return AbsPrimitive.wrap(string);
                }
            }
        }
    }

    public AbsContentElement decode(String string) throws Codec.CodecException {
        throw new Codec.CodecException("Unsupported operation");
    }

    public String encode(AbsContentElement absContentElement) throws Codec.CodecException {
        throw new Codec.CodecException("Unsupported operation");
    }

    public Ontology getInnerOntology() {
        return SLOntology.getInstance();
    }
}

