/*
 * Decompiled with CFR 0.152.
 */
package jade;

import jade.BootException;
import jade.BootGUI;
import jade.BootProfileImpl;
import jade.core.Runtime;
import jade.util.BasicProperties;
import jade.util.PropertiesException;
import java.io.File;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class Boot {
    private static final String NAME2CLASS_SEPARATOR = ":";
    private BasicProperties properties = null;
    private BootProfileImpl profile = null;

    public static void main(String[] stringArray) {
        new Boot(stringArray);
    }

    public Boot(String[] stringArray) {
        try {
            this.profile = new BootProfileImpl(this.prepareArgs(stringArray));
        }
        catch (PropertiesException propertiesException) {
            System.out.println(propertiesException);
            System.exit(-1);
        }
        this.properties = this.profile.getArgProperties();
        if (this.properties.getBooleanProperty("dump", false)) {
            this.listProperties(System.out);
        }
        if (this.properties.getBooleanProperty("version", false)) {
            System.out.println(Runtime.getCopyrightNotice());
            return;
        }
        if (this.properties.getBooleanProperty("help", false)) {
            this.usage(System.out);
            return;
        }
        if (this.properties.getProperty("host") == null) {
            try {
                this.properties.setProperty("host", InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                System.out.print("Unknown host exception in getLocalHost(): ");
                System.out.println(" please use '-host' and/or '-port' options to setup JADE host and port");
                System.exit(1);
            }
        }
        if (this.properties.getBooleanProperty("conf", false)) {
            new BootGUI(this);
            if (this.properties.getBooleanProperty("dump", false)) {
                this.listProperties(System.out);
            }
        }
        try {
            this.check();
            Runtime.instance().setCloseVM(true);
            if (this.profile.getBooleanProperty("main", true)) {
                Runtime.instance().createMainContainer(this.profile);
            } else {
                Runtime.instance().createAgentContainer(this.profile);
            }
        }
        catch (BootException bootException) {
            System.err.println(bootException);
            return;
        }
    }

    protected String[] prepareArgs(String[] stringArray) {
        boolean bl;
        int n;
        boolean bl2 = false;
        if (stringArray != null && stringArray.length != 0) {
            n = 0;
            bl = false;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].startsWith("import:")) {
                    int n3 = stringArray[n2].indexOf(58);
                    n = n3 < stringArray[n2].length() - 1 && this.isFileName(stringArray[n2].substring(n3 + 1)) ? 1 : 0;
                    bl = n == 0;
                } else if (stringArray[n2].startsWith("agents:")) {
                    n = 1;
                } else if (stringArray[n2].startsWith("-") && bl) {
                    n = 1;
                }
                ++n2;
            }
            if (n != 0) {
                return stringArray;
            }
        }
        n = 0;
        bl = false;
        Vector<String> vector = new Vector<String>();
        while (n < stringArray.length && !bl) {
            String string = stringArray[n];
            if (string.equalsIgnoreCase("-conf")) {
                if (++n == stringArray.length) {
                    vector.add(string);
                } else {
                    String string2 = stringArray[n];
                    if (this.isFileName(string2)) {
                        vector.add("import:" + string2);
                    } else {
                        vector.add(string);
                        --n;
                    }
                }
            } else if (string.equalsIgnoreCase("-host")) {
                if (++n == stringArray.length) {
                    System.err.println("Missing host name ");
                    bl2 = true;
                } else {
                    vector.add("host:" + stringArray[n]);
                }
            } else if (string.equalsIgnoreCase("-owner")) {
                if (++n == stringArray.length) {
                    vector.add("owner::");
                } else {
                    vector.add("owner:" + stringArray[n]);
                }
            } else if (string.equalsIgnoreCase("-name")) {
                if (++n == stringArray.length) {
                    System.err.println("Missing platform name");
                    bl2 = true;
                } else {
                    vector.add("name:" + stringArray[n]);
                }
            } else if (string.equalsIgnoreCase("-imtp")) {
                if (++n == stringArray.length) {
                    System.err.println("Missing IMTP class");
                    bl2 = true;
                } else {
                    vector.add("imtp:" + stringArray[n]);
                }
            } else if (string.equalsIgnoreCase("-port")) {
                if (++n == stringArray.length) {
                    System.err.println("Missing port number");
                    bl2 = true;
                } else {
                    try {
                        Integer.parseInt(stringArray[n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Wrong int for the port number");
                        bl2 = true;
                    }
                    vector.add("port:" + stringArray[n]);
                }
            } else if (string.equalsIgnoreCase("-container")) {
                vector.add(string);
            } else if (string.equalsIgnoreCase("-backupmain")) {
                vector.add(string);
            } else if (string.equalsIgnoreCase("-gui")) {
                vector.add(string);
            } else if (string.equalsIgnoreCase("-version") || string.equalsIgnoreCase("-v")) {
                vector.add("-version");
            } else if (string.equalsIgnoreCase("-help") || string.equalsIgnoreCase("-h")) {
                vector.add("-help");
            } else if (string.equalsIgnoreCase("-nomtp")) {
                vector.add(string);
            } else if (string.equalsIgnoreCase("-nomobility")) {
                vector.add(string);
            } else if (string.equalsIgnoreCase("-dump")) {
                vector.add(string);
            } else if (string.equalsIgnoreCase("-mtp")) {
                if (++n == stringArray.length) {
                    System.err.println("Missing mtp specifiers");
                    bl2 = true;
                } else {
                    vector.add("mtp:" + stringArray[n]);
                }
            } else if (string.equalsIgnoreCase("-aclcodec")) {
                if (++n == stringArray.length) {
                    System.err.println("Missing aclcodec specifiers");
                    bl2 = true;
                } else {
                    vector.add("aclcodec:" + stringArray[n]);
                }
            } else if (string.startsWith("-") && n + 1 < stringArray.length) {
                vector.add(string.substring(1) + NAME2CLASS_SEPARATOR + stringArray[++n]);
            } else {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = --n;
            while (n4 < stringArray.length) {
                stringBuffer.append(stringArray[n4] + " ");
                ++n4;
            }
            vector.add("agents:" + stringBuffer.toString());
        }
        if (bl2) {
            vector.add("-help");
        }
        String[] stringArray2 = new String[vector.size()];
        int n5 = 0;
        while (n5 < stringArray2.length) {
            stringArray2[n5] = (String)vector.elementAt(n5);
            ++n5;
        }
        return stringArray2;
    }

    protected boolean isFileName(String string) {
        File file = new File(string);
        return file.exists();
    }

    public void usage(PrintStream printStream) {
        printStream.println("Usage: java jade.Boot [options] [agent specifiers]");
        printStream.println("");
        printStream.println("where options are:");
        printStream.println("  -host <host name>\tHost where RMI registry for the platform is located");
        printStream.println("  -port <port number>\tThe port where RMI registry for the platform resides");
        printStream.println("  -gui\t\t\tIf specified, a new Remote Management Agent is created.");
        printStream.println("  -container\t\tIf specified, a new Agent Container is added to an existing platform");
        printStream.println("  \t\t\tOtherwise a new Agent Platform is created");
        printStream.println("  -conf\t\t\tShows the gui to set the configuration properties to start JADE.");
        printStream.println("  -conf <file name>\tStarts JADE using the configuration properties read in the specified file.");
        printStream.println("  -dump\t\t\tIf specified, lists boot's current properties.");
        printStream.println("  -version\t\tIf specified, current JADE version number and build date is printed.");
        printStream.println("  -mtp\t\t\tSpecifies a list, separated by ';', of external Message Transport Protocols to be activated.");
        printStream.println("  \t\t\tBy default the HTTP-MTP is activated on the main-container and no MTP is activated on the other containers.");
        printStream.println("  -nomtp\t\tHas precedence over -mtp and overrides it.");
        printStream.println("  \t\t\tIt should be used to override the default behaviour of the main-container (by default the -nomtp option unselected).");
        printStream.println("  -aclcodec\t\tSpecifies a list, separated by ';', of ACLCodec to use. By default the string codec is used.");
        printStream.println("  -name <platform name>\tThe symbolic platform name specified only for the main container.");
        printStream.println("  -owner <username:password>\tThe owner of a container or platform.");
        printStream.println("  -nomobility\t\tIf specified, disables the mobility and cloning support for the container.");
        printStream.println("  -auth <Simple|Unix|NT|Kerberos>\tThe user authentication module to be used.");
        printStream.println("  -help\t\t\tPrints out usage informations.");
        printStream.println("  -<key> <value>\t\tApplication specific options.");
        printStream.println("");
        printStream.print("An agent specifier is composed of an agent name and an agent class, separated by \"");
        printStream.println(":\"");
        printStream.println("");
        printStream.println("Take care that the specified agent name represents only the local name of the agent.");
        printStream.println("Its guid (globally unique identifier) is instead assigned by the AMS after concatenating");
        printStream.println("the home agent platform identifier (e.g. john@foo.cselt.it:1099/JADE)");
        printStream.println("");
        printStream.println("Examples:");
        printStream.println("  Connect to default platform, starting an agent named 'peter'");
        printStream.println("  implemented in 'myAgent' class:");
        printStream.println("  \tjava jade.Boot -container peter:myAgent");
        printStream.println("");
        printStream.println("  Connect to a platform on host zork.zot.za, on port 1100,");
        printStream.println("  starting two agents");
        printStream.println("  java jade.Boot -container -host zork.zot.za -port 1100 peter:heAgent paula:sheAgent");
        printStream.println("");
        printStream.println("  Create an Agent Platform and starts an agent on the local Agent Container");
        printStream.println("  \tjava jade.Boot Willy:searchAgent");
        printStream.println("");
        System.exit(0);
    }

    public void listProperties(PrintStream printStream) {
        printStream.println("---------- Jade Boot property values ----------");
        Enumeration enumeration = this.properties.sortedKeys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            printStream.println(string + "=" + this.properties.getProperty(string));
        }
        printStream.println("-----------------------------------------------");
    }

    public BasicProperties getProperties() {
        return this.properties;
    }

    public void setProperties(BasicProperties basicProperties) throws BootException {
        this.properties.copyProperties(basicProperties);
        this.profile.setArgProperties(this.properties);
    }

    protected void check() throws BootException {
        try {
            Integer.parseInt(this.profile.getParameter("port", Integer.toString(1099)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new BootException("Malformed port number");
        }
        if (this.profile.getBooleanProperty("nomtp", false)) {
            if (this.profile.getParameter("mtp", null) != null) {
                throw new BootException("Error: If noMTP is set, you can't specify MTPs.");
            }
        }
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            InetAddress[] inetAddressArray2 = InetAddress.getAllByName(this.profile.getParameter("local-host", null));
            int n = 0;
            boolean bl = false;
            while (!bl && n < inetAddressArray.length) {
                int n2 = 0;
                while (!bl && n2 < inetAddressArray2.length) {
                    bl = inetAddressArray[n].equals(inetAddressArray2[n2]);
                    ++n2;
                }
                ++n;
            }
            if (!bl) {
                throw new BootException("Error: Not possible to launch JADE a remote host (" + this.properties.getProperty("local-host") + "). Check the -host and -local-host options.");
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new BootException("Error: Not possible to launch JADE an unknown host (" + this.properties.getProperty("local-host") + "). Check the -host and -local-host options.");
        }
    }
}

