Summary: GNU Scientific Library (GSL)
name: gsl
Packager: rosalia@lanl.gov
%define version 1.3
%define release 0
version: %{version}
release: %{release}
#Prereq: 
#requires: 
vendor: The GSL Team
Distribution: research software
copyright: Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002 The GSL Team
source: gsl-%{version}.tar.gz
group: Libraries/Research
%define mybuildroot /var/tmp/%{name}-build
%define installroot /install-tmp
BuildRoot: %{mybuildroot}

%description
  The GNU Scientific Library (GSL) is a numerical library for C and
C++ programmers.  It contains over 1000 mathematical routines written
in ANSI C.  The library follows modern coding conventions, and lends
itself to being used in very high level languages (VHLLs).

The library covers the following subject areas:

  Complex Numbers             Roots of Polynomials     Special Functions
  Vectors and Matrices        Permutations             Sorting
  BLAS Support                Linear Algebra           Eigensystems
  Fast Fourier Transforms     Quadrature               Random Numbers
  Quasi-Random Sequences      Random Distributions     Statistics
  Histograms                  N-Tuples                 Monte Carlo Integration
  Simulated Annealing         Differential Equations   Interpolation
  Numerical Differentiation   Chebyshev Approximation  Series Acceleration
  Discrete Hankel Transforms  Root-Finding             Minimization
  Least-Squares Fitting       Physical Constants       IEEE Floating-Point

Further information can be found in the GSL Reference Manual.

Install the gsl package if you need a library for high-level
scientific numerical analysis.

%prep
%setup -c
echo "dude, mybuildroot is " %{mybuildroot}
echo "dude, installroot is " %{installroot}
echo "dude, RPM_BUILD_ROOT is " $RPM_BUILD_ROOT

%build
cd %{name}-%{version}; ./configure --prefix=/usr; make

%install
cd %{name}-%{version}; make install prefix=%{mybuildroot}/usr
#cd %{name}-%{version}; make install prefix=%{mybuildroot}/%{installroot}

%post

%postun

%files
%doc %{name}-%{version}/{NEWS,ChangeLog,INSTALL,README,AUTHORS,THANKS,BUGS}
%doc /usr/info/gsl-ref*
/usr/bin/gsl-config
/usr/bin/gsl-histogram
/usr/bin/gsl-randist
/usr/lib
/usr/include/gsl
/usr/share/aclocal/gsl.m4
